/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dataproperties;

import java.util.Iterator;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.dag.OptimizerNode;
import org.apache.flink.compiler.dataproperties.GlobalProperties;
import org.apache.flink.compiler.dataproperties.PartitioningProperty;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.util.Utils;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;

public final class RequestedGlobalProperties
implements Cloneable {
    private PartitioningProperty partitioning = PartitioningProperty.RANDOM;
    private FieldSet partitioningFields;
    private Ordering ordering;
    private DataDistribution dataDistribution;

    public void setHashPartitioned(FieldSet partitionedFields) {
        if (partitionedFields == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.HASH_PARTITIONED;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
    }

    public void setRangePartitioned(Ordering ordering) {
        this.setRangePartitioned(ordering, null);
    }

    public void setRangePartitioned(Ordering ordering, DataDistribution dataDistribution) {
        if (ordering == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.RANGE_PARTITIONED;
        this.ordering = ordering;
        this.partitioningFields = null;
        this.dataDistribution = dataDistribution;
    }

    public void setAnyPartitioning(FieldSet partitionedFields) {
        if (partitionedFields == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.ANY_PARTITIONING;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
    }

    public void setRandomDistribution() {
        this.partitioning = PartitioningProperty.RANDOM;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setFullyReplicated() {
        this.partitioning = PartitioningProperty.FULL_REPLICATION;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setForceRebalancing() {
        this.partitioning = PartitioningProperty.FORCED_REBALANCED;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public PartitioningProperty getPartitioning() {
        return this.partitioning;
    }

    public FieldSet getPartitionedFields() {
        return this.partitioningFields;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public DataDistribution getDataDistribution() {
        return this.dataDistribution;
    }

    public boolean isTrivial() {
        return this.partitioning == null || this.partitioning == PartitioningProperty.RANDOM;
    }

    public void reset() {
        this.partitioning = PartitioningProperty.RANDOM;
        this.ordering = null;
        this.partitioningFields = null;
    }

    public RequestedGlobalProperties filterByNodesConstantSet(OptimizerNode node, int input) {
        if (this.ordering != null) {
            Iterator iterator = this.ordering.getInvolvedIndexes().iterator();
            while (iterator.hasNext()) {
                int col = (Integer)iterator.next();
                if (node.isFieldConstant(input, col)) continue;
                return null;
            }
        } else if (this.partitioningFields != null) {
            Iterator iterator = this.partitioningFields.iterator();
            while (iterator.hasNext()) {
                int colIndex = (Integer)iterator.next();
                if (node.isFieldConstant(input, colIndex)) continue;
                return null;
            }
        }
        if (this.partitioning == PartitioningProperty.FULL_REPLICATION) {
            return null;
        }
        return this;
    }

    public boolean isMetBy(GlobalProperties props) {
        if (this.partitioning == PartitioningProperty.FULL_REPLICATION) {
            return props.isFullyReplicated();
        }
        if (props.isFullyReplicated()) {
            return false;
        }
        if (this.partitioning == PartitioningProperty.RANDOM) {
            return true;
        }
        if (this.partitioning == PartitioningProperty.ANY_PARTITIONING) {
            return props.isPartitionedOnFields(this.partitioningFields);
        }
        if (this.partitioning == PartitioningProperty.HASH_PARTITIONED) {
            return props.getPartitioning() == PartitioningProperty.HASH_PARTITIONED && props.isPartitionedOnFields(this.partitioningFields);
        }
        if (this.partitioning == PartitioningProperty.RANGE_PARTITIONED) {
            return props.getPartitioning() == PartitioningProperty.RANGE_PARTITIONED && props.matchesOrderedPartitioning(this.ordering);
        }
        if (this.partitioning == PartitioningProperty.FORCED_REBALANCED) {
            return props.getPartitioning() == PartitioningProperty.FORCED_REBALANCED;
        }
        throw new CompilerException("Bug in properties matching logic.");
    }

    public void parameterizeChannel(Channel channel, boolean globalDopChange) {
        if (this.isTrivial()) {
            channel.setShipStrategy(globalDopChange ? ShipStrategyType.PARTITION_RANDOM : ShipStrategyType.FORWARD);
            return;
        }
        GlobalProperties inGlobals = channel.getSource().getGlobalProperties();
        if (!globalDopChange && this.isMetBy(inGlobals)) {
            channel.setShipStrategy(ShipStrategyType.FORWARD);
            return;
        }
        switch (this.partitioning) {
            case FULL_REPLICATION: {
                channel.setShipStrategy(ShipStrategyType.BROADCAST);
                break;
            }
            case ANY_PARTITIONING: 
            case HASH_PARTITIONED: {
                channel.setShipStrategy(ShipStrategyType.PARTITION_HASH, Utils.createOrderedFromSet(this.partitioningFields));
                break;
            }
            case RANGE_PARTITIONED: {
                channel.setShipStrategy(ShipStrategyType.PARTITION_RANGE, this.ordering.getInvolvedIndexes(), this.ordering.getFieldSortDirections());
                if (this.dataDistribution == null) break;
                channel.setDataDistribution(this.dataDistribution);
                break;
            }
            case FORCED_REBALANCED: {
                channel.setShipStrategy(ShipStrategyType.PARTITION_FORCED_REBALANCE);
                break;
            }
            default: {
                throw new CompilerException();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.partitioning == null ? 0 : this.partitioning.ordinal());
        result = 31 * result + (this.partitioningFields == null ? 0 : this.partitioningFields.hashCode());
        result = 31 * result + (this.ordering == null ? 0 : this.ordering.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RequestedGlobalProperties) {
            RequestedGlobalProperties other = (RequestedGlobalProperties)obj;
            return (this.ordering == other.getOrdering() || this.ordering != null && this.ordering.equals((Object)other.getOrdering())) && this.partitioning == other.getPartitioning() && (this.partitioningFields == other.partitioningFields || this.partitioningFields != null && this.partitioningFields.equals((Object)other.getPartitionedFields()));
        }
        return false;
    }

    public String toString() {
        return "Requested Global Properties [partitioning=" + (Object)((Object)this.partitioning) + (this.partitioningFields == null ? "" : ", on fields " + this.partitioningFields) + (this.ordering == null ? "" : ", with ordering " + this.ordering) + "]";
    }

    public RequestedGlobalProperties clone() {
        try {
            return (RequestedGlobalProperties)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }
}

