/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.compiler.dataproperties.GlobalProperties;
import org.apache.flink.compiler.dataproperties.PartitioningProperty;
import org.apache.flink.compiler.dataproperties.RequestedGlobalProperties;
import org.apache.flink.compiler.operators.OperatorDescriptorDual;

public abstract class AbstractJoinDescriptor
extends OperatorDescriptorDual {
    private final boolean broadcastFirstAllowed;
    private final boolean broadcastSecondAllowed;
    private final boolean repartitionAllowed;

    protected AbstractJoinDescriptor(FieldList keys1, FieldList keys2) {
        this(keys1, keys2, true, true, true);
    }

    protected AbstractJoinDescriptor(FieldList keys1, FieldList keys2, boolean broadcastFirstAllowed, boolean broadcastSecondAllowed, boolean repartitionAllowed) {
        super(keys1, keys2);
        this.broadcastFirstAllowed = broadcastFirstAllowed;
        this.broadcastSecondAllowed = broadcastSecondAllowed;
        this.repartitionAllowed = repartitionAllowed;
    }

    @Override
    protected List<OperatorDescriptorDual.GlobalPropertiesPair> createPossibleGlobalProperties() {
        ArrayList<OperatorDescriptorDual.GlobalPropertiesPair> pairs = new ArrayList<OperatorDescriptorDual.GlobalPropertiesPair>();
        if (this.repartitionAllowed) {
            RequestedGlobalProperties partitioned1 = new RequestedGlobalProperties();
            partitioned1.setHashPartitioned((FieldSet)this.keys1);
            RequestedGlobalProperties partitioned2 = new RequestedGlobalProperties();
            partitioned2.setHashPartitioned((FieldSet)this.keys2);
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(partitioned1, partitioned2));
        }
        if (this.broadcastSecondAllowed) {
            RequestedGlobalProperties any1 = new RequestedGlobalProperties();
            RequestedGlobalProperties replicated2 = new RequestedGlobalProperties();
            replicated2.setFullyReplicated();
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(any1, replicated2));
        }
        if (this.broadcastFirstAllowed) {
            RequestedGlobalProperties replicated1 = new RequestedGlobalProperties();
            replicated1.setFullyReplicated();
            RequestedGlobalProperties any2 = new RequestedGlobalProperties();
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(replicated1, any2));
        }
        return pairs;
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties in1, GlobalProperties in2) {
        GlobalProperties gp = GlobalProperties.combine(in1, in2);
        if (gp.getUniqueFieldCombination() != null && gp.getUniqueFieldCombination().size() > 0 && gp.getPartitioning() == PartitioningProperty.RANDOM) {
            gp.setAnyPartitioning(gp.getUniqueFieldCombination().iterator().next().toFieldList());
        }
        gp.clearUniqueFieldCombinations();
        return gp;
    }
}

