/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.plantranslate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorRegistry;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.aggregators.LongSumAggregator;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.dag.TempMode;
import org.apache.flink.compiler.plan.BulkIterationPlanNode;
import org.apache.flink.compiler.plan.BulkPartialSolutionPlanNode;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.DualInputPlanNode;
import org.apache.flink.compiler.plan.IterationPlanNode;
import org.apache.flink.compiler.plan.NAryUnionPlanNode;
import org.apache.flink.compiler.plan.NamedChannel;
import org.apache.flink.compiler.plan.OptimizedPlan;
import org.apache.flink.compiler.plan.PlanNode;
import org.apache.flink.compiler.plan.SingleInputPlanNode;
import org.apache.flink.compiler.plan.SinkPlanNode;
import org.apache.flink.compiler.plan.SolutionSetPlanNode;
import org.apache.flink.compiler.plan.SourcePlanNode;
import org.apache.flink.compiler.plan.WorksetIterationPlanNode;
import org.apache.flink.compiler.plan.WorksetPlanNode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.iterative.convergence.WorksetEmptyConvergenceCriterion;
import org.apache.flink.runtime.iterative.task.IterationHeadPactTask;
import org.apache.flink.runtime.iterative.task.IterationIntermediatePactTask;
import org.apache.flink.runtime.iterative.task.IterationSynchronizationSinkTask;
import org.apache.flink.runtime.iterative.task.IterationTailPactTask;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.InputFormatVertex;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.OutputFormatVertex;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.CoGroupDriver;
import org.apache.flink.runtime.operators.CoGroupWithSolutionSetFirstDriver;
import org.apache.flink.runtime.operators.CoGroupWithSolutionSetSecondDriver;
import org.apache.flink.runtime.operators.DataSinkTask;
import org.apache.flink.runtime.operators.DataSourceTask;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.JoinWithSolutionSetFirstDriver;
import org.apache.flink.runtime.operators.JoinWithSolutionSetSecondDriver;
import org.apache.flink.runtime.operators.MatchDriver;
import org.apache.flink.runtime.operators.NoOpDriver;
import org.apache.flink.runtime.operators.RegularPactTask;
import org.apache.flink.runtime.operators.chaining.ChainedDriver;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Visitor;

public class NepheleJobGraphGenerator
implements Visitor<PlanNode> {
    public static final String MERGE_ITERATION_AUX_TASKS_KEY = "compiler.merge-iteration-aux";
    private static final boolean mergeIterationAuxTasks = GlobalConfiguration.getBoolean((String)"compiler.merge-iteration-aux", (boolean)false);
    private static final TaskInChain ALREADY_VISITED_PLACEHOLDER = new TaskInChain(null, null, null);
    private Map<PlanNode, AbstractJobVertex> vertices;
    private Map<PlanNode, TaskInChain> chainedTasks;
    private Map<IterationPlanNode, IterationDescriptor> iterations;
    private List<TaskInChain> chainedTasksInSequence;
    private List<AbstractJobVertex> auxVertices;
    private final int defaultMaxFan;
    private final float defaultSortSpillingThreshold;
    private int iterationIdEnumerator = 1;
    private IterationPlanNode currentIteration;
    private SlotSharingGroup sharingGroup;

    public NepheleJobGraphGenerator() {
        this.defaultMaxFan = 128;
        this.defaultSortSpillingThreshold = 0.8f;
    }

    public NepheleJobGraphGenerator(Configuration config) {
        this.defaultMaxFan = config.getInteger("taskmanager.runtime.max-fan", 128);
        this.defaultSortSpillingThreshold = config.getFloat("taskmanager.runtime.sort-spilling-threshold", 0.8f);
    }

    public JobGraph compileJobGraph(OptimizedPlan program) {
        this.vertices = new HashMap<PlanNode, AbstractJobVertex>();
        this.chainedTasks = new HashMap<PlanNode, TaskInChain>();
        this.chainedTasksInSequence = new ArrayList<TaskInChain>();
        this.auxVertices = new ArrayList<AbstractJobVertex>();
        this.iterations = new HashMap<IterationPlanNode, IterationDescriptor>();
        this.sharingGroup = new SlotSharingGroup();
        program.accept(this);
        for (IterationDescriptor iteration : this.iterations.values()) {
            if (iteration.getIterationNode() instanceof BulkIterationPlanNode) {
                this.finalizeBulkIteration(iteration);
                continue;
            }
            if (iteration.getIterationNode() instanceof WorksetIterationPlanNode) {
                this.finalizeWorksetIteration(iteration);
                continue;
            }
            throw new CompilerException();
        }
        for (int i = 0; i < this.chainedTasksInSequence.size(); ++i) {
            TaskInChain tic = this.chainedTasksInSequence.get(i);
            TaskConfig t = new TaskConfig(tic.getContainingVertex().getConfiguration());
            t.addChainedTask(tic.getChainedTask(), tic.getTaskConfig(), tic.getTaskName());
        }
        JobGraph graph = new JobGraph(program.getJobName());
        graph.setAllowQueuedScheduling(false);
        for (AbstractJobVertex vertex : this.vertices.values()) {
            graph.addVertex(vertex);
        }
        for (AbstractJobVertex vertex : this.auxVertices) {
            graph.addVertex(vertex);
            vertex.setSlotSharingGroup(this.sharingGroup);
        }
        for (Map.Entry e : program.getOriginalPactPlan().getCachedFiles()) {
            DistributedCache.writeFileInfoToConfig((String)((String)e.getKey()), (DistributedCache.DistributedCacheEntry)((DistributedCache.DistributedCacheEntry)e.getValue()), (Configuration)graph.getJobConfiguration());
        }
        this.vertices = null;
        this.chainedTasks = null;
        this.chainedTasksInSequence = null;
        this.auxVertices = null;
        this.iterations = null;
        return graph;
    }

    public boolean preVisit(PlanNode node) {
        IterationDescriptor descr;
        AbstractJobVertex vertex;
        block23: {
            if (this.vertices.containsKey(node) || this.chainedTasks.containsKey(node) || this.iterations.containsKey(node)) {
                return false;
            }
            try {
                Object iterationNode;
                if (node instanceof SinkPlanNode) {
                    vertex = this.createDataSinkVertex((SinkPlanNode)node);
                    break block23;
                }
                if (node instanceof SourcePlanNode) {
                    vertex = this.createDataSourceVertex((SourcePlanNode)node);
                    break block23;
                }
                if (node instanceof BulkIterationPlanNode) {
                    iterationNode = (BulkIterationPlanNode)node;
                    PlanNode root = ((BulkIterationPlanNode)iterationNode).getRootOfStepFunction();
                    if (root.getDegreeOfParallelism() != node.getDegreeOfParallelism()) {
                        throw new CompilerException("Error: The final operator of the step function has a different degree of parallelism than the iteration operator itself.");
                    }
                    descr = new IterationDescriptor((IterationPlanNode)iterationNode, this.iterationIdEnumerator++);
                    this.iterations.put((IterationPlanNode)iterationNode, descr);
                    vertex = null;
                    break block23;
                }
                if (node instanceof WorksetIterationPlanNode) {
                    iterationNode = (WorksetIterationPlanNode)node;
                    PlanNode nextWorkSet = ((WorksetIterationPlanNode)iterationNode).getNextWorkSetPlanNode();
                    PlanNode solutionSetDelta = ((WorksetIterationPlanNode)iterationNode).getSolutionSetDeltaPlanNode();
                    if (nextWorkSet.getDegreeOfParallelism() != node.getDegreeOfParallelism()) {
                        throw new CompilerException("It is currently not supported that the final operator of the step function has a different degree of parallelism than the iteration operator itself.");
                    }
                    if (solutionSetDelta.getDegreeOfParallelism() != node.getDegreeOfParallelism()) {
                        throw new CompilerException("It is currently not supported that the final operator of the step function has a different degree of parallelism than the iteration operator itself.");
                    }
                    IterationDescriptor descr2 = new IterationDescriptor((IterationPlanNode)iterationNode, this.iterationIdEnumerator++);
                    this.iterations.put((IterationPlanNode)iterationNode, descr2);
                    vertex = null;
                    break block23;
                }
                if (node instanceof SingleInputPlanNode) {
                    vertex = this.createSingleInputVertex((SingleInputPlanNode)node);
                    break block23;
                }
                if (node instanceof DualInputPlanNode) {
                    vertex = this.createDualInputVertex((DualInputPlanNode)node);
                    break block23;
                }
                if (node instanceof NAryUnionPlanNode) {
                    vertex = null;
                    break block23;
                }
                if (node instanceof BulkPartialSolutionPlanNode) {
                    vertex = this.createBulkIterationHead((BulkPartialSolutionPlanNode)node);
                    break block23;
                }
                if (node instanceof SolutionSetPlanNode) {
                    for (Channel c : node.getOutgoingChannels()) {
                        int inputNum;
                        DualInputPlanNode target = (DualInputPlanNode)c.getTarget();
                        AbstractJobVertex accessingVertex = this.vertices.get(target);
                        TaskConfig conf = new TaskConfig(accessingVertex.getConfiguration());
                        int n = c == target.getInput1() ? 0 : (inputNum = c == target.getInput2() ? 1 : -1);
                        if (inputNum == -1) {
                            throw new CompilerException();
                        }
                        if (conf.getDriver().equals(MatchDriver.class)) {
                            conf.setDriver(inputNum == 0 ? JoinWithSolutionSetFirstDriver.class : JoinWithSolutionSetSecondDriver.class);
                            continue;
                        }
                        if (conf.getDriver().equals(CoGroupDriver.class)) {
                            conf.setDriver(inputNum == 0 ? CoGroupWithSolutionSetFirstDriver.class : CoGroupWithSolutionSetSecondDriver.class);
                            continue;
                        }
                        throw new CompilerException("Found join with solution set using incompatible operator (only Join/CoGroup are valid).");
                    }
                    this.chainedTasks.put(node, ALREADY_VISITED_PLACEHOLDER);
                    vertex = null;
                    break block23;
                }
                if (node instanceof WorksetPlanNode) {
                    vertex = this.createWorksetIterationHead((WorksetPlanNode)node);
                    break block23;
                }
                throw new CompilerException("Unrecognized node type: " + node.getClass().getName());
            }
            catch (Exception e) {
                throw new CompilerException("Error translating node '" + node + "': " + e.getMessage(), e);
            }
        }
        if (vertex != null) {
            int pd = node.getDegreeOfParallelism();
            vertex.setParallelism(pd);
            vertex.setSlotSharingGroup(this.sharingGroup);
            if (this.currentIteration != null) {
                PlanNode iterationNode = (PlanNode)((Object)this.currentIteration);
                if (iterationNode.getDegreeOfParallelism() < pd) {
                    throw new CompilerException("Error: All functions that are part of an iteration must have the same, or a lower, degree-of-parallelism than the iteration operator.");
                }
                descr = this.iterations.get(this.currentIteration);
                new TaskConfig(vertex.getConfiguration()).setIterationId(descr.getId());
            }
            this.vertices.put(node, vertex);
        }
        return true;
    }

    public void postVisit(PlanNode node) {
        try {
            Iterator<Channel> inConns;
            AbstractJobVertex head;
            if (node instanceof SourcePlanNode || node instanceof NAryUnionPlanNode || node instanceof SolutionSetPlanNode) {
                return;
            }
            if (node instanceof IterationPlanNode) {
                if (this.currentIteration != null) {
                    throw new CompilerException("Nested Iterations are not possible at the moment!");
                }
                this.currentIteration = (IterationPlanNode)((Object)node);
                this.currentIteration.acceptForStepFunction(this);
                this.currentIteration = null;
                if (node instanceof WorksetIterationPlanNode) {
                    WorksetIterationPlanNode wsNode = (WorksetIterationPlanNode)node;
                    AbstractJobVertex headVertex = this.iterations.get(wsNode).getHeadTask();
                    TaskConfig headConfig = new TaskConfig(headVertex.getConfiguration());
                    int inputIndex = headConfig.getDriverStrategy().getNumInputs();
                    headConfig.setIterationHeadSolutionSetInputIndex(inputIndex);
                    this.translateChannel(wsNode.getInitialSolutionSetInput(), inputIndex, headVertex, headConfig, false);
                }
                return;
            }
            AbstractJobVertex targetVertex = this.vertices.get(node);
            if (targetVertex == null) {
                TaskInChain chainedTask = this.chainedTasks.get(node);
                if (chainedTask != null) {
                    Iterator<Channel> inConns2 = node.getInputs().iterator();
                    if (!inConns2.hasNext()) {
                        throw new CompilerException("Bug: Found chained task with no input.");
                    }
                    Channel inConn = inConns2.next();
                    if (inConns2.hasNext()) {
                        throw new CompilerException("Bug: Found a chained task with more than one input!");
                    }
                    if (inConn.getLocalStrategy() != null && inConn.getLocalStrategy() != LocalStrategy.NONE) {
                        throw new CompilerException("Bug: Found a chained task with an input local strategy.");
                    }
                    if (inConn.getShipStrategy() != null && inConn.getShipStrategy() != ShipStrategyType.FORWARD) {
                        throw new CompilerException("Bug: Found a chained task with an input ship strategy other than FORWARD.");
                    }
                    AbstractJobVertex container = chainedTask.getContainingVertex();
                    if (container == null) {
                        PlanNode sourceNode = inConn.getSource();
                        container = this.vertices.get(sourceNode);
                        if (container == null) {
                            container = this.chainedTasks.get(sourceNode).getContainingVertex();
                            if (container == null) {
                                throw new IllegalStateException("Bug: Chained task predecessor has not been assigned its containing vertex.");
                            }
                        } else {
                            new TaskConfig(container.getConfiguration()).addOutputShipStrategy(ShipStrategyType.FORWARD);
                        }
                        chainedTask.setContainingVertex(container);
                    }
                    chainedTask.getTaskConfig().setInputSerializer(inConn.getSerializer(), 0);
                    String containerTaskName = container.getName();
                    if (containerTaskName.startsWith("CHAIN ")) {
                        container.setName(containerTaskName + " -> " + chainedTask.getTaskName());
                    } else {
                        container.setName("CHAIN " + containerTaskName + " -> " + chainedTask.getTaskName());
                    }
                    this.chainedTasksInSequence.add(chainedTask);
                    return;
                }
                if (node instanceof BulkPartialSolutionPlanNode || node instanceof WorksetPlanNode) {
                    return;
                }
                throw new CompilerException("Bug: Unrecognized merged task vertex.");
            }
            if (this.currentIteration != null && (head = this.iterations.get(this.currentIteration).getHeadTask()) != null) {
                targetVertex.setStrictlyCoLocatedWith(head);
            }
            TaskConfig targetVertexConfig = new TaskConfig(targetVertex.getConfiguration());
            if (node instanceof BulkPartialSolutionPlanNode) {
                inConns = ((BulkPartialSolutionPlanNode)node).getContainingIterationNode().getInputs().iterator();
                targetVertexConfig.setIterationHeadPartialSolutionOrWorksetInputIndex(0);
            } else if (node instanceof WorksetPlanNode) {
                WorksetPlanNode wspn = (WorksetPlanNode)node;
                inConns = Collections.singleton(wspn.getContainingIterationNode().getInput2()).iterator();
                targetVertexConfig.setIterationHeadPartialSolutionOrWorksetInputIndex(0);
                targetVertexConfig.setIterationHeadSolutionSetInputIndex(1);
            } else {
                inConns = node.getInputs().iterator();
            }
            if (!inConns.hasNext()) {
                throw new CompilerException("Bug: Found a non-source task with no input.");
            }
            int inputIndex = 0;
            while (inConns.hasNext()) {
                Channel input = inConns.next();
                inputIndex += this.translateChannel(input, inputIndex, targetVertex, targetVertexConfig, false);
            }
            int broadcastInputIndex = 0;
            for (NamedChannel broadcastInput : node.getBroadcastInputs()) {
                int broadcastInputIndexDelta = this.translateChannel(broadcastInput, broadcastInputIndex, targetVertex, targetVertexConfig, true);
                targetVertexConfig.setBroadcastInputName(broadcastInput.getName(), broadcastInputIndex);
                targetVertexConfig.setBroadcastInputSerializer(broadcastInput.getSerializer(), broadcastInputIndex);
                broadcastInputIndex += broadcastInputIndexDelta;
            }
        }
        catch (Exception e) {
            throw new CompilerException("An error occurred while translating the optimized plan to a nephele JobGraph: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int translateChannel(Channel input, int inputIndex, AbstractJobVertex targetVertex, TaskConfig targetVertexConfig, boolean isBroadcast) throws Exception {
        PlanNode iterationNode;
        Iterator<Channel> allInChannels;
        PlanNode inputPlanNode = input.getSource();
        if (inputPlanNode instanceof NAryUnionPlanNode) {
            allInChannels = ((NAryUnionPlanNode)inputPlanNode).getListOfInputs().iterator();
        } else if (inputPlanNode instanceof BulkPartialSolutionPlanNode) {
            if (this.vertices.get(inputPlanNode) == null) {
                BulkPartialSolutionPlanNode pspn = (BulkPartialSolutionPlanNode)inputPlanNode;
                iterationNode = pspn.getContainingIterationNode();
                allInChannels = ((SingleInputPlanNode)iterationNode).getInput().getSource() instanceof NAryUnionPlanNode ? ((NAryUnionPlanNode)((SingleInputPlanNode)iterationNode).getInput().getSource()).getInputs().iterator() : Collections.singletonList(((SingleInputPlanNode)iterationNode).getInput()).iterator();
                targetVertexConfig.setIterationHeadPartialSolutionOrWorksetInputIndex(inputIndex);
            } else {
                allInChannels = Collections.singletonList(input).iterator();
            }
        } else if (inputPlanNode instanceof WorksetPlanNode) {
            if (this.vertices.get(inputPlanNode) == null) {
                WorksetPlanNode wspn = (WorksetPlanNode)inputPlanNode;
                iterationNode = wspn.getContainingIterationNode();
                allInChannels = ((DualInputPlanNode)iterationNode).getInput2().getSource() instanceof NAryUnionPlanNode ? ((NAryUnionPlanNode)((DualInputPlanNode)iterationNode).getInput2().getSource()).getInputs().iterator() : Collections.singletonList(((DualInputPlanNode)iterationNode).getInput2()).iterator();
                targetVertexConfig.setIterationHeadPartialSolutionOrWorksetInputIndex(inputIndex);
            } else {
                allInChannels = Collections.singletonList(input).iterator();
            }
        } else {
            if (inputPlanNode instanceof SolutionSetPlanNode) {
                return 0;
            }
            allInChannels = Collections.singletonList(input).iterator();
        }
        TypeSerializerFactory<?> typeSerFact = null;
        int numChannelsTotal = 0;
        int numChannelsDynamicPath = 0;
        int numDynamicSenderTasksTotal = 0;
        while (allInChannels.hasNext()) {
            TaskConfig sourceVertexConfig;
            Channel inConn = allInChannels.next();
            if (typeSerFact == null) {
                typeSerFact = inConn.getSerializer();
            } else if (!typeSerFact.equals(inConn.getSerializer())) {
                throw new CompilerException("Conflicting types in union operator.");
            }
            PlanNode sourceNode = inConn.getSource();
            AbstractJobVertex sourceVertex = this.vertices.get(sourceNode);
            if (sourceVertex == null) {
                TaskInChain chainedTask = this.chainedTasks.get(sourceNode);
                if (chainedTask != null) {
                    if (chainedTask.getContainingVertex() == null) {
                        throw new IllegalStateException("Bug: Chained task has not been assigned its containing vertex when connecting.");
                    }
                    sourceVertex = chainedTask.getContainingVertex();
                    sourceVertexConfig = chainedTask.getTaskConfig();
                } else {
                    IterationDescriptor iteration = this.iterations.get(sourceNode);
                    if (iteration == null) throw new CompilerException("Bug: Could not resolve source node for a channel.");
                    sourceVertex = iteration.getHeadTask();
                    sourceVertexConfig = iteration.getHeadFinalResultConfig();
                }
            } else {
                sourceVertexConfig = new TaskConfig(sourceVertex.getConfiguration());
            }
            DistributionPattern pattern = this.connectJobVertices(inConn, inputIndex, sourceVertex, sourceVertexConfig, targetVertex, targetVertexConfig, isBroadcast);
            ++numChannelsTotal;
            if (!inConn.isOnDynamicPath()) continue;
            ++numChannelsDynamicPath;
            numDynamicSenderTasksTotal += this.getNumberOfSendersPerReceiver(pattern, sourceVertex.getParallelism(), targetVertex.getParallelism());
        }
        if (numChannelsDynamicPath > 0 && numChannelsTotal != numChannelsDynamicPath) {
            throw new CompilerException("Error: It is currently not supported to union between dynamic and static path in an iteration.");
        }
        if (numDynamicSenderTasksTotal > 0) {
            if (isBroadcast) {
                targetVertexConfig.setBroadcastGateIterativeWithNumberOfEventsUntilInterrupt(inputIndex, numDynamicSenderTasksTotal);
            } else {
                targetVertexConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(inputIndex, numDynamicSenderTasksTotal);
            }
        }
        this.addLocalInfoFromChannelToConfig(input, targetVertexConfig, inputIndex, isBroadcast);
        return 1;
    }

    private int getNumberOfSendersPerReceiver(DistributionPattern pattern, int numSenders, int numReceivers) {
        if (pattern == DistributionPattern.BIPARTITE) {
            return numSenders;
        }
        if (pattern == DistributionPattern.POINTWISE) {
            if (numSenders != numReceivers) {
                if (numReceivers == 1) {
                    return numSenders;
                }
                if (numSenders == 1) {
                    return 1;
                }
                throw new CompilerException("Error: A changing degree of parallelism is currently not supported between tasks within an iteration.");
            }
            return 1;
        }
        throw new CompilerException("Unknown distribution pattern for channels: " + pattern);
    }

    private AbstractJobVertex createSingleInputVertex(SingleInputPlanNode node) throws CompilerException {
        TaskConfig config;
        AbstractJobVertex vertex;
        PlanNode wspn;
        String taskName = node.getNodeName();
        DriverStrategy ds = node.getDriverStrategy();
        boolean chaining = false;
        Channel inConn = node.getInput();
        PlanNode pred = inConn.getSource();
        boolean bl = chaining = ds.getPushChainDriverClass() != null && !(pred instanceof NAryUnionPlanNode) && !(pred instanceof BulkPartialSolutionPlanNode) && !(pred instanceof WorksetPlanNode) && !(pred instanceof IterationPlanNode) && inConn.getShipStrategy() == ShipStrategyType.FORWARD && inConn.getLocalStrategy() == LocalStrategy.NONE && pred.getOutgoingChannels().size() == 1 && node.getDegreeOfParallelism() == pred.getDegreeOfParallelism() && node.getBroadcastInputs().isEmpty();
        if (this.currentIteration != null && this.currentIteration instanceof WorksetIterationPlanNode && node.getOutgoingChannels().size() > 0 && (((WorksetIterationPlanNode)(wspn = (WorksetIterationPlanNode)this.currentIteration)).getSolutionSetDeltaPlanNode() == pred || ((WorksetIterationPlanNode)wspn).getNextWorkSetPlanNode() == pred)) {
            chaining = false;
        }
        if (this.currentIteration != null && this.currentIteration instanceof BulkIterationPlanNode) {
            wspn = (BulkIterationPlanNode)this.currentIteration;
            if (node == ((BulkIterationPlanNode)wspn).getRootOfTerminationCriterion() && ((BulkIterationPlanNode)wspn).getRootOfStepFunction() == pred) {
                chaining = false;
            } else if (node.getOutgoingChannels().size() > 0 && (((BulkIterationPlanNode)wspn).getRootOfStepFunction() == pred || ((BulkIterationPlanNode)wspn).getRootOfTerminationCriterion() == pred)) {
                chaining = false;
            }
        }
        if (chaining) {
            vertex = null;
            config = new TaskConfig(new Configuration());
            this.chainedTasks.put(node, new TaskInChain(ds.getPushChainDriverClass(), config, taskName));
        } else {
            vertex = new AbstractJobVertex(taskName);
            vertex.setInvokableClass(this.currentIteration != null && node.isOnDynamicPath() ? IterationIntermediatePactTask.class : RegularPactTask.class);
            config = new TaskConfig(vertex.getConfiguration());
            config.setDriver(ds.getDriverClass());
        }
        config.setStubWrapper(node.getPactContract().getUserCodeWrapper());
        config.setStubParameters(node.getPactContract().getParameters());
        config.setDriverStrategy(ds);
        for (int i = 0; i < ds.getNumRequiredComparators(); ++i) {
            config.setDriverComparator(node.getComparator(i), i);
        }
        this.assignDriverResources(node, config);
        return vertex;
    }

    private AbstractJobVertex createDualInputVertex(DualInputPlanNode node) throws CompilerException {
        String taskName = node.getNodeName();
        DriverStrategy ds = node.getDriverStrategy();
        AbstractJobVertex vertex = new AbstractJobVertex(taskName);
        TaskConfig config = new TaskConfig(vertex.getConfiguration());
        vertex.setInvokableClass(this.currentIteration != null && node.isOnDynamicPath() ? IterationIntermediatePactTask.class : RegularPactTask.class);
        config.setStubWrapper(node.getPactContract().getUserCodeWrapper());
        config.setStubParameters(node.getPactContract().getParameters());
        config.setDriver(ds.getDriverClass());
        config.setDriverStrategy(ds);
        if (node.getComparator1() != null) {
            config.setDriverComparator(node.getComparator1(), 0);
        }
        if (node.getComparator2() != null) {
            config.setDriverComparator(node.getComparator2(), 1);
        }
        if (node.getPairComparator() != null) {
            config.setDriverPairComparator(node.getPairComparator());
        }
        this.assignDriverResources(node, config);
        return vertex;
    }

    private InputFormatVertex createDataSourceVertex(SourcePlanNode node) throws CompilerException {
        InputFormatVertex vertex = new InputFormatVertex(node.getNodeName());
        TaskConfig config = new TaskConfig(vertex.getConfiguration());
        vertex.setInvokableClass(DataSourceTask.class);
        config.setStubWrapper(node.getPactContract().getUserCodeWrapper());
        config.setStubParameters(node.getPactContract().getParameters());
        config.setOutputSerializer(node.getSerializer());
        return vertex;
    }

    private AbstractJobVertex createDataSinkVertex(SinkPlanNode node) throws CompilerException {
        OutputFormatVertex vertex = new OutputFormatVertex(node.getNodeName());
        TaskConfig config = new TaskConfig(vertex.getConfiguration());
        vertex.setInvokableClass(DataSinkTask.class);
        vertex.getConfiguration().setInteger("sink.dop", node.getDegreeOfParallelism());
        config.setStubWrapper(node.getPactContract().getUserCodeWrapper());
        config.setStubParameters(node.getPactContract().getParameters());
        return vertex;
    }

    private AbstractJobVertex createBulkIterationHead(BulkPartialSolutionPlanNode pspn) {
        AbstractJobVertex toReturn;
        TaskConfig headConfig;
        AbstractJobVertex headVertex;
        boolean merge;
        BulkIterationPlanNode iteration = pspn.getContainingIterationNode();
        if (mergeIterationAuxTasks && pspn.getOutgoingChannels().size() == 1) {
            Channel c = pspn.getOutgoingChannels().get(0);
            PlanNode successor = c.getTarget();
            merge = c.getShipStrategy() == ShipStrategyType.FORWARD && c.getLocalStrategy() == LocalStrategy.NONE && c.getTempMode() == TempMode.NONE && successor.getDegreeOfParallelism() == pspn.getDegreeOfParallelism() && !(successor instanceof NAryUnionPlanNode) && successor != iteration.getRootOfStepFunction() && iteration.getInput().getLocalStrategy() == LocalStrategy.NONE;
        } else {
            merge = false;
        }
        if (merge) {
            PlanNode successor = pspn.getOutgoingChannels().get(0).getTarget();
            headVertex = this.vertices.get(successor);
            if (headVertex == null) {
                throw new CompilerException("Bug: Trying to merge solution set with its sucessor, but successor has not been created.");
            }
            headVertex.setInvokableClass(IterationHeadPactTask.class);
            headConfig = new TaskConfig(headVertex.getConfiguration());
            toReturn = null;
        } else {
            headVertex = new AbstractJobVertex("PartialSolution (" + iteration.getNodeName() + ")");
            headVertex.setInvokableClass(IterationHeadPactTask.class);
            headConfig = new TaskConfig(headVertex.getConfiguration());
            headConfig.setDriver(NoOpDriver.class);
            toReturn = headVertex;
        }
        IterationDescriptor descr = this.iterations.get(iteration);
        if (descr == null) {
            throw new CompilerException("Bug: Iteration descriptor was not created at when translating the iteration node.");
        }
        descr.setHeadTask(headVertex, headConfig);
        return toReturn;
    }

    private AbstractJobVertex createWorksetIterationHead(WorksetPlanNode wspn) {
        AbstractJobVertex toReturn;
        TaskConfig headConfig;
        AbstractJobVertex headVertex;
        boolean merge;
        WorksetIterationPlanNode iteration = wspn.getContainingIterationNode();
        if (mergeIterationAuxTasks && wspn.getOutgoingChannels().size() == 1) {
            Channel c = wspn.getOutgoingChannels().get(0);
            PlanNode successor = c.getTarget();
            merge = c.getShipStrategy() == ShipStrategyType.FORWARD && c.getLocalStrategy() == LocalStrategy.NONE && c.getTempMode() == TempMode.NONE && successor.getDegreeOfParallelism() == wspn.getDegreeOfParallelism() && !(successor instanceof NAryUnionPlanNode) && successor != iteration.getNextWorkSetPlanNode() && iteration.getInitialWorksetInput().getLocalStrategy() == LocalStrategy.NONE;
        } else {
            merge = false;
        }
        if (merge) {
            PlanNode successor = wspn.getOutgoingChannels().get(0).getTarget();
            headVertex = this.vertices.get(successor);
            if (headVertex == null) {
                throw new CompilerException("Bug: Trying to merge solution set with its sucessor, but successor has not been created.");
            }
            headVertex.setInvokableClass(IterationHeadPactTask.class);
            headConfig = new TaskConfig(headVertex.getConfiguration());
            toReturn = null;
        } else {
            headVertex = new AbstractJobVertex("IterationHead(" + iteration.getNodeName() + ")");
            headVertex.setInvokableClass(IterationHeadPactTask.class);
            headConfig = new TaskConfig(headVertex.getConfiguration());
            headConfig.setDriver(NoOpDriver.class);
            toReturn = headVertex;
        }
        headConfig.setSolutionSetUnmanaged(iteration.getIterationNode().getIterationContract().isSolutionSetUnManaged());
        IterationDescriptor descr = this.iterations.get(iteration);
        if (descr == null) {
            throw new CompilerException("Bug: Iteration descriptor was not created at when translating the iteration node.");
        }
        descr.setHeadTask(headVertex, headConfig);
        return toReturn;
    }

    private void assignDriverResources(PlanNode node, TaskConfig config) {
        double relativeMem = node.getRelativeMemoryPerSubTask();
        if (relativeMem > 0.0) {
            config.setRelativeMemoryDriver(relativeMem);
            config.setFilehandlesDriver(this.defaultMaxFan);
            config.setSpillingThresholdDriver(this.defaultSortSpillingThreshold);
        }
    }

    private void assignLocalStrategyResources(Channel c, TaskConfig config, int inputNum) {
        if (c.getRelativeMemoryLocalStrategy() > 0.0) {
            config.setRelativeMemoryInput(inputNum, c.getRelativeMemoryLocalStrategy());
            config.setFilehandlesInput(inputNum, this.defaultMaxFan);
            config.setSpillingThresholdInput(inputNum, this.defaultSortSpillingThreshold);
        }
    }

    private DistributionPattern connectJobVertices(Channel channel, int inputNumber, AbstractJobVertex sourceVertex, TaskConfig sourceConfig, AbstractJobVertex targetVertex, TaskConfig targetConfig, boolean isBroadcast) throws CompilerException {
        DistributionPattern distributionPattern;
        switch (channel.getShipStrategy()) {
            case FORWARD: {
                distributionPattern = DistributionPattern.POINTWISE;
                break;
            }
            case PARTITION_RANDOM: 
            case BROADCAST: 
            case PARTITION_HASH: 
            case PARTITION_RANGE: 
            case PARTITION_FORCED_REBALANCE: {
                distributionPattern = DistributionPattern.BIPARTITE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown runtime ship strategy: " + channel.getShipStrategy());
            }
        }
        targetVertex.connectNewDataSetAsInput(sourceVertex, distributionPattern);
        int outputIndex = sourceConfig.getNumOutputs();
        sourceConfig.addOutputShipStrategy(channel.getShipStrategy());
        if (outputIndex == 0) {
            sourceConfig.setOutputSerializer(channel.getSerializer());
        }
        if (channel.getShipStrategyComparator() != null) {
            sourceConfig.setOutputComparator(channel.getShipStrategyComparator(), outputIndex);
        }
        if (channel.getShipStrategy() == ShipStrategyType.PARTITION_RANGE) {
            DataDistribution dataDistribution = channel.getDataDistribution();
            if (dataDistribution != null) {
                sourceConfig.setOutputDataDistribution(dataDistribution, outputIndex);
            } else {
                throw new RuntimeException("Range partitioning requires data distribution");
            }
        }
        if (isBroadcast) {
            targetConfig.addBroadcastInputToGroup(inputNumber);
        } else {
            targetConfig.addInputToGroup(inputNumber);
        }
        return distributionPattern;
    }

    private void addLocalInfoFromChannelToConfig(Channel channel, TaskConfig config, int inputNum, boolean isBroadcastChannel) {
        if (isBroadcastChannel) {
            config.setBroadcastInputSerializer(channel.getSerializer(), inputNum);
            if (channel.getLocalStrategy() != LocalStrategy.NONE || channel.getTempMode() != null && channel.getTempMode() != TempMode.NONE) {
                throw new CompilerException("Found local strategy or temp mode on a broadcast variable channel.");
            }
            return;
        }
        config.setInputSerializer(channel.getSerializer(), inputNum);
        if (channel.getLocalStrategy() != LocalStrategy.NONE) {
            config.setInputLocalStrategy(inputNum, channel.getLocalStrategy());
            if (channel.getLocalStrategyComparator() != null) {
                config.setInputComparator(channel.getLocalStrategyComparator(), inputNum);
            }
        }
        this.assignLocalStrategyResources(channel, config, inputNum);
        if (channel.getTempMode() != null) {
            TempMode tm = channel.getTempMode();
            boolean needsMemory = false;
            if (tm.breaksPipeline()) {
                config.setInputAsynchronouslyMaterialized(inputNum, true);
                needsMemory = true;
            }
            if (tm.isCached()) {
                config.setInputCached(inputNum, true);
                needsMemory = true;
            }
            if (needsMemory) {
                if (tm == null || tm == TempMode.NONE || channel.getRelativeTempMemory() <= 0.0) {
                    throw new CompilerException("Bug in compiler: Inconsistent description of input materialization.");
                }
                config.setRelativeInputMaterializationMemory(inputNum, channel.getRelativeTempMemory());
            }
        }
    }

    private void finalizeBulkIteration(IterationDescriptor descr) {
        TaskConfig tailConfig;
        BulkIterationPlanNode bulkNode = (BulkIterationPlanNode)descr.getIterationNode();
        AbstractJobVertex headVertex = descr.getHeadTask();
        TaskConfig headConfig = new TaskConfig(headVertex.getConfiguration());
        TaskConfig headFinalOutputConfig = descr.getHeadFinalResultConfig();
        int numStepFunctionOuts = headConfig.getNumOutputs();
        int numFinalOuts = headFinalOutputConfig.getNumOutputs();
        if (numStepFunctionOuts == 0) {
            throw new CompilerException("The iteration has no operation inside the step function.");
        }
        headConfig.setIterationHeadFinalOutputConfig(headFinalOutputConfig);
        headConfig.setIterationHeadIndexOfSyncOutput(numStepFunctionOuts + numFinalOuts);
        double relativeMemForBackChannel = bulkNode.getRelativeMemoryPerSubTask();
        if (relativeMemForBackChannel <= 0.0) {
            throw new CompilerException("Bug: No memory has been assigned to the iteration back channel.");
        }
        headConfig.setRelativeBackChannelMemory(relativeMemForBackChannel);
        AbstractJobVertex sync = new AbstractJobVertex("Sync(" + bulkNode.getNodeName() + ")");
        sync.setInvokableClass(IterationSynchronizationSinkTask.class);
        sync.setParallelism(1);
        this.auxVertices.add(sync);
        TaskConfig syncConfig = new TaskConfig(sync.getConfiguration());
        syncConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, headVertex.getParallelism());
        int maxNumIterations = bulkNode.getIterationNode().getIterationContract().getMaximumNumberOfIterations();
        if (maxNumIterations < 1) {
            throw new CompilerException("Cannot create bulk iteration with unspecified maximum number of iterations.");
        }
        syncConfig.setNumberOfIterations(maxNumIterations);
        sync.connectNewDataSetAsInput(headVertex, DistributionPattern.POINTWISE);
        PlanNode rootOfTerminationCriterion = bulkNode.getRootOfTerminationCriterion();
        PlanNode rootOfStepFunction = bulkNode.getRootOfStepFunction();
        AbstractJobVertex rootOfStepFunctionVertex = this.vertices.get(rootOfStepFunction);
        if (rootOfStepFunctionVertex == null) {
            TaskInChain taskInChain = this.chainedTasks.get(rootOfStepFunction);
            if (taskInChain == null) {
                throw new CompilerException("Bug: Tail of step function not found as vertex or chained task.");
            }
            rootOfStepFunctionVertex = taskInChain.getContainingVertex();
            tailConfig = taskInChain.getTaskConfig();
        } else {
            tailConfig = new TaskConfig(rootOfStepFunctionVertex.getConfiguration());
        }
        tailConfig.setIsWorksetUpdate();
        if (rootOfStepFunction.getOutgoingChannels().isEmpty()) {
            rootOfStepFunctionVertex.setInvokableClass(IterationTailPactTask.class);
            tailConfig.setOutputSerializer(bulkNode.getSerializerForIterationChannel());
        }
        if (rootOfTerminationCriterion != null && rootOfTerminationCriterion.getOutgoingChannels().isEmpty()) {
            TaskConfig tailConfigOfTerminationCriterion;
            AbstractJobVertex rootOfTerminationCriterionVertex = this.vertices.get(rootOfTerminationCriterion);
            if (rootOfTerminationCriterionVertex == null) {
                TaskInChain taskInChain = this.chainedTasks.get(rootOfTerminationCriterion);
                if (taskInChain == null) {
                    throw new CompilerException("Bug: Tail of termination criterion not found as vertex or chained task.");
                }
                rootOfTerminationCriterionVertex = taskInChain.getContainingVertex();
                tailConfigOfTerminationCriterion = taskInChain.getTaskConfig();
            } else {
                tailConfigOfTerminationCriterion = new TaskConfig(rootOfTerminationCriterionVertex.getConfiguration());
            }
            rootOfTerminationCriterionVertex.setInvokableClass(IterationTailPactTask.class);
            tailConfigOfTerminationCriterion.setIsSolutionSetUpdate();
            tailConfigOfTerminationCriterion.setOutputSerializer(bulkNode.getSerializerForIterationChannel());
            headConfig.setWaitForSolutionSetUpdate();
        }
        AggregatorRegistry aggs = bulkNode.getIterationNode().getIterationContract().getAggregators();
        Collection allAggregators = aggs.getAllRegisteredAggregators();
        headConfig.addIterationAggregators(allAggregators);
        syncConfig.addIterationAggregators(allAggregators);
        String convAggName = aggs.getConvergenceCriterionAggregatorName();
        ConvergenceCriterion convCriterion = aggs.getConvergenceCriterion();
        if (convCriterion != null || convAggName != null) {
            if (convCriterion == null) {
                throw new CompilerException("Error: Convergence criterion aggregator set, but criterion is null.");
            }
            if (convAggName == null) {
                throw new CompilerException("Error: Aggregator convergence criterion set, but aggregator is null.");
            }
            syncConfig.setConvergenceCriterion(convAggName, convCriterion);
        }
    }

    private void finalizeWorksetIteration(IterationDescriptor descr) {
        TaskConfig solutionDeltaConfig;
        AbstractJobVertex solutionDeltaVertex;
        TaskConfig worksetTailConfig;
        TaskInChain taskInChain;
        WorksetIterationPlanNode iterNode = (WorksetIterationPlanNode)descr.getIterationNode();
        AbstractJobVertex headVertex = descr.getHeadTask();
        TaskConfig headConfig = new TaskConfig(headVertex.getConfiguration());
        TaskConfig headFinalOutputConfig = descr.getHeadFinalResultConfig();
        int numStepFunctionOuts = headConfig.getNumOutputs();
        int numFinalOuts = headFinalOutputConfig.getNumOutputs();
        if (numStepFunctionOuts == 0) {
            throw new CompilerException("The workset iteration has no operation on the workset inside the step function.");
        }
        headConfig.setIterationHeadFinalOutputConfig(headFinalOutputConfig);
        headConfig.setIterationHeadIndexOfSyncOutput(numStepFunctionOuts + numFinalOuts);
        double relativeMemory = iterNode.getRelativeMemoryPerSubTask();
        if (relativeMemory <= 0.0) {
            throw new CompilerException("Bug: No memory has been assigned to the workset iteration.");
        }
        headConfig.setIsWorksetIteration();
        headConfig.setRelativeBackChannelMemory(relativeMemory / 2.0);
        headConfig.setRelativeSolutionSetMemory(relativeMemory / 2.0);
        headConfig.setSolutionSetSerializer(iterNode.getSolutionSetSerializer());
        headConfig.setSolutionSetComparator(iterNode.getSolutionSetComparator());
        AbstractJobVertex sync = new AbstractJobVertex("Sync (" + iterNode.getNodeName() + ")");
        sync.setInvokableClass(IterationSynchronizationSinkTask.class);
        sync.setParallelism(1);
        this.auxVertices.add(sync);
        TaskConfig syncConfig = new TaskConfig(sync.getConfiguration());
        syncConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, headVertex.getParallelism());
        int maxNumIterations = iterNode.getIterationNode().getIterationContract().getMaximumNumberOfIterations();
        if (maxNumIterations < 1) {
            throw new CompilerException("Cannot create workset iteration with unspecified maximum number of iterations.");
        }
        syncConfig.setNumberOfIterations(maxNumIterations);
        sync.connectNewDataSetAsInput(headVertex, DistributionPattern.POINTWISE);
        PlanNode nextWorksetNode = iterNode.getNextWorkSetPlanNode();
        PlanNode solutionDeltaNode = iterNode.getSolutionSetDeltaPlanNode();
        boolean hasWorksetTail = nextWorksetNode.getOutgoingChannels().isEmpty();
        boolean hasSolutionSetTail = !iterNode.isImmediateSolutionSetUpdate() || !hasWorksetTail;
        AbstractJobVertex nextWorksetVertex = this.vertices.get(nextWorksetNode);
        if (nextWorksetVertex == null) {
            taskInChain = this.chainedTasks.get(nextWorksetNode);
            if (taskInChain == null) {
                throw new CompilerException("Bug: Next workset node not found as vertex or chained task.");
            }
            nextWorksetVertex = taskInChain.getContainingVertex();
            worksetTailConfig = taskInChain.getTaskConfig();
        } else {
            worksetTailConfig = new TaskConfig(nextWorksetVertex.getConfiguration());
        }
        worksetTailConfig.setIsWorksetIteration();
        worksetTailConfig.setIsWorksetUpdate();
        if (hasWorksetTail) {
            nextWorksetVertex.setInvokableClass(IterationTailPactTask.class);
            worksetTailConfig.setOutputSerializer(iterNode.getWorksetSerializer());
        }
        if ((solutionDeltaVertex = this.vertices.get(solutionDeltaNode)) == null) {
            taskInChain = this.chainedTasks.get(solutionDeltaNode);
            if (taskInChain == null) {
                throw new CompilerException("Bug: Solution Set Delta not found as vertex or chained task.");
            }
            solutionDeltaVertex = taskInChain.getContainingVertex();
            solutionDeltaConfig = taskInChain.getTaskConfig();
        } else {
            solutionDeltaConfig = new TaskConfig(solutionDeltaVertex.getConfiguration());
        }
        solutionDeltaConfig.setIsWorksetIteration();
        solutionDeltaConfig.setIsSolutionSetUpdate();
        if (hasSolutionSetTail) {
            solutionDeltaVertex.setInvokableClass(IterationTailPactTask.class);
            solutionDeltaConfig.setOutputSerializer(iterNode.getSolutionSetSerializer());
            headConfig.setWaitForSolutionSetUpdate();
        } else {
            if (!iterNode.isImmediateSolutionSetUpdate()) {
                throw new CompilerException("A solution set update without dedicated tail is not set to perform immediate updates.");
            }
            solutionDeltaConfig.setIsSolutionSetUpdateWithoutReprobe();
        }
        AggregatorRegistry aggs = iterNode.getIterationNode().getIterationContract().getAggregators();
        Collection allAggregators = aggs.getAllRegisteredAggregators();
        for (AggregatorWithName agg : allAggregators) {
            if (!agg.getName().equals("pact.runtime.workset-empty-aggregator")) continue;
            throw new CompilerException("User defined aggregator used the same name as built-in workset termination check aggregator: pact.runtime.workset-empty-aggregator");
        }
        headConfig.addIterationAggregators(allAggregators);
        syncConfig.addIterationAggregators(allAggregators);
        String convAggName = aggs.getConvergenceCriterionAggregatorName();
        ConvergenceCriterion convCriterion = aggs.getConvergenceCriterion();
        if (convCriterion != null || convAggName != null) {
            throw new CompilerException("Error: Cannot use custom convergence criterion with workset iteration. Workset iterations have implicit convergence criterion where workset is empty.");
        }
        headConfig.addIterationAggregator("pact.runtime.workset-empty-aggregator", (Aggregator)new LongSumAggregator());
        syncConfig.addIterationAggregator("pact.runtime.workset-empty-aggregator", (Aggregator)new LongSumAggregator());
        syncConfig.setConvergenceCriterion("pact.runtime.workset-empty-aggregator", (ConvergenceCriterion)new WorksetEmptyConvergenceCriterion());
    }

    private static final class IterationDescriptor {
        private final IterationPlanNode iterationNode;
        private AbstractJobVertex headTask;
        private TaskConfig headConfig;
        private TaskConfig headFinalResultConfig;
        private final int id;

        public IterationDescriptor(IterationPlanNode iterationNode, int id) {
            this.iterationNode = iterationNode;
            this.id = id;
        }

        public IterationPlanNode getIterationNode() {
            return this.iterationNode;
        }

        public void setHeadTask(AbstractJobVertex headTask, TaskConfig headConfig) {
            this.headTask = headTask;
            this.headFinalResultConfig = new TaskConfig(new Configuration());
            if (this.headConfig != null) {
                headConfig.getConfiguration().addAll(this.headConfig.getConfiguration());
            }
            this.headConfig = headConfig;
        }

        public AbstractJobVertex getHeadTask() {
            return this.headTask;
        }

        public TaskConfig getHeadFinalResultConfig() {
            return this.headFinalResultConfig;
        }

        public int getId() {
            return this.id;
        }
    }

    private static final class TaskInChain {
        private final Class<? extends ChainedDriver<?, ?>> chainedTask;
        private final TaskConfig taskConfig;
        private final String taskName;
        private AbstractJobVertex containingVertex;

        TaskInChain(Class<? extends ChainedDriver<?, ?>> chainedTask, TaskConfig taskConfig, String taskName) {
            this.chainedTask = chainedTask;
            this.taskConfig = taskConfig;
            this.taskName = taskName;
        }

        public Class<? extends ChainedDriver<?, ?>> getChainedTask() {
            return this.chainedTask;
        }

        public TaskConfig getTaskConfig() {
            return this.taskConfig;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public AbstractJobVertex getContainingVertex() {
            return this.containingVertex;
        }

        public void setContainingVertex(AbstractJobVertex containingVertex) {
            this.containingVertex = containingVertex;
        }
    }
}

