/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.postpass;

import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.postpass.AbstractSchema;
import org.apache.flink.compiler.postpass.MissingFieldTypeInfoException;
import org.apache.flink.types.Key;

public class PostPassUtils {
    public static <X> Class<? extends Key<?>>[] getKeys(AbstractSchema<Class<? extends X>> schema, int[] fields) throws MissingFieldTypeInfoException {
        Class[] keyTypes = new Class[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Class<X> keyType;
            Class<X> type = schema.getType(fields[i]);
            if (type == null) {
                throw new MissingFieldTypeInfoException(i);
            }
            if (!Key.class.isAssignableFrom(type)) {
                throw new CompilerException("The field type " + type.getName() + " cannot be used as a key because it does not implement the interface 'Key'");
            }
            keyTypes[i] = keyType = type;
        }
        return keyTypes;
    }
}

