/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.NothingTypeInfo;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.dag.BinaryUnionNode;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.InterestingPropertiesClearer;
import org.apache.flink.optimizer.dag.IterationNode;
import org.apache.flink.optimizer.dag.NoOpNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.PlanCacheCleaner;
import org.apache.flink.optimizer.dag.SolutionSetNode;
import org.apache.flink.optimizer.dag.TempMode;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.dag.UnaryOperatorNode;
import org.apache.flink.optimizer.dag.WorksetNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.InterestingProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.operators.OperatorDescriptorSingle;
import org.apache.flink.optimizer.operators.SolutionSetDeltaOperator;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.NamedChannel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SolutionSetPlanNode;
import org.apache.flink.optimizer.plan.WorksetIterationPlanNode;
import org.apache.flink.optimizer.plan.WorksetPlanNode;
import org.apache.flink.optimizer.traversals.InterestingPropertyVisitor;
import org.apache.flink.optimizer.util.NoOpBinaryUdfOp;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.util.Visitor;

public class WorksetIterationNode
extends TwoInputNode
implements IterationNode {
    private static final int DEFAULT_COST_WEIGHT = 20;
    private final FieldList solutionSetKeyFields;
    private final GlobalProperties partitionedProperties;
    private final List<OperatorDescriptorDual> dataProperties;
    private SolutionSetNode solutionSetNode;
    private WorksetNode worksetNode;
    private OptimizerNode solutionSetDelta;
    private OptimizerNode nextWorkset;
    private DagConnection solutionSetDeltaRootConnection;
    private DagConnection nextWorksetRootConnection;
    private SingleRootJoiner singleRoot;
    private boolean solutionDeltaImmediatelyAfterSolutionJoin;
    private final int costWeight;

    public WorksetIterationNode(DeltaIterationBase<?, ?> iteration) {
        super((DualInputOperator<?, ?, ?, ?>)iteration);
        int weight;
        int[] ssKeys = iteration.getSolutionSetKeyFields();
        if (ssKeys == null || ssKeys.length == 0) {
            throw new CompilerException("Invalid WorksetIteration: No key fields defined for the solution set.");
        }
        this.solutionSetKeyFields = new FieldList(ssKeys);
        this.partitionedProperties = new GlobalProperties();
        this.partitionedProperties.setHashPartitioned(this.solutionSetKeyFields);
        int n = weight = iteration.getMaximumNumberOfIterations() > 0 ? iteration.getMaximumNumberOfIterations() : 20;
        if (weight > 100) {
            weight = 100;
        }
        this.costWeight = weight;
        this.dataProperties = Collections.singletonList(new WorksetOpDescriptor(this.solutionSetKeyFields));
    }

    public DeltaIterationBase<?, ?> getIterationContract() {
        return (DeltaIterationBase)this.getOperator();
    }

    public SolutionSetNode getSolutionSetNode() {
        return this.solutionSetNode;
    }

    public WorksetNode getWorksetNode() {
        return this.worksetNode;
    }

    public OptimizerNode getNextWorkset() {
        return this.nextWorkset;
    }

    public OptimizerNode getSolutionSetDelta() {
        return this.solutionSetDelta;
    }

    public void setPartialSolution(SolutionSetNode solutionSetNode, WorksetNode worksetNode) {
        if (this.solutionSetNode != null || this.worksetNode != null) {
            throw new IllegalStateException("Error: Initializing WorksetIterationNode multiple times.");
        }
        this.solutionSetNode = solutionSetNode;
        this.worksetNode = worksetNode;
    }

    public void setNextPartialSolution(OptimizerNode solutionSetDelta, OptimizerNode nextWorkset, ExecutionMode executionMode) {
        TwoInputNode solutionDeltaTwoInput;
        if (solutionSetDelta instanceof TwoInputNode && ((solutionDeltaTwoInput = (TwoInputNode)solutionSetDelta).getFirstPredecessorNode() == this.solutionSetNode || solutionDeltaTwoInput.getSecondPredecessorNode() == this.solutionSetNode)) {
            this.solutionDeltaImmediatelyAfterSolutionJoin = true;
        }
        if (nextWorkset == this.worksetNode || nextWorkset instanceof BinaryUnionNode) {
            NoOpNode noop = new NoOpNode();
            noop.setParallelism(this.getParallelism());
            DagConnection noOpConn = new DagConnection(nextWorkset, noop, executionMode);
            noop.setIncomingConnection(noOpConn);
            nextWorkset.addOutgoingConnection(noOpConn);
            nextWorkset = noop;
        }
        UnaryOperatorNode solutionSetDeltaUpdateAux = new UnaryOperatorNode("Solution-Set Delta", (FieldSet)this.getSolutionSetKeyFields(), new SolutionSetDeltaOperator(this.getSolutionSetKeyFields()));
        solutionSetDeltaUpdateAux.setParallelism(this.getParallelism());
        DagConnection conn = new DagConnection(solutionSetDelta, solutionSetDeltaUpdateAux, executionMode);
        solutionSetDeltaUpdateAux.setIncomingConnection(conn);
        solutionSetDelta.addOutgoingConnection(conn);
        this.solutionSetDelta = solutionSetDeltaUpdateAux;
        this.nextWorkset = nextWorkset;
        this.singleRoot = new SingleRootJoiner();
        this.solutionSetDeltaRootConnection = new DagConnection(solutionSetDeltaUpdateAux, this.singleRoot, executionMode);
        this.nextWorksetRootConnection = new DagConnection(nextWorkset, this.singleRoot, executionMode);
        this.singleRoot.setInputs(this.solutionSetDeltaRootConnection, this.nextWorksetRootConnection);
        solutionSetDeltaUpdateAux.addOutgoingConnection(this.solutionSetDeltaRootConnection);
        nextWorkset.addOutgoingConnection(this.nextWorksetRootConnection);
    }

    @Override
    public int getCostWeight() {
        return this.costWeight;
    }

    public TwoInputNode getSingleRootOfStepFunction() {
        return this.singleRoot;
    }

    public FieldList getSolutionSetKeyFields() {
        return this.solutionSetKeyFields;
    }

    public OptimizerNode getInitialSolutionSetPredecessorNode() {
        return this.getFirstPredecessorNode();
    }

    public OptimizerNode getInitialWorksetPredecessorNode() {
        return this.getSecondPredecessorNode();
    }

    @Override
    public String getOperatorName() {
        return "Workset Iteration";
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return new SemanticProperties.EmptySemanticProperties();
    }

    @Override
    protected void readStubAnnotations() {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        this.estimatedOutputSize = this.getFirstPredecessorNode().getEstimatedOutputSize();
        this.estimatedNumRecords = this.getFirstPredecessorNode().getEstimatedNumRecords();
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return this.dataProperties;
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        RequestedGlobalProperties partitionedProperties = new RequestedGlobalProperties();
        partitionedProperties.setHashPartitioned((FieldSet)this.solutionSetKeyFields);
        InterestingProperties partitionedIP = new InterestingProperties();
        partitionedIP.addGlobalProperties(partitionedProperties);
        partitionedIP.addLocalProperties(new RequestedLocalProperties());
        this.nextWorksetRootConnection.setInterestingProperties(new InterestingProperties());
        this.solutionSetDeltaRootConnection.setInterestingProperties(partitionedIP.clone());
        InterestingPropertyVisitor ipv = new InterestingPropertyVisitor(estimator);
        this.nextWorkset.accept(ipv);
        this.solutionSetDelta.accept(ipv);
        InterestingProperties worksetIntProps = this.worksetNode.getInterestingProperties();
        InterestingProperties intProps = new InterestingProperties();
        intProps.getGlobalProperties().addAll(worksetIntProps.getGlobalProperties());
        intProps.getLocalProperties().addAll(worksetIntProps.getLocalProperties());
        this.nextWorksetRootConnection.clearInterestingProperties();
        this.nextWorkset.accept(InterestingPropertiesClearer.INSTANCE);
        this.nextWorksetRootConnection.setInterestingProperties(intProps);
        this.nextWorkset.accept(ipv);
        InterestingProperties inProps = this.worksetNode.getInterestingProperties().clone();
        inProps.addGlobalProperties(new RequestedGlobalProperties());
        inProps.addLocalProperties(new RequestedLocalProperties());
        this.input2.setInterestingProperties(inProps);
        this.input1.setInterestingProperties(partitionedIP);
    }

    @Override
    public void clearInterestingProperties() {
        super.clearInterestingProperties();
        this.nextWorksetRootConnection.clearInterestingProperties();
        this.solutionSetDeltaRootConnection.clearInterestingProperties();
        this.nextWorkset.accept(InterestingPropertiesClearer.INSTANCE);
        this.solutionSetDelta.accept(InterestingPropertiesClearer.INSTANCE);
    }

    @Override
    protected void instantiate(OperatorDescriptorDual operator, Channel solutionSetIn, Channel worksetIn, List<Set<? extends NamedChannel>> broadcastPlanChannels, List<PlanNode> target, CostEstimator estimator, RequestedGlobalProperties globPropsReqSolutionSet, RequestedGlobalProperties globPropsReqWorkset, RequestedLocalProperties locPropsReqSolutionSet, RequestedLocalProperties locPropsReqWorkset) {
        PlanNode candidate;
        this.placePipelineBreakersIfNecessary(DriverStrategy.HYBRIDHASH_BUILD_FIRST, solutionSetIn, worksetIn);
        this.nextWorkset.accept(PlanCacheCleaner.INSTANCE);
        this.solutionSetDelta.accept(PlanCacheCleaner.INSTANCE);
        this.worksetNode.setCandidateProperties(worksetIn.getGlobalProperties(), worksetIn.getLocalProperties(), worksetIn);
        this.solutionSetNode.setCandidateProperties(this.partitionedProperties, new LocalProperties(), solutionSetIn);
        SolutionSetPlanNode sspn = this.solutionSetNode.getCurrentSolutionSetPlanNode();
        WorksetPlanNode wspn = this.worksetNode.getCurrentWorksetPlanNode();
        List<PlanNode> solutionSetDeltaCandidates = this.solutionSetDelta.getAlternativePlans(estimator);
        List<PlanNode> worksetCandidates = this.nextWorkset.getAlternativePlans(estimator);
        ArrayList newCandidates = new ArrayList();
        Iterator<PlanNode> planDeleter = worksetCandidates.iterator();
        while (planDeleter.hasNext()) {
            PlanNode.FeedbackPropertiesMeetRequirementsReport report2;
            LocalProperties atEndLocal;
            GlobalProperties atEndGlobal;
            candidate = planDeleter.next();
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = candidate.checkPartialSolutionPropertiesMet(wspn, atEndGlobal = candidate.getGlobalProperties(), atEndLocal = candidate.getLocalProperties());
            if (report == PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION || report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET) continue;
            Channel toNoOp = new Channel(candidate);
            globPropsReqWorkset.parameterizeChannel(toNoOp, false, this.nextWorksetRootConnection.getDataExchangeMode(), false);
            locPropsReqWorkset.parameterizeChannel(toNoOp);
            UnaryOperatorNode rebuildWorksetPropertiesNode = new UnaryOperatorNode("Rebuild Workset Properties", (FieldSet)FieldList.EMPTY_LIST, new OperatorDescriptorSingle[0]);
            rebuildWorksetPropertiesNode.setParallelism(candidate.getParallelism());
            SingleInputPlanNode rebuildWorksetPropertiesPlanNode = new SingleInputPlanNode(rebuildWorksetPropertiesNode, "Rebuild Workset Properties", toNoOp, DriverStrategy.UNARY_NO_OP);
            rebuildWorksetPropertiesPlanNode.initProperties(toNoOp.getGlobalProperties(), toNoOp.getLocalProperties());
            estimator.costOperator(rebuildWorksetPropertiesPlanNode);
            GlobalProperties atEndGlobalModified = rebuildWorksetPropertiesPlanNode.getGlobalProperties();
            LocalProperties atEndLocalModified = rebuildWorksetPropertiesPlanNode.getLocalProperties();
            if (!(atEndGlobalModified.equals(atEndGlobal) && atEndLocalModified.equals(atEndLocal) || (report2 = candidate.checkPartialSolutionPropertiesMet(wspn, atEndGlobalModified, atEndLocalModified)) == PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET)) {
                newCandidates.add(rebuildWorksetPropertiesPlanNode);
            }
            planDeleter.remove();
        }
        worksetCandidates.addAll(newCandidates);
        if (worksetCandidates.isEmpty()) {
            return;
        }
        for (PlanNode solutionSetDeltaCandidate : solutionSetDeltaCandidates) {
            candidate = (SingleInputPlanNode)solutionSetDeltaCandidate;
            GlobalProperties gp = candidate.getGlobalProperties();
            if (gp.getPartitioning() == PartitioningProperty.HASH_PARTITIONED && gp.getPartitioningFields() != null && gp.getPartitioningFields().equals((Object)this.solutionSetKeyFields)) continue;
            throw new CompilerException("Bug: The solution set delta is not partitioned.");
        }
        GlobalProperties gp = new GlobalProperties();
        gp.setHashPartitioned(this.solutionSetKeyFields);
        gp.addUniqueFieldCombination((FieldSet)this.solutionSetKeyFields);
        LocalProperties lp = LocalProperties.EMPTY.addUniqueFields((FieldSet)this.solutionSetKeyFields);
        for (PlanNode solutionSetCandidate : solutionSetDeltaCandidates) {
            for (PlanNode worksetCandidate : worksetCandidates) {
                boolean immediateDeltaUpdate;
                if (!this.singleRoot.areBranchCompatible(solutionSetCandidate, worksetCandidate)) continue;
                SingleInputPlanNode siSolutionDeltaCandidate = (SingleInputPlanNode)solutionSetCandidate;
                if (siSolutionDeltaCandidate.getInput().getShipStrategy() == ShipStrategyType.FORWARD && this.solutionDeltaImmediatelyAfterSolutionJoin) {
                    if (siSolutionDeltaCandidate.getDriverStrategy() != DriverStrategy.UNARY_NO_OP || siSolutionDeltaCandidate.getInput().getLocalStrategy() != LocalStrategy.NONE) {
                        throw new CompilerException("Invalid Solution set delta node.");
                    }
                    solutionSetCandidate = siSolutionDeltaCandidate.getInput().getSource();
                    immediateDeltaUpdate = true;
                } else {
                    siSolutionDeltaCandidate.getInput().setTempMode(TempMode.PIPELINE_BREAKER);
                    immediateDeltaUpdate = false;
                }
                WorksetIterationPlanNode wsNode = new WorksetIterationPlanNode(this, this.getOperator().getName(), solutionSetIn, worksetIn, sspn, wspn, worksetCandidate, solutionSetCandidate);
                wsNode.setImmediateSolutionSetUpdate(immediateDeltaUpdate);
                wsNode.initProperties(gp, lp);
                target.add(wsNode);
            }
        }
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getFirstPredecessorNode().closedBranchingNodes);
        this.addClosedBranches(this.getSecondPredecessorNode().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> result1 = this.getFirstPredecessorNode().getBranchesForParent(this.getFirstIncomingConnection());
        List<OptimizerNode.UnclosedBranchDescriptor> result2 = this.getSecondPredecessorNode().getBranchesForParent(this.getSecondIncomingConnection());
        ArrayList<OptimizerNode.UnclosedBranchDescriptor> inputsMerged1 = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>();
        this.mergeLists(result1, result2, inputsMerged1, true);
        this.addClosedBranches(this.getSingleRootOfStepFunction().closedBranchingNodes);
        ArrayList<OptimizerNode.UnclosedBranchDescriptor> inputsMerged2 = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>();
        List result3 = this.getSingleRootOfStepFunction().openBranches;
        this.mergeLists(inputsMerged1, result3, inputsMerged2, true);
        List<OptimizerNode.UnclosedBranchDescriptor> result = this.computeUnclosedBranchStackForBroadcastInputs(inputsMerged2);
        this.openBranches = result == null || result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    public void acceptForStepFunction(Visitor<OptimizerNode> visitor) {
        this.singleRoot.accept(visitor);
    }

    public static class SingleRootJoiner
    extends TwoInputNode {
        SingleRootJoiner() {
            super(new NoOpBinaryUdfOp(new NothingTypeInfo()));
            this.setParallelism(1);
        }

        public void setInputs(DagConnection input1, DagConnection input2) {
            this.input1 = input1;
            this.input2 = input2;
        }

        @Override
        public String getOperatorName() {
            return "Internal Utility Node";
        }

        @Override
        protected List<OperatorDescriptorDual> getPossibleProperties() {
            return Collections.emptyList();
        }

        @Override
        protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        }
    }

    private static final class WorksetOpDescriptor
    extends OperatorDescriptorDual {
        private WorksetOpDescriptor(FieldList solutionSetKeys) {
            super(solutionSetKeys, null);
        }

        @Override
        public DriverStrategy getStrategy() {
            return DriverStrategy.NONE;
        }

        @Override
        protected List<OperatorDescriptorDual.GlobalPropertiesPair> createPossibleGlobalProperties() {
            RequestedGlobalProperties partitionedGp = new RequestedGlobalProperties();
            partitionedGp.setHashPartitioned((FieldSet)this.keys1);
            return Collections.singletonList(new OperatorDescriptorDual.GlobalPropertiesPair(partitionedGp, new RequestedGlobalProperties()));
        }

        @Override
        protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
            return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(new RequestedLocalProperties(), new RequestedLocalProperties()));
        }

        @Override
        public boolean areCompatible(RequestedGlobalProperties requested1, RequestedGlobalProperties requested2, GlobalProperties produced1, GlobalProperties produced2) {
            return true;
        }

        @Override
        public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
            return true;
        }

        @Override
        public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GlobalProperties computeGlobalProperties(GlobalProperties in1, GlobalProperties in2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalProperties computeLocalProperties(LocalProperties in1, LocalProperties in2) {
            throw new UnsupportedOperationException();
        }
    }
}

