/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;

public abstract class AbstractJoinDescriptor
extends OperatorDescriptorDual {
    private final boolean broadcastFirstAllowed;
    private final boolean broadcastSecondAllowed;
    private final boolean repartitionAllowed;
    private Partitioner<?> customPartitioner;

    protected AbstractJoinDescriptor(FieldList keys1, FieldList keys2) {
        this(keys1, keys2, true, true, true);
    }

    protected AbstractJoinDescriptor(FieldList keys1, FieldList keys2, boolean broadcastFirstAllowed, boolean broadcastSecondAllowed, boolean repartitionAllowed) {
        super(keys1, keys2);
        this.broadcastFirstAllowed = broadcastFirstAllowed;
        this.broadcastSecondAllowed = broadcastSecondAllowed;
        this.repartitionAllowed = repartitionAllowed;
    }

    public void setCustomPartitioner(Partitioner<?> partitioner) {
        this.customPartitioner = partitioner;
    }

    @Override
    protected List<OperatorDescriptorDual.GlobalPropertiesPair> createPossibleGlobalProperties() {
        ArrayList<OperatorDescriptorDual.GlobalPropertiesPair> pairs = new ArrayList<OperatorDescriptorDual.GlobalPropertiesPair>();
        if (this.repartitionAllowed) {
            if (this.customPartitioner != null) {
                RequestedGlobalProperties partitioned_left = new RequestedGlobalProperties();
                partitioned_left.setCustomPartitioned((FieldSet)this.keys1, this.customPartitioner);
                RequestedGlobalProperties partitioned_right = new RequestedGlobalProperties();
                partitioned_right.setCustomPartitioned((FieldSet)this.keys2, this.customPartitioner);
                return Collections.singletonList(new OperatorDescriptorDual.GlobalPropertiesPair(partitioned_left, partitioned_right));
            }
            RequestedGlobalProperties partitioned_left_any = new RequestedGlobalProperties();
            RequestedGlobalProperties partitioned_right_any = new RequestedGlobalProperties();
            partitioned_left_any.setAnyPartitioning((FieldSet)this.keys1);
            partitioned_right_any.setAnyPartitioning((FieldSet)this.keys2);
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(partitioned_left_any, partitioned_right_any));
            RequestedGlobalProperties partitioned_left_hash = new RequestedGlobalProperties();
            RequestedGlobalProperties partitioned_right_hash = new RequestedGlobalProperties();
            partitioned_left_hash.setHashPartitioned((FieldSet)this.keys1);
            partitioned_right_hash.setHashPartitioned((FieldSet)this.keys2);
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(partitioned_left_hash, partitioned_right_hash));
            RequestedGlobalProperties partitioned1 = new RequestedGlobalProperties();
            if (this.customPartitioner == null) {
                partitioned1.setAnyPartitioning((FieldSet)this.keys1);
            } else {
                partitioned1.setCustomPartitioned((FieldSet)this.keys1, this.customPartitioner);
            }
            RequestedGlobalProperties partitioned2 = new RequestedGlobalProperties();
            if (this.customPartitioner == null) {
                partitioned2.setAnyPartitioning((FieldSet)this.keys2);
            } else {
                partitioned2.setCustomPartitioned((FieldSet)this.keys2, this.customPartitioner);
            }
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(partitioned1, partitioned2));
        }
        if (this.broadcastSecondAllowed) {
            RequestedGlobalProperties any1 = new RequestedGlobalProperties();
            RequestedGlobalProperties replicated2 = new RequestedGlobalProperties();
            replicated2.setFullyReplicated();
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(any1, replicated2));
        }
        if (this.broadcastFirstAllowed) {
            RequestedGlobalProperties replicated1 = new RequestedGlobalProperties();
            replicated1.setFullyReplicated();
            RequestedGlobalProperties any2 = new RequestedGlobalProperties();
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(replicated1, any2));
        }
        return pairs;
    }

    @Override
    public boolean areCompatible(RequestedGlobalProperties requested1, RequestedGlobalProperties requested2, GlobalProperties produced1, GlobalProperties produced2) {
        if (requested1.getPartitioning().isPartitionedOnKey() && requested2.getPartitioning().isPartitionedOnKey()) {
            if (produced1.getPartitioning() == PartitioningProperty.HASH_PARTITIONED && produced2.getPartitioning() == PartitioningProperty.HASH_PARTITIONED) {
                return this.checkEquivalentFieldPositionsInKeyFields(produced1.getPartitioningFields(), produced2.getPartitioningFields());
            }
            if (produced1.getPartitioning() == PartitioningProperty.RANGE_PARTITIONED && produced2.getPartitioning() == PartitioningProperty.RANGE_PARTITIONED) {
                return false;
            }
            if (produced1.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING && produced2.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING) {
                return produced1.getPartitioningFields().isExactMatch(this.keys1) && produced2.getPartitioningFields().isExactMatch(this.keys2) && produced1.getCustomPartitioner() != null && produced2.getCustomPartitioner() != null && produced1.getCustomPartitioner().equals(produced2.getCustomPartitioner());
            }
            return false;
        }
        return true;
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties in1, GlobalProperties in2) {
        GlobalProperties gp = GlobalProperties.combine(in1, in2);
        if (gp.getUniqueFieldCombination() != null && gp.getUniqueFieldCombination().size() > 0 && gp.getPartitioning() == PartitioningProperty.RANDOM_PARTITIONED) {
            gp.setAnyPartitioning(gp.getUniqueFieldCombination().iterator().next().toFieldList());
        }
        gp.clearUniqueFieldCombinations();
        return gp;
    }
}

