/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotSharingGroupAssignment;
import org.apache.flink.util.AbstractID;

public class SharedSlot
extends Slot {
    private final SlotSharingGroupAssignment assignmentGroup;
    private final Set<Slot> subSlots;

    public SharedSlot(JobID jobID, Instance instance, int slotNumber, SlotSharingGroupAssignment assignmentGroup) {
        this(jobID, instance, slotNumber, assignmentGroup, null, null);
    }

    public SharedSlot(JobID jobID, Instance instance, int slotNumber, SlotSharingGroupAssignment assignmentGroup, SharedSlot parent, AbstractID groupId) {
        super(jobID, instance, slotNumber, parent, groupId);
        this.assignmentGroup = assignmentGroup;
        this.subSlots = new HashSet<Slot>();
    }

    @Override
    public int getNumberLeaves() {
        while (true) {
            try {
                int result = 0;
                for (Slot slot : this.subSlots) {
                    result += slot.getNumberLeaves();
                }
                return result;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public boolean isRootAndEmpty() {
        return this.getParent() == null && this.subSlots.isEmpty();
    }

    public boolean hasChildren() {
        return this.subSlots.size() > 0;
    }

    @Override
    public void releaseSlot() {
        this.assignmentGroup.releaseSharedSlot(this);
        if (!this.isReleased() || !this.subSlots.isEmpty()) {
            throw new IllegalStateException("Bug: SharedSlot is not empty and released after call to releaseSlot()");
        }
    }

    Set<Slot> getSubSlots() {
        return this.subSlots;
    }

    SimpleSlot allocateSubSlot(AbstractID groupId) {
        if (this.isAlive()) {
            SimpleSlot slot = new SimpleSlot(this.getJobID(), this.getInstance(), this.subSlots.size(), this, groupId);
            this.subSlots.add(slot);
            return slot;
        }
        return null;
    }

    SharedSlot allocateSharedSlot(AbstractID groupId) {
        if (this.isAlive()) {
            SharedSlot slot = new SharedSlot(this.getJobID(), this.getInstance(), this.subSlots.size(), this.assignmentGroup, this, groupId);
            this.subSlots.add(slot);
            return slot;
        }
        return null;
    }

    void releaseChild(SimpleSlot slot) {
        this.assignmentGroup.releaseSimpleSlot(slot);
    }

    int removeDisposedChildSlot(Slot slot) {
        if (!slot.isReleased() || !this.subSlots.remove(slot)) {
            throw new IllegalArgumentException();
        }
        return this.subSlots.size();
    }

    @Override
    public String toString() {
        return "Shared " + super.toString();
    }
}

