/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.scope.JobManagerScopeFormat;

public class JobManagerMetricGroup
extends ComponentMetricGroup {
    private final Map<JobID, JobManagerJobMetricGroup> jobs = new HashMap<JobID, JobManagerJobMetricGroup>();
    private final String hostname;

    public JobManagerMetricGroup(MetricRegistry registry, String hostname) {
        this(registry, registry.getScopeFormats().getJobManagerFormat(), hostname);
    }

    public JobManagerMetricGroup(MetricRegistry registry, JobManagerScopeFormat scopeFormat, String hostname) {
        super(registry, scopeFormat.formatScope(hostname));
        this.hostname = hostname;
    }

    public String hostname() {
        return this.hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobManagerJobMetricGroup addJob(JobGraph job) {
        JobID jobId = job.getJobID();
        String jobName = job.getName();
        JobManagerMetricGroup jobManagerMetricGroup = this;
        synchronized (jobManagerMetricGroup) {
            if (!this.isClosed()) {
                JobManagerJobMetricGroup currentJobGroup = this.jobs.get(jobId);
                if (currentJobGroup == null || currentJobGroup.isClosed()) {
                    currentJobGroup = new JobManagerJobMetricGroup(this.registry, this, jobId, jobName);
                    this.jobs.put(jobId, currentJobGroup);
                }
                return currentJobGroup;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(JobID jobId) {
        if (jobId == null) {
            return;
        }
        JobManagerMetricGroup jobManagerMetricGroup = this;
        synchronized (jobManagerMetricGroup) {
            JobManagerJobMetricGroup containedGroup = this.jobs.remove(jobId);
            if (containedGroup != null) {
                containedGroup.close();
            }
        }
    }

    public int numRegisteredJobMetricGroups() {
        return this.jobs.size();
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.jobs.values();
    }
}

