/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.IOMetricGroup;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.scope.TaskScopeFormat;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class TaskMetricGroup
extends ComponentMetricGroup {
    private final TaskManagerJobMetricGroup parent;
    private final Map<String, OperatorMetricGroup> operators = new HashMap<String, OperatorMetricGroup>();
    private final IOMetricGroup ioMetrics;
    private final AbstractID executionId;
    @Nullable
    private final AbstractID vertexId;
    @Nullable
    private final String taskName;
    private final int subtaskIndex;
    private final int attemptNumber;

    public TaskMetricGroup(MetricRegistry registry, TaskManagerJobMetricGroup parent, @Nullable AbstractID vertexId, AbstractID executionId, @Nullable String taskName, int subtaskIndex, int attemptNumber) {
        this(registry, parent, registry.getScopeFormats().getTaskFormat(), vertexId, executionId, taskName, subtaskIndex, attemptNumber);
    }

    public TaskMetricGroup(MetricRegistry registry, TaskManagerJobMetricGroup parent, TaskScopeFormat scopeFormat, @Nullable AbstractID vertexId, AbstractID executionId, @Nullable String taskName, int subtaskIndex, int attemptNumber) {
        super(registry, scopeFormat.formatScope(parent, vertexId, executionId, taskName, subtaskIndex, attemptNumber));
        this.parent = (TaskManagerJobMetricGroup)Preconditions.checkNotNull((Object)parent);
        this.executionId = (AbstractID)Preconditions.checkNotNull((Object)executionId);
        this.vertexId = vertexId;
        this.taskName = taskName;
        this.subtaskIndex = subtaskIndex;
        this.attemptNumber = attemptNumber;
        this.ioMetrics = new IOMetricGroup(this);
    }

    public final TaskManagerJobMetricGroup parent() {
        return this.parent;
    }

    public AbstractID executionId() {
        return this.executionId;
    }

    @Nullable
    public AbstractID vertexId() {
        return this.vertexId;
    }

    @Nullable
    public String taskName() {
        return this.taskName;
    }

    public int subtaskIndex() {
        return this.subtaskIndex;
    }

    public int attemptNumber() {
        return this.attemptNumber;
    }

    public IOMetricGroup getIOMetricGroup() {
        return this.ioMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperatorMetricGroup addOperator(String name) {
        OperatorMetricGroup operator = new OperatorMetricGroup(this.registry, this, name);
        TaskMetricGroup taskMetricGroup = this;
        synchronized (taskMetricGroup) {
            OperatorMetricGroup previous = this.operators.put(name, operator);
            if (previous == null) {
                return operator;
            }
            this.operators.put(name, previous);
            return previous;
        }
    }

    @Override
    public void close() {
        super.close();
        this.parent.removeTaskMetricGroup(this.executionId);
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.operators.values();
    }
}

