/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateHandle;
import org.apache.flink.runtime.state.filesystem.FileSerializableStateHandle;

public class FileStreamStateHandle
extends AbstractFileStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = -6826990484549987311L;

    public FileStreamStateHandle(Path filePath) {
        super(filePath);
    }

    @Override
    public InputStream getState(ClassLoader userCodeClassLoader) throws Exception {
        this.ensureNotClosed();
        FSDataInputStream inStream = this.getFileSystem().open(this.getFilePath());
        this.registerCloseable((Closeable)inStream);
        return inStream;
    }

    @Override
    public long getStateSize() throws IOException {
        return this.getFileSize();
    }

    @Override
    public <T extends Serializable> StateHandle<T> toSerializableHandle() {
        FileSerializableStateHandle handle = new FileSerializableStateHandle(this.getFilePath());
        if (this.isClosed()) {
            try {
                handle.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return handle;
    }
}

