/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.akka;

import akka.actor.ActorSystem;
import akka.actor.Address;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.akka.QuarantineHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class DefaultQuarantineHandler
implements QuarantineHandler {
    private final FiniteDuration timeout;
    private final int exitCode;
    private final Logger log;

    public DefaultQuarantineHandler(Time timeout, int exitCode, Logger log) {
        Preconditions.checkNotNull((Object)timeout);
        this.timeout = new FiniteDuration(timeout.getSize(), timeout.getUnit());
        this.exitCode = exitCode;
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
    }

    @Override
    public void wasQuarantinedBy(String remoteSystem, ActorSystem actorSystem) {
        Address actorSystemAddress = AkkaUtils.getAddress(actorSystem);
        this.log.error("The actor system {} has been quarantined by {}. Shutting the actor system down to be able to reestablish a connection!", (Object)actorSystemAddress, (Object)remoteSystem);
        this.shutdownActorSystem(actorSystem);
    }

    @Override
    public void hasQuarantined(String remoteSystem, ActorSystem actorSystem) {
        Address actorSystemAddress = AkkaUtils.getAddress(actorSystem);
        this.log.error("The actor system {} has quarantined the remote actor system {}. Shutting the actor system down to be able to reestablish a connection!", (Object)actorSystemAddress, (Object)remoteSystem);
        this.shutdownActorSystem(actorSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownActorSystem(ActorSystem actorSystem) {
        actorSystem.shutdown();
        try {
            actorSystem.awaitTermination((Duration)this.timeout);
        }
        finally {
            System.exit(this.exitCode);
        }
    }
}

