/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV1;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.ChainedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingCheckpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private final Object lock = new Object();
    private final JobID jobId;
    private final long checkpointId;
    private final long checkpointTimestamp;
    private final Map<JobVertexID, TaskState> taskStates;
    private final Map<ExecutionAttemptID, ExecutionVertex> notYetAcknowledgedTasks;
    private final Set<ExecutionAttemptID> acknowledgedTasks;
    private final CheckpointProperties props;
    private final String targetDirectory;
    private final FlinkCompletableFuture<CompletedCheckpoint> onCompletionPromise = new FlinkCompletableFuture();
    private final Executor executor;
    private int numAcknowledgedTasks;
    private boolean discarded;
    @Nullable
    private PendingCheckpointStats statsCallback;
    private volatile ScheduledFuture<?> cancellerHandle;

    public PendingCheckpoint(JobID jobId, long checkpointId, long checkpointTimestamp, Map<ExecutionAttemptID, ExecutionVertex> verticesToConfirm, CheckpointProperties props, String targetDirectory, Executor executor) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.checkpointId = checkpointId;
        this.checkpointTimestamp = checkpointTimestamp;
        this.notYetAcknowledgedTasks = (Map)Preconditions.checkNotNull(verticesToConfirm);
        this.taskStates = new HashMap<JobVertexID, TaskState>();
        this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props);
        this.targetDirectory = targetDirectory;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        if (props.externalizeCheckpoint() && targetDirectory == null) {
            throw new NullPointerException("No target directory specified to persist checkpoint to.");
        }
        Preconditions.checkArgument((verticesToConfirm.size() > 0 ? 1 : 0) != 0, (Object)"Checkpoint needs at least one vertex that commits the checkpoint");
        this.acknowledgedTasks = new HashSet<ExecutionAttemptID>(verticesToConfirm.size());
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getCheckpointTimestamp() {
        return this.checkpointTimestamp;
    }

    public int getNumberOfNonAcknowledgedTasks() {
        return this.notYetAcknowledgedTasks.size();
    }

    public int getNumberOfAcknowledgedTasks() {
        return this.numAcknowledgedTasks;
    }

    public Map<JobVertexID, TaskState> getTaskStates() {
        return this.taskStates;
    }

    public boolean isFullyAcknowledged() {
        return this.notYetAcknowledgedTasks.isEmpty() && !this.discarded;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public boolean canBeSubsumed() {
        return !this.props.forceCheckpoint();
    }

    CheckpointProperties getProps() {
        return this.props;
    }

    String getTargetDirectory() {
        return this.targetDirectory;
    }

    void setStatsCallback(@Nullable PendingCheckpointStats trackerCallback) {
        this.statsCallback = (PendingCheckpointStats)Preconditions.checkNotNull((Object)trackerCallback);
    }

    public boolean setCancellerHandle(ScheduledFuture<?> cancellerHandle) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancellerHandle == null) {
                if (!this.discarded) {
                    this.cancellerHandle = cancellerHandle;
                    return true;
                }
                return false;
            }
            throw new IllegalStateException("A canceller handle was already set");
        }
    }

    public Future<CompletedCheckpoint> getCompletionFuture() {
        return this.onCompletionPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletedCheckpoint finalizeCheckpoint() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.isFullyAcknowledged(), (Object)"Pending checkpoint has not been fully acknowledged yet.");
            String externalPath = null;
            if (this.props.externalizeCheckpoint()) {
                try {
                    SavepointV1 savepoint = new SavepointV1(this.checkpointId, this.taskStates.values());
                    externalPath = SavepointStore.storeSavepoint(this.targetDirectory, savepoint);
                }
                catch (IOException e) {
                    LOG.error("Failed to persist checkpoint {}.", (Object)this.checkpointId, (Object)e);
                }
            }
            CompletedCheckpoint completed = new CompletedCheckpoint(this.jobId, this.checkpointId, this.checkpointTimestamp, System.currentTimeMillis(), new HashMap<JobVertexID, TaskState>(this.taskStates), this.props, externalPath);
            this.onCompletionPromise.complete(completed);
            if (this.statsCallback != null) {
                CompletedCheckpointStats.DiscardCallback discardCallback = this.statsCallback.reportCompletedCheckpoint(externalPath);
                completed.setDiscardCallback(discardCallback);
            }
            this.dispose(false);
            return completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAcknowledgeResult acknowledgeTask(ExecutionAttemptID executionAttemptId, SubtaskState subtaskState, CheckpointMetaData checkpointMetaData) {
        Object object = this.lock;
        synchronized (object) {
            if (this.discarded) {
                return TaskAcknowledgeResult.DISCARDED;
            }
            ExecutionVertex vertex = this.notYetAcknowledgedTasks.remove((Object)executionAttemptId);
            if (vertex == null) {
                if (this.acknowledgedTasks.contains((Object)executionAttemptId)) {
                    return TaskAcknowledgeResult.DUPLICATE;
                }
                return TaskAcknowledgeResult.UNKNOWN;
            }
            this.acknowledgedTasks.add(executionAttemptId);
            JobVertexID jobVertexID = vertex.getJobvertexId();
            int subtaskIndex = vertex.getParallelSubtaskIndex();
            long ackTimestamp = System.currentTimeMillis();
            long stateSize = 0L;
            if (null != subtaskState) {
                TaskState taskState = this.taskStates.get((Object)jobVertexID);
                if (null == taskState) {
                    ChainedStateHandle<StreamStateHandle> nonPartitionedState = subtaskState.getLegacyOperatorState();
                    ChainedStateHandle<OperatorStateHandle> partitioneableState = subtaskState.getManagedOperatorState();
                    int chainLength = nonPartitionedState != null ? nonPartitionedState.getLength() : (partitioneableState != null ? partitioneableState.getLength() : 1);
                    taskState = new TaskState(jobVertexID, vertex.getTotalNumberOfParallelSubtasks(), vertex.getMaxParallelism(), chainLength);
                    this.taskStates.put(jobVertexID, taskState);
                }
                taskState.putState(subtaskIndex, subtaskState);
                stateSize = subtaskState.getStateSize();
            }
            ++this.numAcknowledgedTasks;
            if (this.statsCallback != null) {
                CheckpointMetrics metrics = checkpointMetaData.getMetrics();
                long alignmentDurationMillis = metrics.getAlignmentDurationNanos() / 1000000L;
                SubtaskStateStats subtaskStateStats = new SubtaskStateStats(subtaskIndex, ackTimestamp, stateSize, metrics.getSyncDurationMillis(), metrics.getAsyncDurationMillis(), metrics.getBytesBufferedInAlignment(), alignmentDurationMillis);
                this.statsCallback.reportSubtaskStats(jobVertexID, subtaskStateStats);
            }
            return TaskAcknowledgeResult.SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortExpired() {
        try {
            Exception cause = new Exception("Checkpoint expired before completing");
            this.onCompletionPromise.completeExceptionally(cause);
            this.reportFailedCheckpoint(cause);
        }
        finally {
            this.dispose(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortSubsumed() {
        try {
            Exception cause = new Exception("Checkpoints has been subsumed");
            this.onCompletionPromise.completeExceptionally(cause);
            this.reportFailedCheckpoint(cause);
            if (this.props.forceCheckpoint()) {
                throw new IllegalStateException("Bug: forced checkpoints must never be subsumed");
            }
        }
        finally {
            this.dispose(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortDeclined() {
        try {
            Exception cause = new Exception("Checkpoint was declined (tasks not ready)");
            this.onCompletionPromise.completeExceptionally(cause);
            this.reportFailedCheckpoint(cause);
        }
        finally {
            this.dispose(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortError(Throwable cause) {
        try {
            Exception failure = new Exception("Checkpoint failed: " + cause.getMessage(), cause);
            this.onCompletionPromise.completeExceptionally(failure);
            this.reportFailedCheckpoint(failure);
        }
        finally {
            this.dispose(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean releaseState) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.numAcknowledgedTasks = -1;
                if (!this.discarded && releaseState) {
                    this.executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                StateUtil.bestEffortDiscardAllStateObjects(PendingCheckpoint.this.taskStates.values());
                            }
                            catch (Exception e) {
                                LOG.warn("Could not properly dispose the pending checkpoint {} of job {}.", new Object[]{PendingCheckpoint.this.checkpointId, PendingCheckpoint.this.jobId, e});
                            }
                            finally {
                                PendingCheckpoint.this.taskStates.clear();
                            }
                        }
                    });
                }
            }
            finally {
                this.discarded = true;
                this.notYetAcknowledgedTasks.clear();
                this.acknowledgedTasks.clear();
                this.cancelCanceller();
            }
        }
    }

    private void cancelCanceller() {
        try {
            ScheduledFuture<?> canceller = this.cancellerHandle;
            if (canceller != null) {
                canceller.cancel(false);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while cancelling checkpoint timeout task", (Throwable)e);
        }
    }

    private void reportFailedCheckpoint(Exception cause) {
        if (this.statsCallback != null) {
            long failureTimestamp = System.currentTimeMillis();
            this.statsCallback.reportFailedCheckpoint(failureTimestamp, cause);
        }
    }

    public String toString() {
        return String.format("Pending Checkpoint %d @ %d - confirmed=%d, pending=%d", this.checkpointId, this.checkpointTimestamp, this.getNumberOfAcknowledgedTasks(), this.getNumberOfNonAcknowledgedTasks());
    }

    public static enum TaskAcknowledgeResult {
        SUCCESS,
        DUPLICATE,
        UNKNOWN,
        DISCARDED;

    }
}

