/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.slots;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class AllocatedSlot {
    private final AllocationID slotAllocationId;
    private final JobID jobID;
    private final TaskManagerLocation taskManagerLocation;
    private final ResourceProfile resourceProfile;
    private final TaskManagerGateway taskManagerGateway;
    private final int slotNumber;

    public AllocatedSlot(AllocationID slotAllocationId, JobID jobID, TaskManagerLocation location, int slotNumber, ResourceProfile resourceProfile, TaskManagerGateway taskManagerGateway) {
        this.slotAllocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)slotAllocationId)));
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.taskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)location);
        this.slotNumber = slotNumber;
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
        this.taskManagerGateway = (TaskManagerGateway)Preconditions.checkNotNull((Object)taskManagerGateway);
    }

    public AllocatedSlot(AllocatedSlot other) {
        this.slotAllocationId = other.slotAllocationId;
        this.jobID = other.jobID;
        this.taskManagerLocation = other.taskManagerLocation;
        this.slotNumber = other.slotNumber;
        this.resourceProfile = other.resourceProfile;
        this.taskManagerGateway = other.taskManagerGateway;
    }

    public AllocationID getSlotAllocationId() {
        return this.slotAllocationId;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public TaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    public TaskManagerGateway getTaskManagerGateway() {
        return this.taskManagerGateway;
    }

    public String toString() {
        return "AllocatedSlot " + (Object)((Object)this.slotAllocationId) + " @ " + this.taskManagerLocation + " - " + this.slotNumber;
    }
}

