/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.AbstractCheckpointMessage;
import org.apache.flink.util.Preconditions;

public class AcknowledgeCheckpoint
extends AbstractCheckpointMessage
implements Serializable {
    private static final long serialVersionUID = -7606214777192401493L;
    private final SubtaskState subtaskState;
    private final CheckpointMetaData checkpointMetaData;

    public AcknowledgeCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, CheckpointMetaData checkpointMetaData) {
        this(job, taskExecutionId, checkpointMetaData, null);
    }

    public AcknowledgeCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, CheckpointMetaData checkpointMetaData, SubtaskState subtaskState) {
        super(job, taskExecutionId, checkpointMetaData.getCheckpointId());
        this.subtaskState = subtaskState;
        this.checkpointMetaData = checkpointMetaData;
        Preconditions.checkArgument((checkpointMetaData.getSyncDurationMillis() >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((checkpointMetaData.getAsyncDurationMillis() >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((checkpointMetaData.getBytesBufferedInAlignment() >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((checkpointMetaData.getAlignmentDurationNanos() >= -1L ? 1 : 0) != 0);
    }

    public SubtaskState getSubtaskState() {
        return this.subtaskState;
    }

    public CheckpointMetaData getCheckpointMetaData() {
        return this.checkpointMetaData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AcknowledgeCheckpoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AcknowledgeCheckpoint that = (AcknowledgeCheckpoint)o;
        return this.subtaskState != null ? this.subtaskState.equals(that.subtaskState) : that.subtaskState == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.subtaskState != null ? this.subtaskState.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return String.format("Confirm Task Checkpoint %d for (%s/%s) - state=%s", new Object[]{this.getCheckpointId(), this.getJob(), this.getTaskExecutionId(), this.subtaskState});
    }
}

