/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.modules.SecurityModule;

public class ZooKeeperModule
implements SecurityModule {
    private static final String ZOOKEEPER_SASL_CLIENT_USERNAME = "zookeeper.sasl.client.username";
    private static final String ZK_ENABLE_CLIENT_SASL = "zookeeper.sasl.client";
    private static final String ZK_SASL_CLIENT_USERNAME = "zookeeper.sasl.client.username";
    private static final String ZK_LOGIN_CONTEXT_NAME = "zookeeper.sasl.clientconfig";
    private String priorServiceName;
    private String priorLoginContextName;

    @Override
    public void install(SecurityUtils.SecurityConfiguration configuration) throws SecurityModule.SecurityInstallException {
        this.priorServiceName = System.getProperty("zookeeper.sasl.client.username", null);
        if (!"zookeeper".equals(configuration.getZooKeeperServiceName())) {
            System.setProperty("zookeeper.sasl.client.username", configuration.getZooKeeperServiceName());
        }
        this.priorLoginContextName = System.getProperty(ZK_LOGIN_CONTEXT_NAME, null);
        if (!"Client".equals(configuration.getZooKeeperLoginContextName())) {
            System.setProperty(ZK_LOGIN_CONTEXT_NAME, configuration.getZooKeeperLoginContextName());
        }
    }

    @Override
    public void uninstall() throws SecurityModule.SecurityInstallException {
        if (this.priorServiceName != null) {
            System.setProperty("zookeeper.sasl.client.username", this.priorServiceName);
        } else {
            System.clearProperty("zookeeper.sasl.client.username");
        }
        if (this.priorLoginContextName != null) {
            System.setProperty(ZK_LOGIN_CONTEXT_NAME, this.priorLoginContextName);
        } else {
            System.clearProperty(ZK_LOGIN_CONTEXT_NAME);
        }
    }
}

