/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.concurrent.RunnableFuture;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.FutureUtil;

public class StateUtil {
    private StateUtil() {
        throw new AssertionError();
    }

    public static void bestEffortDiscardAllStateObjects(Iterable<? extends StateObject> handlesToDiscard) throws Exception {
        if (handlesToDiscard != null) {
            Throwable suppressedExceptions = null;
            for (StateObject stateObject : handlesToDiscard) {
                if (stateObject == null) continue;
                try {
                    stateObject.discardState();
                }
                catch (Exception ex) {
                    if (suppressedExceptions == null) {
                        suppressedExceptions = new Exception(ex);
                    }
                    suppressedExceptions.addSuppressed(ex);
                }
            }
            if (suppressedExceptions != null) {
                throw suppressedExceptions;
            }
        }
    }

    public static void discardStateFuture(RunnableFuture<? extends StateObject> stateFuture) throws Exception {
        StateObject stateObject;
        if (null != stateFuture && !stateFuture.cancel(true) && null != (stateObject = (StateObject)FutureUtil.runIfNotDoneAndGet(stateFuture))) {
            stateObject.discardState();
        }
    }
}

