/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.state.ChainedStateHandle;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;

public class TaskStateHandles
implements Serializable {
    public static final TaskStateHandles EMPTY = new TaskStateHandles();
    private static final long serialVersionUID = 267686583583579359L;
    @Deprecated
    private final ChainedStateHandle<StreamStateHandle> legacyOperatorState;
    private final Collection<KeyGroupsStateHandle> managedKeyedState;
    private final Collection<KeyGroupsStateHandle> rawKeyedState;
    private final List<Collection<OperatorStateHandle>> managedOperatorState;
    private final List<Collection<OperatorStateHandle>> rawOperatorState;

    public TaskStateHandles() {
        this(null, null, null, null, null);
    }

    public TaskStateHandles(SubtaskState checkpointStateHandles) {
        this(checkpointStateHandles.getLegacyOperatorState(), TaskStateHandles.transform(checkpointStateHandles.getManagedOperatorState()), TaskStateHandles.transform(checkpointStateHandles.getRawOperatorState()), TaskStateHandles.transform(checkpointStateHandles.getManagedKeyedState()), TaskStateHandles.transform(checkpointStateHandles.getRawKeyedState()));
    }

    public TaskStateHandles(ChainedStateHandle<StreamStateHandle> legacyOperatorState, List<Collection<OperatorStateHandle>> managedOperatorState, List<Collection<OperatorStateHandle>> rawOperatorState, Collection<KeyGroupsStateHandle> managedKeyedState, Collection<KeyGroupsStateHandle> rawKeyedState) {
        this.legacyOperatorState = legacyOperatorState;
        this.managedKeyedState = managedKeyedState;
        this.rawKeyedState = rawKeyedState;
        this.managedOperatorState = managedOperatorState;
        this.rawOperatorState = rawOperatorState;
    }

    @Deprecated
    public ChainedStateHandle<StreamStateHandle> getLegacyOperatorState() {
        return this.legacyOperatorState;
    }

    public Collection<KeyGroupsStateHandle> getManagedKeyedState() {
        return this.managedKeyedState;
    }

    public Collection<KeyGroupsStateHandle> getRawKeyedState() {
        return this.rawKeyedState;
    }

    public List<Collection<OperatorStateHandle>> getRawOperatorState() {
        return this.rawOperatorState;
    }

    public List<Collection<OperatorStateHandle>> getManagedOperatorState() {
        return this.managedOperatorState;
    }

    private static List<Collection<OperatorStateHandle>> transform(ChainedStateHandle<OperatorStateHandle> in) {
        if (null == in) {
            return Collections.emptyList();
        }
        ArrayList<Collection<OperatorStateHandle>> out = new ArrayList<Collection<OperatorStateHandle>>(in.getLength());
        for (int i = 0; i < in.getLength(); ++i) {
            OperatorStateHandle osh = in.get(i);
            out.add(osh != null ? Collections.singletonList(osh) : null);
        }
        return out;
    }

    private static List<KeyGroupsStateHandle> transform(KeyGroupsStateHandle in) {
        return in == null ? Collections.emptyList() : Collections.singletonList(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStateHandles that = (TaskStateHandles)o;
        if (this.legacyOperatorState != null ? !this.legacyOperatorState.equals(that.legacyOperatorState) : that.legacyOperatorState != null) {
            return false;
        }
        if (this.managedKeyedState != null ? !this.managedKeyedState.equals(that.managedKeyedState) : that.managedKeyedState != null) {
            return false;
        }
        if (this.rawKeyedState != null ? !this.rawKeyedState.equals(that.rawKeyedState) : that.rawKeyedState != null) {
            return false;
        }
        if (this.rawOperatorState != null ? !this.rawOperatorState.equals(that.rawOperatorState) : that.rawOperatorState != null) {
            return false;
        }
        return this.managedOperatorState != null ? this.managedOperatorState.equals(that.managedOperatorState) : that.managedOperatorState == null;
    }

    public int hashCode() {
        int result = this.legacyOperatorState != null ? this.legacyOperatorState.hashCode() : 0;
        result = 31 * result + (this.managedKeyedState != null ? this.managedKeyedState.hashCode() : 0);
        result = 31 * result + (this.rawKeyedState != null ? this.rawKeyedState.hashCode() : 0);
        result = 31 * result + (this.managedOperatorState != null ? this.managedOperatorState.hashCode() : 0);
        result = 31 * result + (this.rawOperatorState != null ? this.rawOperatorState.hashCode() : 0);
        return result;
    }
}

