/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.query.netty.message.KvStateRequestSerializer;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.util.Preconditions;

public abstract class AbstractHeapState<K, N, SV, S extends State, SD extends StateDescriptor<S, ?>>
implements KvState<N>,
State {
    protected final StateTable<K, N, SV> stateTable;
    protected final SD stateDesc;
    protected N currentNamespace = null;
    protected final KeyedStateBackend<K> backend;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<N> namespaceSerializer;

    protected AbstractHeapState(KeyedStateBackend<K> backend, SD stateDesc, StateTable<K, N, SV> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        Preconditions.checkNotNull(stateTable, (String)"State table must not be null.");
        this.backend = backend;
        this.stateDesc = stateDesc;
        this.stateTable = stateTable;
        this.keySerializer = keySerializer;
        this.namespaceSerializer = namespaceSerializer;
    }

    public final void clear() {
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        Map<N, Map<K, SV>> namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            return;
        }
        Map<K, SV> keyedMap = namespaceMap.get(this.currentNamespace);
        if (keyedMap == null) {
            return;
        }
        SV removed = keyedMap.remove(this.backend.getCurrentKey());
        if (removed == null) {
            return;
        }
        if (!keyedMap.isEmpty()) {
            return;
        }
        namespaceMap.remove(this.currentNamespace);
    }

    @Override
    public final void setCurrentNamespace(N namespace) {
        this.currentNamespace = Preconditions.checkNotNull(namespace, (String)"Namespace must not be null.");
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace) throws Exception {
        Preconditions.checkNotNull((Object)serializedKeyAndNamespace, (String)"Serialized key and namespace");
        Tuple2<K, N> keyAndNamespace = KvStateRequestSerializer.deserializeKeyAndNamespace(serializedKeyAndNamespace, this.keySerializer, this.namespaceSerializer);
        return this.getSerializedValue(keyAndNamespace.f0, keyAndNamespace.f1);
    }

    public byte[] getSerializedValue(K key, N namespace) throws Exception {
        Preconditions.checkState((namespace != null ? 1 : 0) != 0, (Object)"No namespace given.");
        Preconditions.checkState((key != null ? 1 : 0) != 0, (Object)"No key given.");
        Map<N, Map<K, SV>> namespaceMap = this.stateTable.get(KeyGroupRangeAssignment.assignToKeyGroup(key, this.backend.getNumberOfKeyGroups()));
        if (namespaceMap == null) {
            return null;
        }
        Map<K, SV> keyedMap = namespaceMap.get(this.currentNamespace);
        if (keyedMap == null) {
            return null;
        }
        SV result = keyedMap.get(key);
        if (result == null) {
            return null;
        }
        TypeSerializer serializer = this.stateDesc.getSerializer();
        return KvStateRequestSerializer.serializeValue(result, serializer);
    }

    protected <MK, MV> Map<MK, MV> createNewMap() {
        if (this.stateDesc.isQueryable()) {
            return new ConcurrentHashMap();
        }
        return new HashMap();
    }

    public StateTable<K, N, SV> getStateTable() {
        return this.stateTable;
    }
}

