/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.heap.AbstractHeapState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.util.Preconditions;

public class HeapReducingState<K, N, V>
extends AbstractHeapState<K, N, V, ReducingState<V>, ReducingStateDescriptor<V>>
implements ReducingState<V> {
    private final ReduceFunction<V> reduceFunction;

    public HeapReducingState(KeyedStateBackend<K> backend, ReducingStateDescriptor<V> stateDesc, StateTable<K, N, V> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        super(backend, stateDesc, stateTable, keySerializer, namespaceSerializer);
        this.reduceFunction = stateDesc.getReduceFunction();
    }

    public V get() {
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        Map namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            return null;
        }
        Map keyedMap = namespaceMap.get(this.currentNamespace);
        if (keyedMap == null) {
            return null;
        }
        return (V)keyedMap.get(this.backend.getCurrentKey());
    }

    public void add(V value) throws IOException {
        Object currentValue;
        Map<Object, Object> keyedMap;
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        if (value == null) {
            this.clear();
            return;
        }
        Map namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            namespaceMap = this.createNewMap();
            this.stateTable.set(this.backend.getCurrentKeyGroupIndex(), namespaceMap);
        }
        if ((keyedMap = namespaceMap.get(this.currentNamespace)) == null) {
            keyedMap = this.createNewMap();
            namespaceMap.put(this.currentNamespace, keyedMap);
        }
        if ((currentValue = keyedMap.put(this.backend.getCurrentKey(), value)) != null) {
            Object reducedValue = null;
            try {
                reducedValue = this.reduceFunction.reduce(currentValue, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not add value to reducing state.", e);
            }
            keyedMap.put(this.backend.getCurrentKey(), reducedValue);
        }
    }
}

