/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.zookeeper.RetrievableStateStorageHelper;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.flink.shaded.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.flink.shaded.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.flink.shaded.org.apache.curator.framework.api.Pathable;
import org.apache.flink.shaded.org.apache.curator.utils.ZKPaths;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperStateHandleStore<T extends Serializable> {
    public static Logger LOG = LoggerFactory.getLogger(ZooKeeperStateHandleStore.class);
    private final CuratorFramework client;
    private final RetrievableStateStorageHelper<T> storage;
    private final Executor executor;

    public ZooKeeperStateHandleStore(CuratorFramework client, RetrievableStateStorageHelper<T> storage, Executor executor) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (String)"Curator client");
        this.storage = (RetrievableStateStorageHelper)Preconditions.checkNotNull(storage, (String)"State storage");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public RetrievableStateHandle<T> add(String pathInZooKeeper, T state) throws Exception {
        return this.add(pathInZooKeeper, state, CreateMode.PERSISTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrievableStateHandle<T> add(String pathInZooKeeper, T state, CreateMode createMode) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        Preconditions.checkNotNull(state, (String)"State");
        RetrievableStateHandle<T> storeHandle = this.storage.store(state);
        boolean success = false;
        try {
            byte[] serializedStoreHandle = InstantiationUtil.serializeObject(storeHandle);
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(createMode)).forPath(pathInZooKeeper, serializedStoreHandle);
            success = true;
            RetrievableStateHandle<T> retrievableStateHandle = storeHandle;
            return retrievableStateHandle;
        }
        finally {
            if (!success && storeHandle != null) {
                storeHandle.discardState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String pathInZooKeeper, int expectedVersion, T state) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        Preconditions.checkNotNull(state, (String)"State");
        RetrievableStateHandle<T> oldStateHandle = this.get(pathInZooKeeper);
        RetrievableStateHandle<T> newStateHandle = this.storage.store(state);
        boolean success = false;
        try {
            byte[] serializedStateHandle = InstantiationUtil.serializeObject(newStateHandle);
            ((BackgroundPathAndBytesable)this.client.setData().withVersion(expectedVersion)).forPath(pathInZooKeeper, serializedStateHandle);
            success = true;
        }
        finally {
            if (success) {
                oldStateHandle.discardState();
            } else {
                newStateHandle.discardState();
            }
        }
    }

    public int exists(String pathInZooKeeper) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        Stat stat = (Stat)this.client.checkExists().forPath(pathInZooKeeper);
        if (stat != null) {
            return stat.getVersion();
        }
        return -1;
    }

    public RetrievableStateHandle<T> get(String pathInZooKeeper) throws Exception {
        byte[] data;
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        try {
            data = (byte[])this.client.getData().forPath(pathInZooKeeper);
        }
        catch (Exception e) {
            throw new Exception("Failed to retrieve state handle data under " + pathInZooKeeper + " from ZooKeeper.", e);
        }
        try {
            return (RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])data, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IOException("Failed to deserialize state handle from ZooKeeper data from " + pathInZooKeeper + '.', e);
        }
    }

    public Collection<String> getAllPaths() throws Exception {
        String path = "/";
        Stat stat;
        while ((stat = (Stat)this.client.checkExists().forPath("/")) != null) {
            try {
                return (Collection)this.client.getChildren().forPath("/");
            }
            catch (KeeperException.NoNodeException noNodeException) {
                continue;
            }
            break;
        }
        return Collections.emptyList();
    }

    public List<Tuple2<RetrievableStateHandle<T>, String>> getAll() throws Exception {
        ArrayList<Tuple2<RetrievableStateHandle<T>, String>> stateHandles = new ArrayList<Tuple2<RetrievableStateHandle<T>, String>>();
        boolean success = false;
        block3: while (!success) {
            stateHandles.clear();
            Stat stat = (Stat)this.client.checkExists().forPath("/");
            if (stat == null) break;
            int initialCVersion = stat.getCversion();
            List children = (List)this.client.getChildren().forPath("/");
            for (String path : children) {
                path = "/" + path;
                try {
                    RetrievableStateHandle<T> stateHandle = this.get(path);
                    stateHandles.add(new Tuple2(stateHandle, (Object)path));
                }
                catch (KeeperException.NoNodeException ignored) {
                    continue block3;
                }
                catch (IOException ioException) {
                    LOG.warn("Could not get all ZooKeeper children. Node {} contained corrupted data. Ignoring this node.", (Object)path, (Object)ioException);
                }
            }
            int finalCVersion = ((Stat)this.client.checkExists().forPath("/")).getCversion();
            success = initialCVersion == finalCVersion;
        }
        return stateHandles;
    }

    public List<Tuple2<RetrievableStateHandle<T>, String>> getAllSortedByName() throws Exception {
        ArrayList<Tuple2<RetrievableStateHandle<T>, String>> stateHandles = new ArrayList<Tuple2<RetrievableStateHandle<T>, String>>();
        boolean success = false;
        block3: while (!success) {
            stateHandles.clear();
            Stat stat = (Stat)this.client.checkExists().forPath("/");
            if (stat == null) break;
            int initialCVersion = stat.getCversion();
            List<String> children = ZKPaths.getSortedChildren(this.client.getZookeeperClient().getZooKeeper(), ZKPaths.fixForNamespace(this.client.getNamespace(), "/"));
            for (String path : children) {
                path = "/" + path;
                try {
                    RetrievableStateHandle<T> stateHandle = this.get(path);
                    stateHandles.add(new Tuple2(stateHandle, (Object)path));
                }
                catch (KeeperException.NoNodeException ignored) {
                    continue block3;
                }
                catch (IOException ioException) {
                    LOG.warn("Could not get all ZooKeeper children. Node {} contained corrupted data. Ignoring this node.", (Object)path, (Object)ioException);
                }
            }
            int finalCVersion = ((Stat)this.client.checkExists().forPath("/")).getCversion();
            success = initialCVersion == finalCVersion;
        }
        return stateHandles;
    }

    public void remove(String pathInZooKeeper) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        this.client.delete().deletingChildrenIfNeeded().forPath(pathInZooKeeper);
    }

    public void remove(String pathInZooKeeper, BackgroundCallback callback) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        Preconditions.checkNotNull((Object)callback, (String)"Background callback");
        ((Pathable)this.client.delete().deletingChildrenIfNeeded().inBackground(callback, this.executor)).forPath(pathInZooKeeper);
    }

    public void removeAndDiscardState(String pathInZooKeeper) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        RetrievableStateHandle<T> stateHandle = this.get(pathInZooKeeper);
        this.client.delete().deletingChildrenIfNeeded().forPath(pathInZooKeeper);
        stateHandle.discardState();
    }

    public void removeAndDiscardAllState() throws Exception {
        List<Tuple2<RetrievableStateHandle<T>, String>> allStateHandles = this.getAll();
        ZKPaths.deleteChildren(this.client.getZookeeperClient().getZooKeeper(), ZKPaths.fixForNamespace(this.client.getNamespace(), "/"), false);
        for (Tuple2<RetrievableStateHandle<T>, String> stateHandleAndPath : allStateHandles) {
            ((RetrievableStateHandle)stateHandleAndPath.f0).discardState();
        }
    }
}

