/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.util.Collection;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.util.Preconditions;

public class SavepointV0
implements Savepoint {
    public static final int VERSION = 0;
    private final long checkpointId;
    private final Collection<TaskState> taskStates;

    SavepointV0(long checkpointId, Collection<TaskState> taskStates) {
        this.checkpointId = checkpointId;
        this.taskStates = (Collection)Preconditions.checkNotNull(taskStates, (String)"Task States");
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Override
    public Collection<TaskState> getTaskStates() {
        return this.taskStates;
    }

    @Override
    public void dispose(ClassLoader classLoader) throws Exception {
        Preconditions.checkNotNull((Object)classLoader, (String)"Class loader");
        for (TaskState taskState : this.taskStates) {
            taskState.discard(classLoader);
        }
        this.taskStates.clear();
    }

    public String toString() {
        return "Savepoint(version=0)";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavepointV0 that = (SavepointV0)o;
        return this.checkpointId == that.checkpointId && this.getTaskStates().equals(that.getTaskStates());
    }

    public int hashCode() {
        int result = (int)(this.checkpointId ^ this.checkpointId >>> 32);
        result = 31 * result + this.taskStates.hashCode();
        return result;
    }
}

