/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.metrics.groups.IOMetricGroup;
import org.apache.flink.util.Preconditions;
import scala.Tuple2;

public class UnknownInputChannel
extends InputChannel {
    private final ResultPartitionManager partitionManager;
    private final TaskEventDispatcher taskEventDispatcher;
    private final ConnectionManager connectionManager;
    private final Tuple2<Integer, Integer> partitionRequestInitialAndMaxBackoff;
    private final IOMetricGroup metrics;

    public UnknownInputChannel(SingleInputGate gate, int channelIndex, ResultPartitionID partitionId, ResultPartitionManager partitionManager, TaskEventDispatcher taskEventDispatcher, ConnectionManager connectionManager, Tuple2<Integer, Integer> partitionRequestInitialAndMaxBackoff, IOMetricGroup metrics) {
        super(gate, channelIndex, partitionId, partitionRequestInitialAndMaxBackoff, null);
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.taskEventDispatcher = (TaskEventDispatcher)Preconditions.checkNotNull((Object)taskEventDispatcher);
        this.connectionManager = (ConnectionManager)Preconditions.checkNotNull((Object)connectionManager);
        this.partitionRequestInitialAndMaxBackoff = (Tuple2)Preconditions.checkNotNull(partitionRequestInitialAndMaxBackoff);
        this.metrics = (IOMetricGroup)Preconditions.checkNotNull((Object)metrics);
    }

    @Override
    public void requestSubpartition(int subpartitionIndex) throws IOException {
    }

    @Override
    public Buffer getNextBuffer() throws IOException {
        return null;
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
    }

    @Override
    public boolean isReleased() {
        return false;
    }

    @Override
    public void notifySubpartitionConsumed() {
    }

    @Override
    public void releaseAllResources() throws IOException {
    }

    public String toString() {
        return "UnknownInputChannel [" + this.partitionId + "]";
    }

    public RemoteInputChannel toRemoteInputChannel(ConnectionID producerAddress) {
        return new RemoteInputChannel(this.inputGate, this.channelIndex, this.partitionId, (ConnectionID)Preconditions.checkNotNull((Object)producerAddress), this.connectionManager, this.partitionRequestInitialAndMaxBackoff, this.metrics);
    }

    public LocalInputChannel toLocalInputChannel() {
        return new LocalInputChannel(this.inputGate, this.channelIndex, this.partitionId, this.partitionManager, this.taskEventDispatcher, this.partitionRequestInitialAndMaxBackoff, this.metrics);
    }
}

