/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testingUtils;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout$;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.messages.ExecutionGraphMessages;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.Messages;
import org.apache.flink.runtime.messages.Messages$Acknowledge$;
import org.apache.flink.runtime.messages.RegistrationMessages;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.testingUtils.TestingJobManagerLike;
import org.apache.flink.runtime.testingUtils.TestingJobManagerLike$;
import org.apache.flink.runtime.testingUtils.TestingJobManagerLike$$anonfun$handleTestingMessage$1$;
import org.apache.flink.runtime.testingUtils.TestingJobManagerMessages;
import org.apache.flink.runtime.testingUtils.TestingJobManagerMessages$DisablePostStop$;
import org.apache.flink.runtime.testingUtils.TestingJobManagerMessages$NotifyListeners$;
import org.apache.flink.runtime.testingUtils.TestingJobManagerMessages$NotifyWhenLeader$;
import org.apache.flink.runtime.testingUtils.TestingMessages;
import org.apache.flink.runtime.testingUtils.TestingMessages$Alive$;
import org.apache.flink.runtime.testingUtils.TestingMessages$DisableDisconnect$;
import org.apache.flink.runtime.testingUtils.TestingMessages$NotifyOfComponentShutdown$;
import org.apache.flink.runtime.testingUtils.TestingTaskManagerMessages;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.PriorityQueue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class TestingJobManagerLike$class {
    public static void postStop(JobManager $this) {
        if (((TestingJobManagerLike)((Object)$this)).postStopEnabled()) {
            ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$super$postStop();
        } else {
            $this.leaderElectionService().stop();
        }
    }

    public static PartialFunction handleMessage(JobManager $this) {
        return ((TestingJobManagerLike)((Object)$this)).handleTestingMessage().orElse(((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$super$handleMessage());
    }

    public static PartialFunction handleTestingMessage(JobManager $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                TestingTaskManagerMessages.AccumulatorsChanged accumulatorsChanged;
                JobID jobID;
                void var4_29;
                A1 A1 = x1;
                if (TestingMessages$Alive$.MODULE$.equals(A1)) {
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)Messages$Acknowledge$.MODULE$, this.$outer.self());
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.RequestExecutionGraph) {
                    Some some;
                    Tuple2 tuple2;
                    TestingJobManagerMessages.RequestExecutionGraph requestExecutionGraph = (TestingJobManagerMessages.RequestExecutionGraph)A1;
                    JobID jobID2 = requestExecutionGraph.jobID();
                    Option option = this.$outer.currentJobs().get((Object)jobID2);
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                        ExecutionGraph executionGraph = (ExecutionGraph)tuple2._1();
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.ExecutionGraphFound(jobID2, executionGraph)), this.$outer.self());
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        this.$outer.archive().tell(this.$outer.decorateMessage(new TestingJobManagerMessages.RequestExecutionGraph(jobID2)), this.$outer.sender());
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.WaitForAllVerticesToBeRunning) {
                    BoxedUnit boxedUnit2;
                    TestingJobManagerMessages.WaitForAllVerticesToBeRunning waitForAllVerticesToBeRunning = (TestingJobManagerMessages.WaitForAllVerticesToBeRunning)A1;
                    JobID jobID3 = waitForAllVerticesToBeRunning.jobID();
                    if (((TestingJobManagerLike)((Object)this.$outer)).checkIfAllVerticesRunning(jobID3)) {
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.AllVerticesRunning(jobID3)), this.$outer.self());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        Set waiting = (Set)((TestingJobManagerLike)((Object)this.$outer)).waitForAllVerticesToBeRunning().getOrElse((Object)jobID3, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<ActorRef> apply() {
                                return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                            }
                        });
                        ((TestingJobManagerLike)((Object)this.$outer)).waitForAllVerticesToBeRunning().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jobID3), (Object)waiting.$plus((Object)this.$outer.sender())));
                        if (((TestingJobManagerLike)((Object)this.$outer)).periodicCheck().isEmpty()) {
                            ((TestingJobManagerLike)((Object)this.$outer)).periodicCheck_$eq((Option<Cancellable>)new Some((Object)this.$outer.context().system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(200)).millis(), this.$outer.self(), this.$outer.decorateMessage(TestingJobManagerMessages$NotifyListeners$.MODULE$), (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self())));
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit7 = boxedUnit2;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.WaitForAllVerticesToBeRunningOrFinished) {
                    BoxedUnit boxedUnit3;
                    TestingJobManagerMessages.WaitForAllVerticesToBeRunningOrFinished waitForAllVerticesToBeRunningOrFinished = (TestingJobManagerMessages.WaitForAllVerticesToBeRunningOrFinished)A1;
                    JobID jobID4 = waitForAllVerticesToBeRunningOrFinished.jobID();
                    if (((TestingJobManagerLike)((Object)this.$outer)).checkIfAllVerticesRunningOrFinished(jobID4)) {
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.AllVerticesRunning(jobID4)), this.$outer.self());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        Set waiting = (Set)((TestingJobManagerLike)((Object)this.$outer)).waitForAllVerticesToBeRunningOrFinished().getOrElse((Object)jobID4, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<ActorRef> apply() {
                                return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                            }
                        });
                        ((TestingJobManagerLike)((Object)this.$outer)).waitForAllVerticesToBeRunningOrFinished().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jobID4), (Object)waiting.$plus((Object)this.$outer.sender())));
                        if (((TestingJobManagerLike)((Object)this.$outer)).periodicCheck().isEmpty()) {
                            ((TestingJobManagerLike)((Object)this.$outer)).periodicCheck_$eq((Option<Cancellable>)new Some((Object)this.$outer.context().system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(200)).millis(), this.$outer.self(), this.$outer.decorateMessage(TestingJobManagerMessages$NotifyListeners$.MODULE$), (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self())));
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit9 = boxedUnit3;
                    return var4_29;
                }
                if (TestingJobManagerMessages$NotifyListeners$.MODULE$.equals(A1)) {
                    BoxedUnit boxedUnit4;
                    this.$outer.currentJobs().keySet().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 $outer;

                        public final void apply(JobID jobID) {
                            ((TestingJobManagerLike)((Object)this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer())).notifyListeners(jobID);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (((TestingJobManagerLike)((Object)this.$outer)).waitForAllVerticesToBeRunning().isEmpty() && ((TestingJobManagerLike)((Object)this.$outer)).waitForAllVerticesToBeRunningOrFinished().isEmpty()) {
                        ((TestingJobManagerLike)((Object)this.$outer)).periodicCheck().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Cancellable x$1) {
                                return x$1.cancel();
                            }
                        });
                        ((TestingJobManagerLike)((Object)this.$outer)).periodicCheck_$eq((Option<Cancellable>)None$.MODULE$);
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit11 = boxedUnit4;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.NotifyWhenJobRemoved) {
                    TestingJobManagerMessages.NotifyWhenJobRemoved notifyWhenJobRemoved = (TestingJobManagerMessages.NotifyWhenJobRemoved)A1;
                    JobID jobID5 = notifyWhenJobRemoved.jobID();
                    Iterable gateways = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.instanceManager().getAllRegisteredInstances()).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ActorGateway apply(Instance x$2) {
                            return x$2.getActorGateway();
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                    Iterable responses = (Iterable)gateways.map((Function1)new Serializable(this, jobID5){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 $outer;
                        private final JobID jobID$1;

                        public final Future<Object> apply(ActorGateway gateway) {
                            return gateway.ask(new TestingJobManagerMessages.NotifyWhenJobRemoved(this.jobID$1), this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().timeout()).mapTo(ClassTag$.MODULE$.Boolean());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.jobID$1 = jobID$1;
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                    Future jobRemovedOnJobManager = AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(this.$outer.self()), (Object)new TestingMessages.CheckIfJobRemoved(jobID5), Timeout$.MODULE$.durationToTimeout(this.$outer.timeout())).mapTo(ClassTag$.MODULE$.Boolean());
                    Iterable allFutures = (Iterable)responses.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Future[]{jobRemovedOnJobManager})), Iterable$.MODULE$.canBuildFrom());
                    akka.pattern.package$.MODULE$.pipe(Future$.MODULE$.fold((TraversableOnce)allFutures, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(boolean x$3, boolean x$4) {
                            return x$3 & x$4;
                        }
                    }, (ExecutionContext)this.$outer.context().dispatcher()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 $outer;

                        public final Object apply(boolean x$5) {
                            return this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().decorateMessage(BoxesRunTime.boxToBoolean((boolean)x$5));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (ExecutionContext)this.$outer.context().dispatcher()), (ExecutionContext)this.$outer.context().dispatcher()).pipeTo(this.$outer.sender(), this.$outer.self());
                    BoxedUnit boxedUnit12 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TestingMessages.CheckIfJobRemoved) {
                    BoxedUnit boxedUnit5;
                    TestingMessages.CheckIfJobRemoved checkIfJobRemoved = (TestingMessages.CheckIfJobRemoved)A1;
                    JobID jobID6 = checkIfJobRemoved.jobID();
                    if (this.$outer.currentJobs().contains((Object)jobID6)) {
                        this.$outer.context().system().scheduler().scheduleOnce(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(200)).milliseconds(), this.$outer.self(), this.$outer.decorateMessage(new TestingMessages.CheckIfJobRemoved(jobID6)), (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.sender());
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.decorateMessage(BoxesRunTime.boxToBoolean((boolean)true)), this.$outer.self());
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit14 = boxedUnit5;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.NotifyWhenTaskManagerTerminated) {
                    TestingJobManagerMessages.NotifyWhenTaskManagerTerminated notifyWhenTaskManagerTerminated = (TestingJobManagerMessages.NotifyWhenTaskManagerTerminated)A1;
                    ActorRef taskManager = notifyWhenTaskManagerTerminated.taskManager();
                    Set waiting = (Set)((TestingJobManagerLike)((Object)this.$outer)).waitForTaskManagerToBeTerminated().getOrElse((Object)taskManager.path().name(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Set<ActorRef> apply() {
                            return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                        }
                    });
                    ((TestingJobManagerLike)((Object)this.$outer)).waitForTaskManagerToBeTerminated().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)taskManager.path().name()), (Object)waiting.$plus((Object)this.$outer.sender())));
                    BoxedUnit boxedUnit15 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof Terminated) {
                    Terminated terminated = (Terminated)A1;
                    ActorRef taskManager = terminated.actor();
                    ((TestingJobManagerLike)((Object)this.$outer)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$super$handleMessage().apply((Object)terminated);
                    ((TestingJobManagerLike)((Object)this.$outer)).waitForTaskManagerToBeTerminated().remove((Object)taskManager.path().name()).foreach((Function1)new Serializable(this, taskManager){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 $outer;
                        public final ActorRef taskManager$1;

                        public final void apply(Set<ActorRef> x$6) {
                            x$6.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TestingJobManagerLike$$anonfun$handleTestingMessage$1$.anonfun.applyOrElse.5 $outer;

                                public final void apply(ActorRef listener) {
                                    package$.MODULE$.actorRef2Scala(listener).$bang(this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$anonfun$$$outer().org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().decorateMessage(new TestingJobManagerMessages.TaskManagerTerminated(this.$outer.taskManager$1)), this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$anonfun$$$outer().org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().self());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.taskManager$1 = taskManager$1;
                        }
                    });
                    BoxedUnit boxedUnit16 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (TestingMessages$NotifyOfComponentShutdown$.MODULE$.equals(A1)) {
                    ((TestingJobManagerLike)((Object)this.$outer)).waitForShutdown().$plus$eq((Object)this.$outer.sender());
                    BoxedUnit boxedUnit17 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.NotifyWhenAccumulatorChange) {
                    Tuple2 tuple2;
                    TestingJobManagerMessages.NotifyWhenAccumulatorChange notifyWhenAccumulatorChange = (TestingJobManagerMessages.NotifyWhenAccumulatorChange)A1;
                    JobID jobID7 = notifyWhenAccumulatorChange.jobID();
                    Tuple2 tuple22 = (Tuple2)((TestingJobManagerLike)((Object)this.$outer)).waitForAccumulatorUpdate().getOrElse((Object)jobID7, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Set<ActorRef>> apply() {
                            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                        }
                    });
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    boolean updated = tuple22._1$mcZ$sp();
                    Set registered = (Set)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)updated), (Object)registered);
                    boolean updated2 = tuple23._1$mcZ$sp();
                    Set registered2 = (Set)tuple23._2();
                    ((TestingJobManagerLike)((Object)this.$outer)).waitForAccumulatorUpdate().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jobID7), (Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)updated2), (Object)registered2.$plus((Object)this.$outer.sender()))));
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                    BoxedUnit boxedUnit18 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TestingTaskManagerMessages.AccumulatorsChanged && (jobID = (accumulatorsChanged = (TestingTaskManagerMessages.AccumulatorsChanged)A1).jobID()) != null) {
                    Some some;
                    Tuple2 tuple2;
                    JobID jobID8 = jobID;
                    Option option = ((TestingJobManagerLike)((Object)this.$outer)).waitForAccumulatorUpdate().get((Object)jobID8);
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                        Set registered = (Set)tuple2._2();
                        ((TestingJobManagerLike)((Object)this.$outer)).waitForAccumulatorUpdate().put((Object)jobID8, (Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)registered));
                        BoxedUnit boxedUnit19 = BoxedUnit.UNIT;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        BoxedUnit boxedUnit20 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit21 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TaskManagerMessages.Heartbeat) {
                    TaskManagerMessages.Heartbeat heartbeat = (TaskManagerMessages.Heartbeat)A1;
                    ((TestingJobManagerLike)((Object)this.$outer)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$super$handleMessage().apply((Object)heartbeat);
                    ((TestingJobManagerLike)((Object)this.$outer)).waitForAccumulatorUpdate().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 $outer;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object apply(Tuple2<JobID, Tuple2<Object, Set<ActorRef>>> x0$1) {
                            Some some;
                            Tuple2 tuple2;
                            Tuple2<JobID, Tuple2<Object, Set<ActorRef>>> tuple22 = x0$1;
                            if (tuple22 == null) return BoxedUnit.UNIT;
                            JobID jobID = (JobID)tuple22._1();
                            Tuple2 tuple23 = (Tuple2)tuple22._2();
                            if (tuple23 == null) return BoxedUnit.UNIT;
                            boolean updated = tuple23._1$mcZ$sp();
                            Set actors = (Set)tuple23._2();
                            if (!updated) return BoxedUnit.UNIT;
                            Option option = this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().currentJobs().get((Object)jobID);
                            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                                ExecutionGraph graph = (ExecutionGraph)tuple2._1();
                                Map<ExecutionAttemptID, Map<AccumulatorRegistry.Metric, Accumulator<?, ?>>> flinkAccumulators = graph.getFlinkAccumulators();
                                Map<String, Accumulator<?, ?>> userAccumulators = graph.aggregateUserAccumulators();
                                actors.foreach((Function1)new Serializable(this, jobID, flinkAccumulators, userAccumulators){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ TestingJobManagerLike$$anonfun$handleTestingMessage$1$.anonfun.applyOrElse.6 $outer;
                                    private final JobID jobID$2;
                                    private final Map flinkAccumulators$1;
                                    private final Map userAccumulators$1;

                                    public final void apply(ActorRef actor) {
                                        package$.MODULE$.actorRef2Scala(actor).$bang((Object)new TestingJobManagerMessages.UpdatedAccumulators(this.jobID$2, this.flinkAccumulators$1, this.userAccumulators$1), this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$anonfun$$$outer().org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().self());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.jobID$2 = jobID$2;
                                        this.flinkAccumulators$1 = flinkAccumulators$1;
                                        this.userAccumulators$1 = userAccumulators$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return ((TestingJobManagerLike)((Object)this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer())).waitForAccumulatorUpdate().put((Object)jobID, (Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)actors));
                            } else {
                                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return ((TestingJobManagerLike)((Object)this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer())).waitForAccumulatorUpdate().put((Object)jobID, (Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)actors));
                        }

                        public /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit22 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.RequestWorkingTaskManager) {
                    Some some;
                    Tuple2 tuple2;
                    TestingJobManagerMessages.RequestWorkingTaskManager requestWorkingTaskManager = (TestingJobManagerMessages.RequestWorkingTaskManager)A1;
                    JobID jobID9 = requestWorkingTaskManager.jobID();
                    Option option = this.$outer.currentJobs().get((Object)jobID9);
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                        BoxedUnit boxedUnit6;
                        ExecutionGraph eg = (ExecutionGraph)tuple2._1();
                        if (((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(eg.getAllExecutionVertices()).asScala()).isEmpty()) {
                            package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.WorkingTaskManager((Option<ActorGateway>)None$.MODULE$)), this.$outer.self());
                            boxedUnit6 = BoxedUnit.UNIT;
                        } else {
                            SimpleSlot resource = ((ExecutionVertex)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(eg.getAllExecutionVertices()).asScala()).head()).getCurrentAssignedResource();
                            if (resource == null) {
                                package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.WorkingTaskManager((Option<ActorGateway>)None$.MODULE$)), this.$outer.self());
                                boxedUnit6 = BoxedUnit.UNIT;
                            } else {
                                package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.WorkingTaskManager((Option<ActorGateway>)new Some((Object)resource.getInstance().getActorGateway()))), this.$outer.self());
                                boxedUnit6 = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit24 = boxedUnit6;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.WorkingTaskManager((Option<ActorGateway>)None$.MODULE$)), this.$outer.self());
                        BoxedUnit boxedUnit25 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit26 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.NotifyWhenJobStatus) {
                    TestingJobManagerMessages.NotifyWhenJobStatus notifyWhenJobStatus = (TestingJobManagerMessages.NotifyWhenJobStatus)A1;
                    JobID jobID10 = notifyWhenJobStatus.jobID();
                    JobStatus state = notifyWhenJobStatus.state();
                    HashMap jobStatusListener = (HashMap)((TestingJobManagerLike)((Object)this.$outer)).waitForJobStatus().getOrElseUpdate((Object)jobID10, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final HashMap<JobStatus, Set<ActorRef>> apply() {
                            return (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                        }
                    });
                    Set listener = (Set)jobStatusListener.getOrElse((Object)((Object)state), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Set<ActorRef> apply() {
                            return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                        }
                    });
                    jobStatusListener.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)state)), (Object)listener.$plus((Object)this.$outer.sender())));
                    BoxedUnit boxedUnit27 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof ExecutionGraphMessages.JobStatusChanged) {
                    BoxedUnit boxedUnit7;
                    boolean bl;
                    ExecutionGraphMessages.JobStatusChanged jobStatusChanged = (ExecutionGraphMessages.JobStatusChanged)A1;
                    JobID jobID11 = jobStatusChanged.jobID();
                    JobStatus newJobStatus = jobStatusChanged.newJobStatus();
                    ((TestingJobManagerLike)((Object)this.$outer)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$super$handleMessage().apply((Object)jobStatusChanged);
                    Option option = ((TestingJobManagerLike)((Object)this.$outer)).waitForJobStatus().get((Object)jobID11);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        HashMap stateListener = (HashMap)some.x();
                        Option option2 = stateListener.remove((Object)((Object)newJobStatus));
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            Set listeners = (Set)some2.x();
                            listeners.foreach((Function1)new Serializable(this, jobID11, newJobStatus){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 $outer;
                                private final JobID jobID$3;
                                private final JobStatus newJobStatus$1;

                                public final void apply(ActorRef x$8) {
                                    package$.MODULE$.actorRef2Scala(x$8).$bang(this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().decorateMessage(new TestingJobManagerMessages.JobStatusIs(this.jobID$3, this.newJobStatus$1)), this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().self());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.jobID$3 = jobID$3;
                                    this.newJobStatus$1 = newJobStatus$1;
                                }
                            });
                            BoxedUnit boxedUnit29 = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit30 = BoxedUnit.UNIT;
                        }
                        bl = stateListener.isEmpty();
                    } else {
                        bl = false;
                    }
                    boolean cleanup = bl;
                    if (cleanup) {
                        ((TestingJobManagerLike)((Object)this.$outer)).waitForJobStatus().remove((Object)jobID11);
                        boxedUnit7 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit7 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit31 = boxedUnit7;
                    return var4_29;
                }
                if (TestingMessages$DisableDisconnect$.MODULE$.equals(A1)) {
                    ((TestingJobManagerLike)((Object)this.$outer)).disconnectDisabled_$eq(true);
                    BoxedUnit boxedUnit32 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (TestingJobManagerMessages$DisablePostStop$.MODULE$.equals(A1)) {
                    ((TestingJobManagerLike)((Object)this.$outer)).postStopEnabled_$eq(false);
                    BoxedUnit boxedUnit33 = BoxedUnit.UNIT;
                    return var4_29;
                }
                if (A1 instanceof TestingJobManagerMessages.RequestSavepoint) {
                    TestingJobManagerMessages.RequestSavepoint requestSavepoint = (TestingJobManagerMessages.RequestSavepoint)A1;
                    String savepointPath = requestSavepoint.savepointPath();
                    try {
                        Savepoint savepoint = this.$outer.savepointStore().loadSavepoint(savepointPath);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)new TestingJobManagerMessages.ResponseSavepoint(savepoint), this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Exception exception) {
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)new TestingJobManagerMessages.ResponseSavepoint(null), this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    if (A1 instanceof Messages.Disconnect) {
                        BoxedUnit boxedUnit8;
                        Messages.Disconnect disconnect = (Messages.Disconnect)A1;
                        if (((TestingJobManagerLike)((Object)this.$outer)).disconnectDisabled()) {
                            boxedUnit8 = BoxedUnit.UNIT;
                        } else {
                            ((TestingJobManagerLike)((Object)this.$outer)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$super$handleMessage().apply((Object)disconnect);
                            ActorRef taskManager = this.$outer.sender();
                            ((TestingJobManagerLike)((Object)this.$outer)).waitForTaskManagerToBeTerminated().remove((Object)taskManager.path().name()).foreach((Function1)new Serializable(this, taskManager){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 $outer;
                                public final ActorRef taskManager$2;

                                public final void apply(Set<ActorRef> x$9) {
                                    x$9.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ TestingJobManagerLike$$anonfun$handleTestingMessage$1$.anonfun.applyOrElse.7 $outer;

                                        public final void apply(ActorRef listener) {
                                            package$.MODULE$.actorRef2Scala(listener).$bang(this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$anonfun$$$outer().org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().decorateMessage(new TestingJobManagerMessages.TaskManagerTerminated(this.$outer.taskManager$2)), this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$anonfun$$$outer().org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().self());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.taskManager$2 = taskManager$2;
                                }
                            });
                            boxedUnit8 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit35 = boxedUnit8;
                        return var4_29;
                    }
                    if (TestingJobManagerMessages$NotifyWhenLeader$.MODULE$.equals(A1)) {
                        BoxedUnit boxedUnit9;
                        if (this.$outer.leaderElectionService().hasLeadership()) {
                            package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                            boxedUnit9 = BoxedUnit.UNIT;
                        } else {
                            ((TestingJobManagerLike)((Object)this.$outer)).waitForLeader().$plus$eq((Object)this.$outer.sender());
                            boxedUnit9 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit37 = boxedUnit9;
                        return var4_29;
                    }
                    if (A1 instanceof JobManagerMessages.GrantLeadership) {
                        JobManagerMessages.GrantLeadership grantLeadership = (JobManagerMessages.GrantLeadership)A1;
                        ((TestingJobManagerLike)((Object)this.$outer)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$super$handleMessage().apply((Object)grantLeadership);
                        ((TestingJobManagerLike)((Object)this.$outer)).waitForLeader().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ TestingJobManagerLike$.anonfun.handleTestingMessage.1 $outer;

                            public final void apply(ActorRef x$10) {
                                package$.MODULE$.actorRef2Scala(x$10).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer().self());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        ((TestingJobManagerLike)((Object)this.$outer)).waitForLeader().clear();
                        BoxedUnit boxedUnit38 = BoxedUnit.UNIT;
                        return var4_29;
                    }
                    if (A1 instanceof TestingJobManagerMessages.NotifyWhenAtLeastNumTaskManagerAreRegistered) {
                        BoxedUnit boxedUnit10;
                        TestingJobManagerMessages.NotifyWhenAtLeastNumTaskManagerAreRegistered notifyWhenAtLeastNumTaskManagerAreRegistered = (TestingJobManagerMessages.NotifyWhenAtLeastNumTaskManagerAreRegistered)A1;
                        int numRegisteredTaskManager = notifyWhenAtLeastNumTaskManagerAreRegistered.numRegisteredTaskManager();
                        if (this.$outer.instanceManager().getNumberOfRegisteredTaskManagers() >= numRegisteredTaskManager) {
                            package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)Messages$Acknowledge$.MODULE$, this.$outer.self());
                            boxedUnit10 = BoxedUnit.UNIT;
                        } else {
                            ((TestingJobManagerLike)((Object)this.$outer)).waitForNumRegisteredTaskManagers().$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)numRegisteredTaskManager), (Object)this.$outer.sender()));
                            boxedUnit10 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit40 = boxedUnit10;
                        return var4_29;
                    }
                    if (!(A1 instanceof RegistrationMessages.RegisterTaskManager)) {
                        Object object = function1.apply(x1);
                        return var4_29;
                    }
                    RegistrationMessages.RegisterTaskManager registerTaskManager = (RegistrationMessages.RegisterTaskManager)A1;
                    ((TestingJobManagerLike)((Object)this.$outer)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$super$handleMessage().apply((Object)registerTaskManager);
                    while (((TestingJobManagerLike)((Object)this.$outer)).waitForNumRegisteredTaskManagers().nonEmpty() && ((Tuple2)((TestingJobManagerLike)((Object)this.$outer)).waitForNumRegisteredTaskManagers().head())._1$mcI$sp() <= this.$outer.instanceManager().getNumberOfRegisteredTaskManagers()) {
                        ActorRef receiver = (ActorRef)((Tuple2)((TestingJobManagerLike)((Object)this.$outer)).waitForNumRegisteredTaskManagers().dequeue())._2();
                        package$.MODULE$.actorRef2Scala(receiver).$bang((Object)Messages$Acknowledge$.MODULE$, this.$outer.self());
                    }
                    BoxedUnit boxedUnit41 = BoxedUnit.UNIT;
                    return var4_29;
                }
                BoxedUnit boxedUnit42 = boxedUnit;
                return var4_29;
            }

            public final boolean isDefinedAt(Object x1) {
                TestingTaskManagerMessages.AccumulatorsChanged accumulatorsChanged;
                JobID jobID;
                Object object = x1;
                boolean bl = TestingMessages$Alive$.MODULE$.equals(object) ? true : (object instanceof TestingJobManagerMessages.RequestExecutionGraph ? true : (object instanceof TestingJobManagerMessages.WaitForAllVerticesToBeRunning ? true : (object instanceof TestingJobManagerMessages.WaitForAllVerticesToBeRunningOrFinished ? true : (TestingJobManagerMessages$NotifyListeners$.MODULE$.equals(object) ? true : (object instanceof TestingJobManagerMessages.NotifyWhenJobRemoved ? true : (object instanceof TestingMessages.CheckIfJobRemoved ? true : (object instanceof TestingJobManagerMessages.NotifyWhenTaskManagerTerminated ? true : (object instanceof Terminated ? true : (TestingMessages$NotifyOfComponentShutdown$.MODULE$.equals(object) ? true : (object instanceof TestingJobManagerMessages.NotifyWhenAccumulatorChange ? true : (object instanceof TestingTaskManagerMessages.AccumulatorsChanged && (jobID = (accumulatorsChanged = (TestingTaskManagerMessages.AccumulatorsChanged)object).jobID()) != null ? true : (object instanceof TaskManagerMessages.Heartbeat ? true : (object instanceof TestingJobManagerMessages.RequestWorkingTaskManager ? true : (object instanceof TestingJobManagerMessages.NotifyWhenJobStatus ? true : (object instanceof ExecutionGraphMessages.JobStatusChanged ? true : (TestingMessages$DisableDisconnect$.MODULE$.equals(object) ? true : (TestingJobManagerMessages$DisablePostStop$.MODULE$.equals(object) ? true : (object instanceof TestingJobManagerMessages.RequestSavepoint ? true : (object instanceof Messages.Disconnect ? true : (TestingJobManagerMessages$NotifyWhenLeader$.MODULE$.equals(object) ? true : (object instanceof JobManagerMessages.GrantLeadership ? true : (object instanceof TestingJobManagerMessages.NotifyWhenAtLeastNumTaskManagerAreRegistered ? true : object instanceof RegistrationMessages.RegisterTaskManager))))))))))))))))))))));
                return bl;
            }

            public /* synthetic */ JobManager org$apache$flink$runtime$testingUtils$TestingJobManagerLike$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static boolean checkIfAllVerticesRunning(JobManager $this, JobID jobID) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    Some some;
                    Tuple2 tuple2;
                    option = $this.currentJobs().get((Object)jobID);
                    if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block2;
                    ExecutionGraph eg = (ExecutionGraph)tuple2._1();
                    bl = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(eg.getAllExecutionVertices()).asScala()).forall((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ExecutionVertex x$11) {
                            ExecutionState executionState = x$11.getExecutionState();
                            ExecutionState executionState2 = ExecutionState.RUNNING;
                            return !(executionState != null ? !((Object)((Object)executionState)).equals((Object)((Object)executionState2)) : executionState2 != null);
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public static boolean checkIfAllVerticesRunningOrFinished(JobManager $this, JobID jobID) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    Some some;
                    Tuple2 tuple2;
                    option = $this.currentJobs().get((Object)jobID);
                    if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block2;
                    ExecutionGraph eg = (ExecutionGraph)tuple2._1();
                    bl = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(eg.getAllExecutionVertices()).asScala()).forall((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(ExecutionVertex x0$2) {
                            ExecutionVertex executionVertex = x0$2;
                            ExecutionState executionState = executionVertex.getExecutionState();
                            ExecutionState executionState2 = ExecutionState.RUNNING;
                            if (executionState == null) {
                                if (executionState2 == null) return true;
                            } else if (((Object)((Object)executionState)).equals((Object)((Object)executionState2))) return true;
                            ExecutionState executionState3 = executionVertex.getExecutionState();
                            ExecutionState executionState4 = ExecutionState.FINISHED;
                            if (executionState3 != null) {
                                if (!((Object)((Object)executionState3)).equals((Object)((Object)executionState4))) return false;
                                return true;
                            }
                            if (executionState4 == null) return true;
                            return false;
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public static void notifyListeners(JobManager $this, JobID jobID) {
        if (((TestingJobManagerLike)((Object)$this)).checkIfAllVerticesRunning(jobID)) {
            Option option = ((TestingJobManagerLike)((Object)$this)).waitForAllVerticesToBeRunning().remove((Object)jobID);
            if (option instanceof Some) {
                Some some = (Some)option;
                Set listeners = (Set)some.x();
                listeners.foreach((Function1)new Serializable($this, jobID){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JobManager $outer;
                    private final JobID jobID$4;

                    public final void apply(ActorRef listener) {
                        package$.MODULE$.actorRef2Scala(listener).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.AllVerticesRunning(this.jobID$4)), this.$outer.self());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jobID$4 = jobID$4;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (((TestingJobManagerLike)((Object)$this)).checkIfAllVerticesRunningOrFinished(jobID)) {
            Option option = ((TestingJobManagerLike)((Object)$this)).waitForAllVerticesToBeRunningOrFinished().remove((Object)jobID);
            if (option instanceof Some) {
                Some some = (Some)option;
                Set listeners = (Set)some.x();
                listeners.foreach((Function1)new Serializable($this, jobID){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JobManager $outer;
                    private final JobID jobID$4;

                    public final void apply(ActorRef listener) {
                        package$.MODULE$.actorRef2Scala(listener).$bang(this.$outer.decorateMessage(new TestingJobManagerMessages.AllVerticesRunning(this.jobID$4)), this.$outer.self());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jobID$4 = jobID$4;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static void shutdown(JobManager $this) {
        $this.log().info((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down TestingJobManager.";
            }
        });
        ((TestingJobManagerLike)((Object)$this)).waitForShutdown().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            public final void apply(ActorRef x$12) {
                package$.MODULE$.actorRef2Scala(x$12).$bang((Object)new TestingMessages.ComponentShutdown(this.$outer.self()), this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((TestingJobManagerLike)((Object)$this)).waitForShutdown().clear();
    }

    public static void $init$(JobManager $this) {
        ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$_setter_$waitForAllVerticesToBeRunning_$eq((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$_setter_$waitForTaskManagerToBeTerminated_$eq((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$_setter_$waitForAllVerticesToBeRunningOrFinished_$eq((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        ((TestingJobManagerLike)((Object)$this)).periodicCheck_$eq((Option<Cancellable>)None$.MODULE$);
        ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$_setter_$waitForJobStatus_$eq((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$_setter_$waitForAccumulatorUpdate_$eq((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$_setter_$waitForLeader_$eq((HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
        ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$_setter_$waitForNumRegisteredTaskManagers_$eq(PriorityQueue$.MODULE$.newBuilder((Ordering)new Ordering<Tuple2<Object, ActorRef>>($this){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Tuple2<Object, ActorRef>> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Tuple2<Object, ActorRef>> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(Tuple2<Object, ActorRef> x, Tuple2<Object, ActorRef> y) {
                return y._1$mcI$sp() - x._1$mcI$sp();
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        }));
        ((TestingJobManagerLike)((Object)$this)).org$apache$flink$runtime$testingUtils$TestingJobManagerLike$_setter_$waitForShutdown_$eq((HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
        ((TestingJobManagerLike)((Object)$this)).disconnectDisabled_$eq(false);
        ((TestingJobManagerLike)((Object)$this)).postStopEnabled_$eq(true);
    }
}

