/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.io.IOException;
import java.util.OptionalLong;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessageSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableSummary;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.flink.streaming.api.connector.sink2.IntegerSerializer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalLongAssert;
import org.junit.jupiter.api.Test;

class CommittableMessageSerializerTest {
    private static final CommittableMessageSerializer<Integer> SERIALIZER = new CommittableMessageSerializer((SimpleVersionedSerializer)new IntegerSerializer());

    CommittableMessageSerializerTest() {
    }

    @Test
    void testCommittableWithLinageSerDe() throws IOException {
        CommittableWithLineage committableWithLineage = new CommittableWithLineage((Object)1, Long.valueOf(2L), 3);
        CommittableMessage message = SERIALIZER.deserialize(1, SERIALIZER.serialize((CommittableMessage)committableWithLineage));
        Assertions.assertThat((Object)message).isInstanceOf(CommittableWithLineage.class);
        CommittableWithLineage copy = (CommittableWithLineage)message;
        Assertions.assertThat((Integer)((Integer)copy.getCommittable())).isEqualTo(1);
        ((OptionalLongAssert)Assertions.assertThat((OptionalLong)copy.getCheckpointId()).isPresent()).hasValue(2L);
        Assertions.assertThat((int)copy.getSubtaskId()).isEqualTo(3);
    }

    @Test
    void testCommittableSummarySerDe() throws IOException {
        CommittableSummary committableSummary = new CommittableSummary(1, 2, Long.valueOf(3L), 4, 5, 6);
        CommittableMessage message = SERIALIZER.deserialize(1, SERIALIZER.serialize((CommittableMessage)committableSummary));
        Assertions.assertThat((Object)message).isInstanceOf(CommittableSummary.class);
        CommittableSummary copy = (CommittableSummary)message;
        Assertions.assertThat((int)copy.getSubtaskId()).isEqualTo(1);
        Assertions.assertThat((int)copy.getNumberOfSubtasks()).isEqualTo(2);
        ((OptionalLongAssert)Assertions.assertThat((OptionalLong)copy.getCheckpointId()).isPresent()).hasValue(3L);
        Assertions.assertThat((int)copy.getNumberOfCommittables()).isEqualTo(4);
        Assertions.assertThat((int)copy.getNumberOfPendingCommittables()).isEqualTo(5);
        Assertions.assertThat((int)copy.getNumberOfFailedCommittables()).isEqualTo(6);
    }
}

