/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class ErasureDecodingStep
implements ErasureCodingStep {
    private ECBlock[] inputBlocks;
    private ECBlock[] outputBlocks;
    private int[] erasedIndexes;
    private RawErasureDecoder rawDecoder;

    public ErasureDecodingStep(ECBlock[] inputBlocks, int[] erasedIndexes, ECBlock[] outputBlocks, RawErasureDecoder rawDecoder) {
        this.inputBlocks = inputBlocks;
        this.outputBlocks = outputBlocks;
        this.erasedIndexes = erasedIndexes;
        this.rawDecoder = rawDecoder;
    }

    @Override
    public void performCoding(ECChunk[] inputChunks, ECChunk[] outputChunks) {
        this.rawDecoder.decode(inputChunks, this.erasedIndexes, outputChunks);
    }

    @Override
    public ECBlock[] getInputBlocks() {
        return this.inputBlocks;
    }

    @Override
    public ECBlock[] getOutputBlocks() {
        return this.outputBlocks;
    }

    @Override
    public void finish() {
    }
}

