/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeReport {
    static final Log LOG = LogFactory.getLog(TestDatanodeReport.class);
    private static final Configuration conf = new HdfsConfiguration();
    private static final int NUM_OF_DATANODES = 4;
    static final Comparator<StorageReport> CMP = new Comparator<StorageReport>(){

        @Override
        public int compare(StorageReport left, StorageReport right) {
            return left.getStorage().getStorageID().compareTo(right.getStorage().getStorageID());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatanodeReport() throws Exception {
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DFSClient client = cluster.getFileSystem().dfs;
            TestDatanodeReport.assertReports(4, HdfsConstants.DatanodeReportType.ALL, client, datanodes, bpid);
            TestDatanodeReport.assertReports(4, HdfsConstants.DatanodeReportType.LIVE, client, datanodes, bpid);
            TestDatanodeReport.assertReports(0, HdfsConstants.DatanodeReportType.DEAD, client, datanodes, bpid);
            DataNode last = (DataNode)datanodes.get(datanodes.size() - 1);
            LOG.info((Object)("XXX shutdown datanode " + last.getDatanodeUuid()));
            last.shutdown();
            DatanodeInfo[] nodeInfo = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            while (nodeInfo.length != 1) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                nodeInfo = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            }
            TestDatanodeReport.assertReports(4, HdfsConstants.DatanodeReportType.ALL, client, datanodes, null);
            TestDatanodeReport.assertReports(3, HdfsConstants.DatanodeReportType.LIVE, client, datanodes, null);
            TestDatanodeReport.assertReports(1, HdfsConstants.DatanodeReportType.DEAD, client, datanodes, null);
            Thread.sleep(5000L);
            MetricsAsserts.assertGauge((String)"ExpiredHeartbeats", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"FSNamesystem"));
        }
        finally {
            cluster.shutdown();
        }
    }

    static void assertReports(int numDatanodes, HdfsConstants.DatanodeReportType type, DFSClient client, List<DataNode> datanodes, String bpid) throws IOException {
        DatanodeInfo[] infos = client.datanodeReport(type);
        Assert.assertEquals((long)numDatanodes, (long)infos.length);
        DatanodeStorageReport[] reports = client.getDatanodeStorageReport(type);
        Assert.assertEquals((long)numDatanodes, (long)reports.length);
        for (int i = 0; i < infos.length; ++i) {
            Assert.assertEquals((Object)infos[i], (Object)reports[i].getDatanodeInfo());
            DataNode d = TestDatanodeReport.findDatanode(infos[i].getDatanodeUuid(), datanodes);
            if (bpid == null) continue;
            StorageReport[] computed = reports[i].getStorageReports();
            Arrays.sort(computed, CMP);
            StorageReport[] expected = d.getFSDataset().getStorageReports(bpid);
            Arrays.sort(expected, CMP);
            Assert.assertEquals((long)expected.length, (long)computed.length);
            for (int j = 0; j < expected.length; ++j) {
                Assert.assertEquals((Object)expected[j].getStorage().getStorageID(), (Object)computed[j].getStorage().getStorageID());
            }
        }
    }

    static DataNode findDatanode(String id, List<DataNode> datanodes) {
        for (DataNode d : datanodes) {
            if (!d.getDatanodeUuid().equals(id)) continue;
            return d;
        }
        throw new IllegalStateException("Datnode " + id + " not in datanode list: " + datanodes);
    }
}

