/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerClient;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRunCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DockerLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Log LOG = LogFactory.getLog(DockerLinuxContainerRuntime.class);
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE_FILE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE_FILE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_PRIVILEGED_CONTAINER = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINER";
    private Configuration conf;
    private DockerClient dockerClient;
    private PrivilegedOperationExecutor privilegedOperationExecutor;
    private AccessControlList privilegedContainersAcl;

    public static boolean isDockerContainerRequested(Map<String, String> env) {
        if (env == null) {
            return false;
        }
        String type = env.get("YARN_CONTAINER_RUNTIME_TYPE");
        return type != null && type.equals("docker");
    }

    public DockerLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this.privilegedOperationExecutor = privilegedOperationExecutor;
    }

    @Override
    public void initialize(Configuration conf) throws ContainerExecutionException {
        this.conf = conf;
        this.dockerClient = new DockerClient(conf);
        this.privilegedContainersAcl = new AccessControlList(conf.get("yarn.nodemanager.runtime.linux.docker.privileged-containers.acl", ""));
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    public void addCGroupParentIfRequired(String resourcesOptions, String containerIdStr, DockerRunCommand runCommand) throws ContainerExecutionException {
        if (resourcesOptions.equals("cgroups=none")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"no resource restrictions specified. not using docker's cgroup options");
            }
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"using docker's cgroups options");
            }
            try {
                CGroupsHandler cGroupsHandler = ResourceHandlerModule.getCGroupsHandler(this.conf);
                String cGroupPath = "/" + cGroupsHandler.getRelativePathForCGroup(containerIdStr);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("using cgroup parent: " + cGroupPath));
                }
                runCommand.setCGroupParent(cGroupPath);
            }
            catch (ResourceHandlerException e) {
                LOG.warn((Object)"unable to use cgroups handler. Exception: ", (Throwable)((Object)e));
                throw new ContainerExecutionException((Throwable)((Object)e));
            }
        }
    }

    private boolean allowPrivilegedContainerExecution(Container container) throws ContainerExecutionException {
        boolean privilegedContainersEnabledOnCluster;
        Map environment = container.getLaunchContext().getEnvironment();
        String runPrivilegedContainerEnvVar = (String)environment.get(ENV_DOCKER_CONTAINER_RUN_PRIVILEGED_CONTAINER);
        if (runPrivilegedContainerEnvVar == null) {
            return false;
        }
        if (!runPrivilegedContainerEnvVar.equalsIgnoreCase("true")) {
            LOG.warn((Object)("NOT running a privileged container. Value of YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINERis invalid: " + runPrivilegedContainerEnvVar));
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Privileged container requested for : " + container.getContainerId().toString()));
        }
        if (!(privilegedContainersEnabledOnCluster = this.conf.getBoolean("yarn.nodemanager.runtime.linux.docker.privileged-containers.allowed", false))) {
            String message = "Privileged container being requested but privileged containers are not enabled on this cluster";
            LOG.warn((Object)message);
            throw new ContainerExecutionException(message);
        }
        String submittingUser = container.getUser();
        UserGroupInformation submitterUgi = UserGroupInformation.createRemoteUser((String)submittingUser);
        if (!this.privilegedContainersAcl.isUserAllowed(submitterUgi)) {
            String message = "Cannot launch privileged container. Submitting user (" + submittingUser + ") fails ACL check.";
            LOG.warn((Object)message);
            throw new ContainerExecutionException(message);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("All checks pass. Launching privileged container for : " + container.getContainerId().toString()));
        }
        return true;
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        Map environment = container.getLaunchContext().getEnvironment();
        String imageName = (String)environment.get(ENV_DOCKER_CONTAINER_IMAGE);
        if (imageName == null) {
            throw new ContainerExecutionException("YARN_CONTAINER_RUNTIME_DOCKER_IMAGE not set!");
        }
        String containerIdStr = container.getContainerId().toString();
        String runAsUser = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER);
        Path containerWorkDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR);
        List localDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS);
        List logDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS);
        HashSet<String> capabilities = new HashSet<String>(Arrays.asList(this.conf.getStrings("yarn.nodemanager.runtime.linux.docker.capabilities", YarnConfiguration.DEFAULT_NM_DOCKER_CONTAINER_CAPABILITIES)));
        DockerRunCommand runCommand = new DockerRunCommand(containerIdStr, runAsUser, imageName).detachOnRun().setContainerWorkDir(containerWorkDir.toString()).setNetworkType("host").setCapabilities(capabilities).addMountLocation("/etc/passwd", "/etc/password:ro");
        ArrayList<String> allDirs = new ArrayList<String>(localDirs);
        allDirs.add(containerWorkDir.toString());
        allDirs.addAll(logDirs);
        for (String dir : allDirs) {
            runCommand.addMountLocation(dir, dir);
        }
        if (this.allowPrivilegedContainerExecution(container)) {
            runCommand.setPrivileged();
        }
        String resourcesOpts = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS);
        Path nmPrivateContainerScriptPath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH);
        String disableOverride = (String)environment.get(ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE);
        if (disableOverride != null && disableOverride.equals("true")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"command override disabled");
            }
        } else {
            ArrayList<String> overrideCommands = new ArrayList<String>();
            Path launchDst = new Path(containerWorkDir, ContainerLaunch.CONTAINER_SCRIPT);
            overrideCommands.add("bash");
            overrideCommands.add(launchDst.toUri().getPath());
            runCommand.setOverrideCommandWithArgs(overrideCommands);
        }
        String commandFile = this.dockerClient.writeCommandToTempFile(runCommand, containerIdStr);
        PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.LAUNCH_DOCKER_CONTAINER);
        launchOp.appendArgs(runAsUser, ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.LAUNCH_DOCKER_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPID), containerIdStr, containerWorkDir.toString(), nmPrivateContainerScriptPath.toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH).toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH).toString(), StringUtils.join((char)'%', (Iterable)localDirs), StringUtils.join((char)'%', (Iterable)logDirs), commandFile, resourcesOpts);
        String tcCommandFile = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE);
        if (tcCommandFile != null) {
            launchOp.appendArgs(tcCommandFile);
        }
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(null, launchOp, null, container.getLaunchContext().getEnvironment(), false, false);
        }
        catch (PrivilegedOperationException e) {
            LOG.warn((Object)"Launch container failed. Exception: ", (Throwable)((Object)e));
            throw new ContainerExecutionException("Launch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        PrivilegedOperation signalOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SIGNAL_CONTAINER);
        signalOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.SIGNAL_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID), Integer.toString(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL).getValue()));
        try {
            PrivilegedOperationExecutor executor = PrivilegedOperationExecutor.getInstance(this.conf);
            executor.executePrivilegedOperation(null, signalOp, null, container.getLaunchContext().getEnvironment(), false, true);
        }
        catch (PrivilegedOperationException e) {
            LOG.warn((Object)"Signal container failed. Exception: ", (Throwable)((Object)e));
            throw new ContainerExecutionException("Signal container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }
}

