/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class TableName
implements Comparable<TableName> {
    public static final char NAMESPACE_DELIM = ':';
    public static final String VALID_NAMESPACE_REGEX = "(?:[a-zA-Z_0-9]+)";
    public static final String VALID_TABLE_QUALIFIER_REGEX = "(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)";
    public static final String VALID_USER_TABLE_REGEX = "(?:(?:(?:(?:[a-zA-Z_0-9]+)\\:)?)(?:(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)))";
    public static final TableName META_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "meta");
    public static final TableName NAMESPACE_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "namespace");
    public static final String OLD_META_STR = ".META.";
    public static final String OLD_ROOT_STR = "-ROOT-";
    public static final TableName OLD_ROOT_TABLE_NAME = TableName.getADummyTableName("-ROOT-");
    public static final TableName OLD_META_TABLE_NAME = TableName.getADummyTableName(".META.");
    private byte[] name;
    private String nameAsString;
    private byte[] namespace;
    private String namespaceAsString;
    private byte[] qualifier;
    private String qualifierAsString;
    private boolean systemTable;

    private TableName() {
    }

    public static byte[] isLegalFullyQualifiedTableName(byte[] tableName) {
        if (tableName == null || tableName.length <= 0) {
            throw new IllegalArgumentException("Name is null or empty");
        }
        int namespaceDelimIndex = com.google.common.primitives.Bytes.lastIndexOf((byte[])tableName, (byte)58);
        if (namespaceDelimIndex == 0 || namespaceDelimIndex == -1) {
            TableName.isLegalTableQualifierName(tableName);
        } else {
            TableName.isLegalNamespaceName(tableName, 0, namespaceDelimIndex);
            TableName.isLegalTableQualifierName(tableName, namespaceDelimIndex + 1, tableName.length);
        }
        return tableName;
    }

    public static byte[] isLegalTableQualifierName(byte[] qualifierName) {
        TableName.isLegalTableQualifierName(qualifierName, 0, qualifierName.length);
        return qualifierName;
    }

    public static void isLegalTableQualifierName(byte[] qualifierName, int start, int end) {
        if (end - start < 1) {
            throw new IllegalArgumentException("Table qualifier must not be empty");
        }
        if (qualifierName[start] == 46 || qualifierName[start] == 45) {
            throw new IllegalArgumentException("Illegal first character <" + qualifierName[0] + "> at 0. Namespaces can only start with alphanumeric " + "characters': i.e. [a-zA-Z_0-9]: " + Bytes.toString(qualifierName));
        }
        for (int i = start; i < end; ++i) {
            if (Character.isLetterOrDigit(qualifierName[i]) || qualifierName[i] == 95 || qualifierName[i] == 45 || qualifierName[i] == 46) continue;
            throw new IllegalArgumentException("Illegal character <" + qualifierName[i] + "> at " + i + ". User-space table qualifiers can only contain " + "'alphanumeric characters': i.e. [a-zA-Z_0-9-.]: " + Bytes.toString(qualifierName, start, end));
        }
    }

    public static void isLegalNamespaceName(byte[] namespaceName) {
        TableName.isLegalNamespaceName(namespaceName, 0, namespaceName.length);
    }

    public static void isLegalNamespaceName(byte[] namespaceName, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            if (Character.isLetterOrDigit(namespaceName[i]) || namespaceName[i] == 95) continue;
            throw new IllegalArgumentException("Illegal character <" + namespaceName[i] + "> at " + i + ". Namespaces can only contain " + "'alphanumeric characters': i.e. [a-zA-Z_0-9]: " + Bytes.toString(namespaceName, offset, length));
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return this.nameAsString;
    }

    public byte[] getNamespace() {
        return this.namespace;
    }

    public String getNamespaceAsString() {
        return this.namespaceAsString;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public String getQualifierAsString() {
        return this.qualifierAsString;
    }

    public byte[] toBytes() {
        return this.name;
    }

    public boolean isSystemTable() {
        return this.systemTable;
    }

    public String toString() {
        return this.nameAsString;
    }

    public static TableName valueOf(byte[] namespace, byte[] qualifier) {
        TableName ret = new TableName();
        if (namespace == null || namespace.length < 1) {
            namespace = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME;
        }
        ret.namespace = namespace;
        ret.namespaceAsString = Bytes.toString(namespace);
        ret.qualifier = qualifier;
        ret.qualifierAsString = Bytes.toString(qualifier);
        TableName.finishValueOf(ret);
        return ret;
    }

    private static TableName getADummyTableName(String qualifier) {
        TableName ret = new TableName();
        ret.namespaceAsString = NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR;
        ret.qualifierAsString = qualifier;
        ret.nameAsString = TableName.createFullyQualified(ret.namespaceAsString, ret.qualifierAsString);
        ret.name = Bytes.toBytes(qualifier);
        return ret;
    }

    public static TableName valueOf(String namespaceAsString, String qualifierAsString) {
        TableName ret = new TableName();
        if (namespaceAsString == null || namespaceAsString.length() < 1) {
            namespaceAsString = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR;
        }
        ret.namespaceAsString = namespaceAsString;
        ret.namespace = Bytes.toBytes(namespaceAsString);
        ret.qualifier = Bytes.toBytes(qualifierAsString);
        ret.qualifierAsString = qualifierAsString;
        TableName.finishValueOf(ret);
        return ret;
    }

    private static void finishValueOf(TableName tableName) {
        TableName.isLegalNamespaceName(tableName.namespace);
        TableName.isLegalTableQualifierName(tableName.qualifier);
        tableName.nameAsString = TableName.createFullyQualified(tableName.namespaceAsString, tableName.qualifierAsString);
        tableName.name = Bytes.toBytes(tableName.nameAsString);
        tableName.systemTable = Bytes.equals(tableName.namespace, NamespaceDescriptor.SYSTEM_NAMESPACE_NAME);
    }

    public static TableName valueOf(byte[] name) {
        return TableName.valueOf(Bytes.toString(name));
    }

    public static TableName valueOf(String name) {
        if (name.equals(OLD_ROOT_STR)) {
            throw new IllegalArgumentException("-ROOT- has been deprecated.");
        }
        if (name.equals(OLD_META_STR)) {
            throw new IllegalArgumentException(".META. no longer exists. The table has been renamed to " + META_TABLE_NAME);
        }
        TableName.isLegalFullyQualifiedTableName(Bytes.toBytes(name));
        int index = name.indexOf(58);
        if (index != -1) {
            return TableName.valueOf(name.substring(0, index), name.substring(index + 1));
        }
        return TableName.valueOf(NamespaceDescriptor.DEFAULT_NAMESPACE.getName(), name);
    }

    private static String createFullyQualified(String namespace, String tableQualifier) {
        if (namespace.equals(NamespaceDescriptor.DEFAULT_NAMESPACE.getName())) {
            return tableQualifier;
        }
        return namespace + ':' + tableQualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableName tableName = (TableName)o;
        return this.nameAsString.equals(tableName.nameAsString);
    }

    public int hashCode() {
        int result = this.nameAsString.hashCode();
        return result;
    }

    @Override
    public int compareTo(TableName tableName) {
        return this.nameAsString.compareTo(tableName.getNameAsString());
    }

    public KeyValue.KVComparator getRowComparator() {
        if (META_TABLE_NAME.equals(this)) {
            return KeyValue.META_COMPARATOR;
        }
        return KeyValue.COMPARATOR;
    }
}

