/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.SimpleByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ByteRangeUtils {
    public static int numEqualPrefixBytes(ByteRange left, ByteRange right, int rightInnerOffset) {
        int maxCompares = Math.min(left.getLength(), right.getLength() - rightInnerOffset);
        byte[] lbytes = left.getBytes();
        byte[] rbytes = right.getBytes();
        int loffset = left.getOffset();
        int roffset = right.getOffset();
        for (int i = 0; i < maxCompares; ++i) {
            if (lbytes[loffset + i] == rbytes[roffset + rightInnerOffset + i]) continue;
            return i;
        }
        return maxCompares;
    }

    public static ArrayList<byte[]> copyToNewArrays(Collection<ByteRange> ranges) {
        if (ranges == null) {
            return new ArrayList<byte[]>(0);
        }
        ArrayList arrays = Lists.newArrayListWithCapacity((int)ranges.size());
        for (ByteRange range : ranges) {
            arrays.add(range.deepCopyToNewArray());
        }
        return arrays;
    }

    public static ArrayList<ByteRange> fromArrays(Collection<byte[]> arrays) {
        if (arrays == null) {
            return new ArrayList<ByteRange>(0);
        }
        ArrayList ranges = Lists.newArrayListWithCapacity((int)arrays.size());
        for (byte[] array : arrays) {
            ranges.add(new SimpleByteRange(array));
        }
        return ranges;
    }

    public static void write(OutputStream os, ByteRange byteRange) throws IOException {
        os.write(byteRange.getBytes(), byteRange.getOffset(), byteRange.getLength());
    }

    public static void write(OutputStream os, ByteRange byteRange, int byteRangeInnerOffset) throws IOException {
        os.write(byteRange.getBytes(), byteRange.getOffset() + byteRangeInnerOffset, byteRange.getLength() - byteRangeInnerOffset);
    }
}

