/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RegionSizeCalculator;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class TableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    final Log LOG = LogFactory.getLog(TableInputFormatBase.class);
    private static final String NOT_INITIALIZED = "The input format instance has not been properly initialized. Ensure you call initializeTable either in your constructor or initialize method";
    private static final String INITIALIZATION_ERROR = "Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.";
    private Scan scan = null;
    private Admin admin;
    private Table table;
    private RegionLocator regionLocator;
    private TableRecordReader tableRecordReader = null;
    private Connection connection;
    private HashMap<InetAddress, String> reverseDNSCacheMap = new HashMap();

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        if (this.table == null) {
            this.initialize((JobContext)context);
        }
        try {
            if (this.getTable() == null) {
                throw new IOException(INITIALIZATION_ERROR);
            }
        }
        catch (IllegalStateException exception) {
            throw new IOException(INITIALIZATION_ERROR, exception);
        }
        TableSplit tSplit = (TableSplit)split;
        this.LOG.info((Object)("Input split length: " + StringUtils.humanReadableInt((long)tSplit.getLength()) + " bytes."));
        final TableRecordReader trr = this.tableRecordReader != null ? this.tableRecordReader : new TableRecordReader();
        Scan sc = new Scan(this.scan);
        sc.setStartRow(tSplit.getStartRow());
        sc.setStopRow(tSplit.getEndRow());
        trr.setScan(sc);
        trr.setTable(this.getTable());
        return new RecordReader<ImmutableBytesWritable, Result>(){

            public void close() throws IOException {
                trr.close();
                TableInputFormatBase.this.closeTable();
            }

            public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                return trr.getCurrentKey();
            }

            public Result getCurrentValue() throws IOException, InterruptedException {
                return trr.getCurrentValue();
            }

            public float getProgress() throws IOException, InterruptedException {
                return trr.getProgress();
            }

            public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
                trr.initialize(inputsplit, context);
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return trr.nextKeyValue();
            }
        };
    }

    protected Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.getRegionLocator().getStartEndKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        boolean closeOnFinish = false;
        if (this.table == null) {
            this.initialize(context);
            closeOnFinish = true;
        }
        try {
            if (this.getTable() == null) {
                throw new IOException(INITIALIZATION_ERROR);
            }
        }
        catch (IllegalStateException exception) {
            throw new IOException(INITIALIZATION_ERROR, exception);
        }
        try {
            RegionSizeCalculator sizeCalculator = new RegionSizeCalculator(this.regionLocator, this.admin);
            Pair<byte[][], byte[][]> keys = this.getStartEndKeys();
            if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
                HRegionLocation regLoc = this.regionLocator.getRegionLocation(HConstants.EMPTY_BYTE_ARRAY, false);
                if (null == regLoc) {
                    throw new IOException("Expecting at least one region.");
                }
                ArrayList<InputSplit> splits = new ArrayList<InputSplit>(1);
                long regionSize = sizeCalculator.getRegionSize(regLoc.getRegionInfo().getRegionName());
                TableSplit split = new TableSplit(this.table.getName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, regLoc.getHostnamePort().split(":")[0], regionSize);
                splits.add(split);
                ArrayList<InputSplit> arrayList = splits;
                return arrayList;
            }
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(((byte[][])keys.getFirst()).length);
            for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
                String regionLocation;
                if (!this.includeRegionInSplit(((byte[][])keys.getFirst())[i], ((byte[][])keys.getSecond())[i])) continue;
                HRegionLocation location = this.regionLocator.getRegionLocation(((byte[][])keys.getFirst())[i], false);
                InetSocketAddress isa = new InetSocketAddress(location.getHostname(), location.getPort());
                if (isa.isUnresolved()) {
                    this.LOG.warn((Object)("Failed resolve " + isa));
                }
                InetAddress regionAddress = isa.getAddress();
                try {
                    regionLocation = this.reverseDNS(regionAddress);
                }
                catch (NamingException e) {
                    this.LOG.warn((Object)("Cannot resolve the host name for " + regionAddress + " because of " + e));
                    regionLocation = location.getHostname();
                }
                byte[] startRow = this.scan.getStartRow();
                byte[] stopRow = this.scan.getStopRow();
                if (startRow.length != 0 && ((byte[][])keys.getSecond())[i].length != 0 && Bytes.compareTo((byte[])startRow, (byte[])((byte[][])keys.getSecond())[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])((byte[][])keys.getFirst())[i]) <= 0) continue;
                byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getFirst())[i], (byte[])startRow) >= 0 ? ((byte[][])keys.getFirst())[i] : startRow;
                byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getSecond())[i], (byte[])stopRow) <= 0) && ((byte[][])keys.getSecond())[i].length > 0 ? ((byte[][])keys.getSecond())[i] : stopRow;
                byte[] regionName = location.getRegionInfo().getRegionName();
                long regionSize = sizeCalculator.getRegionSize(regionName);
                TableSplit split = new TableSplit(this.table.getName(), splitStart, splitStop, regionLocation, regionSize);
                splits.add(split);
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.debug((Object)("getSplits: split -> " + i + " -> " + split));
            }
            ArrayList<InputSplit> arrayList = splits;
            return arrayList;
        }
        finally {
            if (closeOnFinish) {
                this.closeTable();
            }
        }
    }

    @Deprecated
    public String reverseDNS(InetAddress ipAddress) throws NamingException, UnknownHostException {
        String hostName = this.reverseDNSCacheMap.get(ipAddress);
        if (hostName == null) {
            String ipAddressString = null;
            try {
                ipAddressString = DNS.reverseDns((InetAddress)ipAddress, null);
            }
            catch (Exception e) {
                ipAddressString = InetAddress.getByName(ipAddress.getHostAddress()).getHostName();
            }
            if (ipAddressString == null) {
                throw new UnknownHostException("No host found for " + ipAddress);
            }
            hostName = Strings.domainNamePointerToHostName((String)ipAddressString);
            this.reverseDNSCacheMap.put(ipAddress, hostName);
        }
        return hostName;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    @Deprecated
    protected HTable getHTable() {
        return (HTable)this.getTable();
    }

    protected RegionLocator getRegionLocator() {
        if (this.regionLocator == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.regionLocator;
    }

    protected Table getTable() {
        if (this.table == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.table;
    }

    protected Admin getAdmin() {
        if (this.admin == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.admin;
    }

    @Deprecated
    protected void setHTable(HTable table) throws IOException {
        this.table = table;
        this.connection = table.getConnection();
        try {
            this.regionLocator = table;
            this.admin = this.connection.getAdmin();
        }
        catch (NeedUnmanagedConnectionException exception) {
            this.LOG.warn((Object)"You are using an HTable instance that relies on an HBase-managed Connection. This is usually due to directly creating an HTable, which is deprecated. Instead, you should create a Connection object and then request a Table instance from it. If you don't need the Table instance for your own use, you should instead use the TableInputFormatBase.initalizeTable method directly.");
            this.LOG.info((Object)"Creating an additional unmanaged connection because user provided one can't be used for administrative actions. We'll close it when we close out the table.");
            this.LOG.debug((Object)"Details about our failure to request an administrative interface.", (Throwable)exception);
            this.connection = ConnectionFactory.createConnection((Configuration)this.connection.getConfiguration());
            this.regionLocator = this.connection.getRegionLocator(table.getName());
            this.admin = this.connection.getAdmin();
        }
    }

    protected void initializeTable(Connection connection, TableName tableName) throws IOException {
        if (this.table != null || connection != null) {
            this.LOG.warn((Object)"initializeTable called multiple times. Overwriting connection and table reference; TableInputFormatBase will not close these old references when done.");
        }
        this.table = connection.getTable(tableName);
        this.regionLocator = connection.getRegionLocator(tableName);
        this.admin = connection.getAdmin();
        this.connection = connection;
    }

    public Scan getScan() {
        if (this.scan == null) {
            this.scan = new Scan();
        }
        return this.scan;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }

    protected void initialize(JobContext context) throws IOException {
    }

    protected void closeTable() throws IOException {
        this.close(new Closeable[]{this.admin, this.table, this.regionLocator, this.connection});
        this.admin = null;
        this.table = null;
        this.regionLocator = null;
        this.connection = null;
    }

    private void close(Closeable ... closables) throws IOException {
        for (Closeable c : closables) {
            if (c == null) continue;
            c.close();
        }
    }
}

