/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeperMain;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class ZooKeeperMainServer {
    private static final String SERVER_ARG = "-server";

    public String parse(Configuration c) {
        Properties zkProps = ZKConfig.makeZKProps((Configuration)c);
        String clientPort = null;
        ArrayList<String> hosts = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : zkProps.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key.startsWith("server.")) {
                String[] parts = value.split(":");
                hosts.add(parts[0]);
                continue;
            }
            if (!key.endsWith("clientPort")) continue;
            clientPort = value;
        }
        if (hosts.isEmpty() || clientPort == null) {
            return null;
        }
        StringBuilder host = new StringBuilder();
        for (int i = 0; i < hosts.size(); ++i) {
            if (i > 0) {
                host.append("," + (String)hosts.get(i));
            } else {
                host.append((String)hosts.get(i));
            }
            host.append(":");
            host.append(clientPort);
        }
        return host.toString();
    }

    private static boolean hasServer(String[] args) {
        return args.length > 0 && args[0].equals(SERVER_ARG);
    }

    private static boolean hasCommandLineArguments(String[] args) {
        if (ZooKeeperMainServer.hasServer(args)) {
            if (args.length < 2) {
                throw new IllegalStateException("-server param but no value");
            }
            return args.length > 2;
        }
        return args.length > 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf;
        String hostport;
        String[] newArgs = args;
        if (!ZooKeeperMainServer.hasServer(args) && (hostport = new ZooKeeperMainServer().parse(conf = HBaseConfiguration.create())) != null && hostport.length() > 0) {
            newArgs = new String[args.length + 2];
            System.arraycopy(args, 0, newArgs, 2, args.length);
            newArgs[0] = SERVER_ARG;
            newArgs[1] = hostport;
        }
        if (ZooKeeperMainServer.hasCommandLineArguments(args)) {
            HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain zkm = new HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain(newArgs);
            zkm.runCmdLine();
        } else {
            ZooKeeperMain.main((String[])newArgs);
        }
    }

    private static class HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain
    extends ZooKeeperMain {
        public HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain(String[] args) throws IOException, InterruptedException {
            super(args);
        }

        void runCmdLine() throws KeeperException, IOException, InterruptedException {
            this.processCmd(this.cl);
            System.exit(0);
        }
    }
}

