/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.master.TestRegionPlacement;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterOperationsForRegionReplicas {
    static final Log LOG = LogFactory.getLog(TestRegionPlacement.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Connection CONNECTION = null;
    private static Admin ADMIN;
    private static int numSlaves;
    private static Configuration conf;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        TEST_UTIL.startMiniCluster(numSlaves);
        CONNECTION = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        ADMIN = CONNECTION.getAdmin();
        while (ADMIN.getClusterStatus().getServers().size() < numSlaves) {
            Thread.sleep(100L);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (ADMIN != null) {
            ADMIN.close();
        }
        if (CONNECTION != null && !CONNECTION.isClosed()) {
            CONNECTION.close();
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSingleReplica() throws Exception {
        int numRegions = 3;
        boolean numReplica = true;
        TableName table = TableName.valueOf((String)"singleReplicaTable");
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.setRegionReplication(1);
            desc.addFamily(new HColumnDescriptor("family"));
            ADMIN.createTable(desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 3);
            this.validateNumberOfRowsInMeta(table, 3, ADMIN.getConnection());
            List hris = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (Connection)ADMIN.getConnection(), (TableName)table);
            assert (hris.size() == 3);
        }
        finally {
            ADMIN.disableTable(table);
            ADMIN.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithMultipleReplicas() throws Exception {
        TableName table = TableName.valueOf((String)"fooTable");
        int numRegions = 3;
        int numReplica = 2;
        try {
            int i;
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.setRegionReplication(2);
            desc.addFamily(new HColumnDescriptor("family"));
            ADMIN.createTable(desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 3);
            TEST_UTIL.waitTableEnabled(table);
            this.validateNumberOfRowsInMeta(table, 3, ADMIN.getConnection());
            List hris = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (Connection)ADMIN.getConnection(), (TableName)table);
            assert (hris.size() == 6);
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int j = 0; j < 2; ++j) {
                    HRegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)((HRegionInfo)hris.get(i2)), (int)j);
                    RegionState state = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(replica);
                    assert (state != null);
                }
            }
            List metaRows = MetaTableAccessor.fullScanOfMeta((Connection)ADMIN.getConnection());
            int numRows = 0;
            for (Result result : metaRows) {
                RegionLocations locations = MetaTableAccessor.getRegionLocations((Result)result);
                HRegionInfo hri = locations.getRegionLocation().getRegionInfo();
                if (!hri.getTable().equals((Object)table)) continue;
                ++numRows;
                HRegionLocation[] servers = locations.getRegionLocations();
                assert (servers.length == 2);
                assert (!servers[0].equals((Object)servers[1]));
            }
            assert (numRows == 3);
            this.validateFromSnapshotFromMeta(TEST_UTIL, table, 3, 2, ADMIN.getConnection());
            ServerName master = TEST_UTIL.getHBaseClusterInterface().getClusterStatus().getMaster();
            TEST_UTIL.getHBaseClusterInterface().stopMaster(master);
            TEST_UTIL.getHBaseClusterInterface().waitForMasterToStop(master, 30000L);
            TEST_UTIL.getHBaseClusterInterface().startMaster(master.getHostname(), master.getPort());
            TEST_UTIL.getHBaseClusterInterface().waitForActiveAndReadyMaster();
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 2; ++j) {
                    HRegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)((HRegionInfo)hris.get(i)), (int)j);
                    RegionState state = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(replica);
                    assert (state != null);
                }
            }
            this.validateFromSnapshotFromMeta(TEST_UTIL, table, 3, 2, ADMIN.getConnection());
            TEST_UTIL.getConfiguration().setBoolean("hbase.master.startup.retainassign", true);
            TEST_UTIL.shutdownMiniHBaseCluster();
            TEST_UTIL.startMiniHBaseCluster(1, numSlaves);
            TEST_UTIL.waitTableEnabled(table);
            this.validateFromSnapshotFromMeta(TEST_UTIL, table, 3, 2, ADMIN.getConnection());
            TEST_UTIL.shutdownMiniHBaseCluster();
            TEST_UTIL.startMiniHBaseCluster(1, 1);
            TEST_UTIL.waitTableEnabled(table);
            this.validateSingleRegionServerAssignment(ADMIN.getConnection(), 3, 2);
            for (i = 1; i < numSlaves; ++i) {
                TEST_UTIL.getMiniHBaseCluster().startRegionServer();
            }
            ADMIN.disableTable(table);
            assert (ADMIN.isTableDisabled(table));
            desc.setRegionReplication(3);
            ADMIN.modifyTable(table, desc);
            ADMIN.enableTable(table);
            assert (ADMIN.isTableEnabled(table));
            List regions = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(table);
            assert (regions.size() == 9);
            ADMIN.disableTable(table);
            desc.setRegionReplication(2);
            ADMIN.modifyTable(table, desc);
            ADMIN.enableTable(table);
            assert (ADMIN.isTableEnabled(table));
            regions = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(table);
            assert (regions.size() == 6);
            hris = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (Connection)ADMIN.getConnection(), (TableName)table);
            assert (hris.size() == 6);
            HashMap<HRegionInfo, Integer> defaultReplicas = new HashMap<HRegionInfo, Integer>();
            for (HRegionInfo hri : hris) {
                HRegionInfo regionReplica0;
                Integer i3 = (Integer)defaultReplicas.get(regionReplica0 = RegionReplicaUtil.getRegionInfoForDefaultReplica((HRegionInfo)hri));
                defaultReplicas.put(regionReplica0, i3 == null ? 1 : i3 + 1);
            }
            assert (defaultReplicas.size() == 3);
            HashSet counts = new HashSet(defaultReplicas.values());
            assert (counts.size() == 1 && counts.contains(new Integer(2)));
        }
        finally {
            ADMIN.disableTable(table);
            ADMIN.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncompleteMetaTableReplicaInformation() throws Exception {
        TableName table = TableName.valueOf((String)"fooTableTest1");
        int numRegions = 3;
        int numReplica = 2;
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.setRegionReplication(2);
            desc.addFamily(new HColumnDescriptor("family"));
            ADMIN.createTable(desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 3);
            TEST_UTIL.waitTableEnabled(table);
            HashSet<byte[]> tableRows = new HashSet<byte[]>();
            List hris = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (Connection)ADMIN.getConnection(), (TableName)table);
            for (HRegionInfo hri : hris) {
                tableRows.add(hri.getRegionName());
            }
            ADMIN.disableTable(table);
            HTable metaTable = new HTable(TableName.META_TABLE_NAME, ADMIN.getConnection());
            for (byte[] row : tableRows) {
                Delete deleteOneReplicaLocation = new Delete(row);
                deleteOneReplicaLocation.deleteColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)1));
                deleteOneReplicaLocation.deleteColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn((int)1));
                deleteOneReplicaLocation.deleteColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)1));
                metaTable.delete(deleteOneReplicaLocation);
            }
            metaTable.close();
            ADMIN.enableTable(table);
            assert (ADMIN.isTableEnabled(table));
            List regions = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(table);
            assert (regions.size() == 6);
        }
        finally {
            ADMIN.disableTable(table);
            ADMIN.deleteTable(table);
        }
    }

    private String printRegions(List<HRegionInfo> regions) {
        StringBuffer strBuf = new StringBuffer();
        for (HRegionInfo r : regions) {
            strBuf.append(" ____ " + r.toString());
        }
        return strBuf.toString();
    }

    private void validateNumberOfRowsInMeta(final TableName table, int numRegions, Connection connection) throws IOException {
        assert (ADMIN.tableExists(table));
        final AtomicInteger count = new AtomicInteger();
        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

            public boolean visit(Result r) throws IOException {
                if (HRegionInfo.getHRegionInfo((Result)r).getTable().equals((Object)table)) {
                    count.incrementAndGet();
                }
                return true;
            }
        };
        MetaTableAccessor.fullScan((Connection)connection, (MetaTableAccessor.Visitor)visitor);
        assert (count.get() == numRegions);
    }

    private void validateFromSnapshotFromMeta(HBaseTestingUtility util, TableName table, int numRegions, int numReplica, Connection connection) throws IOException {
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(connection);
        snapshot.initialize();
        Map regionToServerMap = snapshot.getRegionToRegionServerMap();
        assert (regionToServerMap.size() == numRegions * numReplica + 1);
        Map serverToRegionMap = snapshot.getRegionServerToRegionMap();
        for (Map.Entry entry : serverToRegionMap.entrySet()) {
            if (((ServerName)entry.getKey()).equals((Object)util.getHBaseCluster().getMaster().getServerName())) continue;
            List regions = (List)entry.getValue();
            HashSet<byte[]> setOfStartKeys = new HashSet<byte[]>();
            for (HRegionInfo region : regions) {
                byte[] startKey = region.getStartKey();
                if (!region.getTable().equals((Object)table)) continue;
                setOfStartKeys.add(startKey);
                LOG.info((Object)("--STARTKEY " + new String(startKey) + "--"));
            }
            Assert.assertEquals((long)numRegions, (long)setOfStartKeys.size());
        }
    }

    private void validateSingleRegionServerAssignment(Connection connection, int numRegions, int numReplica) throws IOException {
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(connection);
        snapshot.initialize();
        Map regionToServerMap = snapshot.getRegionToRegionServerMap();
        Assert.assertEquals((long)regionToServerMap.size(), (long)(numRegions * numReplica + 1));
        Map serverToRegionMap = snapshot.getRegionServerToRegionMap();
        Assert.assertEquals((long)serverToRegionMap.keySet().size(), (long)1L);
        for (Map.Entry entry : serverToRegionMap.entrySet()) {
            if (((ServerName)entry.getKey()).equals((Object)TEST_UTIL.getHBaseCluster().getMaster().getServerName())) continue;
            Assert.assertEquals((long)((List)entry.getValue()).size(), (long)(numRegions * numReplica + 1));
        }
    }

    static {
        numSlaves = 2;
    }
}

