/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestMasterFailoverWithProcedures {
    private static final Log LOG = LogFactory.getLog(TestMasterFailoverWithProcedures.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
    }

    @Before
    public void setup() throws Exception {
        TestMasterFailoverWithProcedures.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2, 1);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Test(timeout=60000L)
    public void testWalRecoverLease() throws Exception {
        ProcedureStore masterStore = this.getMasterProcedureExecutor().getStore();
        Assert.assertTrue((String)"expected WALStore for this test", (boolean)(masterStore instanceof WALProcedureStore));
        HMaster firstMaster = UTIL.getHBaseCluster().getMaster();
        final CountDownLatch masterStoreAbort = new CountDownLatch(1);
        masterStore.registerListener(new ProcedureStore.ProcedureStoreListener(){

            public void abortProcess() {
                LOG.debug((Object)"Abort store of Master");
                masterStoreAbort.countDown();
            }
        });
        HMaster backupMaster3 = (HMaster)Mockito.mock(HMaster.class);
        ((HMaster)Mockito.doReturn((Object)firstMaster.getConfiguration()).when((Object)backupMaster3)).getConfiguration();
        ((HMaster)Mockito.doReturn((Object)true).when((Object)backupMaster3)).isActiveMaster();
        final WALProcedureStore backupStore3 = new WALProcedureStore(firstMaster.getConfiguration(), firstMaster.getMasterFileSystem().getFileSystem(), ((WALProcedureStore)masterStore).getLogDir(), (WALProcedureStore.LeaseRecovery)new MasterProcedureEnv.WALStoreLeaseRecovery(backupMaster3));
        final CountDownLatch backupStore3Abort = new CountDownLatch(1);
        backupStore3.registerListener(new ProcedureStore.ProcedureStoreListener(){

            public void abortProcess() {
                LOG.debug((Object)"Abort store of backupMaster3");
                backupStore3Abort.countDown();
                backupStore3.stop(true);
            }
        });
        backupStore3.start(1);
        backupStore3.recoverLease();
        HTableDescriptor htd = MasterProcedureTestingUtility.createHTD(TableName.valueOf((String)"mtb"), "f");
        HRegionInfo[] regions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)htd, (byte[][])null);
        LOG.debug((Object)"submit proc");
        this.getMasterProcedureExecutor().submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)this.getMasterProcedureExecutor().getEnvironment(), htd, regions));
        LOG.debug((Object)"wait master store abort");
        masterStoreAbort.await();
        LOG.debug((Object)"wait backup master to startup");
        TestMasterFailoverWithProcedures.waitBackupMaster(UTIL, firstMaster);
        Assert.assertEquals((Object)true, (Object)firstMaster.isStopped());
        LOG.debug((Object)"wait the store to abort");
        backupStore3.getStoreTracker().setDeleted(1L, false);
        backupStore3.delete(1L);
        backupStore3Abort.await();
    }

    @Test(timeout=60000L)
    public void testCreateWithFailover() throws Exception {
        this.testCreateWithFailoverAtStep(MasterProcedureProtos.CreateTableState.CREATE_TABLE_ASSIGN_REGIONS.ordinal());
    }

    private void testCreateWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testCreateWithFailoverAtStep" + step));
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)true);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)true);
        byte[][] splitKeys = null;
        HTableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f1", "f2");
        HRegionInfo[] regions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)htd, (byte[][])splitKeys);
        long procId = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step, MasterProcedureProtos.CreateTableState.values());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
    }

    @Test(timeout=60000L)
    public void testDeleteWithFailover() throws Exception {
        this.testDeleteWithFailoverAtStep(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_UNASSIGN_REGIONS.ordinal());
    }

    private void testDeleteWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testDeleteWithFailoverAtStep" + step));
        byte[][] splitKeys = null;
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        Path tableDir = FSUtils.getTableDir((Path)this.getRootDir(), (TableName)tableName);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)true);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step, MasterProcedureProtos.DeleteTableState.values());
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
    }

    @Test(timeout=90000L)
    public void testTruncateWithFailover() throws Exception {
        this.testTruncateWithFailoverAtStep(true, MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ADD_TO_META.ordinal());
    }

    private void testTruncateWithFailoverAtStep(boolean preserveSplits, int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testTruncateWithFailoverAtStep" + step));
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step, MasterProcedureProtos.TruncateTableState.values());
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)UTIL.getHBaseAdmin().getTableRegions(tableName).size());
        } else {
            regions = UTIL.getHBaseAdmin().getTableRegions(tableName).toArray(new HRegionInfo[1]);
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }

    @Test(timeout=60000L)
    public void testDisableTableWithFailover() throws Exception {
        this.testDisableTableWithFailoverAtStep(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_MARK_REGIONS_OFFLINE.ordinal());
    }

    private void testDisableTableWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testDisableTableWithFailoverAtStep" + step));
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step, MasterProcedureProtos.DisableTableState.values());
        MasterProcedureTestingUtility.validateTableIsDisabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    @Test(timeout=60000L)
    public void testEnableTableWithFailover() throws Exception {
        this.testEnableTableWithFailoverAtStep(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_MARK_REGIONS_ONLINE.ordinal());
    }

    private void testEnableTableWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testEnableTableWithFailoverAtStep" + step));
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step, MasterProcedureProtos.EnableTableState.values());
        MasterProcedureTestingUtility.validateTableIsEnabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    public static <TState> void testRecoveryAndDoubleExecution(HBaseTestingUtility testUtil, long procId, int lastStepBeforeFailover, TState[] states) throws Exception {
        ProcedureExecutor procExec = testUtil.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        for (int i = 0; i < lastStepBeforeFailover; ++i) {
            LOG.info((Object)("Restart " + i + " exec state: " + states[i]));
            ProcedureTestingUtility.assertProcNotYetCompleted((ProcedureExecutor)procExec, (long)procId);
            ProcedureTestingUtility.restart((ProcedureExecutor)procExec);
            ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        }
        ProcedureTestingUtility.assertProcNotYetCompleted((ProcedureExecutor)procExec, (long)procId);
        LOG.info((Object)"Trigger master failover");
        TestMasterFailoverWithProcedures.masterFailover(testUtil);
        procExec = testUtil.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed((ProcedureExecutor)procExec, (long)procId);
    }

    public static void masterFailover(HBaseTestingUtility testUtil) throws Exception {
        MiniHBaseCluster cluster = testUtil.getMiniHBaseCluster();
        HMaster oldMaster = cluster.getMaster();
        cluster.killMaster(cluster.getMaster().getServerName());
        TestMasterFailoverWithProcedures.waitBackupMaster(testUtil, oldMaster);
    }

    public static void waitBackupMaster(HBaseTestingUtility testUtil, HMaster oldMaster) throws Exception {
        MiniHBaseCluster cluster = testUtil.getMiniHBaseCluster();
        HMaster newMaster = cluster.getMaster();
        while (newMaster == null || newMaster == oldMaster) {
            Thread.sleep(250L);
            newMaster = cluster.getMaster();
        }
        while (!newMaster.isActiveMaster() || !newMaster.isInitialized()) {
            Thread.sleep(250L);
        }
    }

    private MasterProcedureEnv getMasterProcedureEnv() {
        return (MasterProcedureEnv)this.getMasterProcedureExecutor().getEnvironment();
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private FileSystem getFileSystem() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
    }

    private Path getRootDir() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
    }

    private Path getTempDir() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getTempDir();
    }
}

