/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ModifyColumnFamilyProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureResult;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestModifyColumnFamilyProcedure {
    private static final Log LOG = LogFactory.getLog(TestModifyColumnFamilyProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestModifyColumnFamilyProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L)
    public void testModifyColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)"testModifyColumnFamily");
        String cf1 = "cf1";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf1");
        int oldBlockSize = columnDescriptor.getBlocksize();
        int newBlockSize = 3 * oldBlockSize;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "f2");
        columnDescriptor.setBlocksize(newBlockSize);
        long procId1 = procExec.submitProcedure((Procedure)new ModifyColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateColumnFamilyModification(UTIL.getHBaseCluster().getMaster(), tableName, "cf1", columnDescriptor);
        UTIL.getHBaseAdmin().disableTable(tableName);
        columnDescriptor.setBlocksize(newBlockSize * 2);
        long procId2 = procExec.submitProcedure((Procedure)new ModifyColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId2);
        MasterProcedureTestingUtility.validateColumnFamilyModification(UTIL.getHBaseCluster().getMaster(), tableName, "cf1", columnDescriptor);
    }

    @Test(timeout=60000L)
    public void testModifyNonExistingColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)"testModifyExistingColumnFamily");
        String cf2 = "cf2";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf2");
        int oldBlockSize = columnDescriptor.getBlocksize();
        int newBlockSize = 2 * oldBlockSize;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1");
        columnDescriptor.setBlocksize(newBlockSize);
        long procId1 = procExec.submitProcedure((Procedure)new ModifyColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureResult result = procExec.getResult(procId1);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Modify failed with exception: " + result.getException()));
        Assert.assertTrue((boolean)(result.getException().getCause() instanceof InvalidFamilyOperationException));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionOffline");
        String cf3 = "cf3";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf3");
        int oldBlockSize = columnDescriptor.getBlocksize();
        int newBlockSize = 4 * oldBlockSize;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "cf3");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        columnDescriptor.setBlocksize(newBlockSize);
        long procId = procExec.submitProcedure((Procedure)new ModifyColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        int numberOfSteps = MasterProcedureProtos.ModifyColumnFamilyState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.ModifyColumnFamilyState.values());
        MasterProcedureTestingUtility.validateColumnFamilyModification(UTIL.getHBaseCluster().getMaster(), tableName, "cf3", columnDescriptor);
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionOnline");
        String cf4 = "cf4";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf4");
        int oldBlockSize = columnDescriptor.getBlocksize();
        int newBlockSize = 4 * oldBlockSize;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "cf4");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        columnDescriptor.setBlocksize(newBlockSize);
        long procId = procExec.submitProcedure((Procedure)new ModifyColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        int numberOfSteps = MasterProcedureProtos.ModifyColumnFamilyState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.ModifyColumnFamilyState.values());
        MasterProcedureTestingUtility.validateColumnFamilyModification(UTIL.getHBaseCluster().getMaster(), tableName, "cf4", columnDescriptor);
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRollbackAndDoubleExecution");
        String cf3 = "cf3";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf3");
        int oldBlockSize = columnDescriptor.getBlocksize();
        int newBlockSize = 4 * oldBlockSize;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "cf3");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        columnDescriptor.setBlocksize(newBlockSize);
        long procId = procExec.submitProcedure((Procedure)new ModifyColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        int numberOfSteps = MasterProcedureProtos.ModifyColumnFamilyState.values().length - 2;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.ModifyColumnFamilyState.values());
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

