/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRateLimiter {
    @Test
    public void testWaitIntervalTimeUnitSeconds() {
        this.testWaitInterval(TimeUnit.SECONDS, 10L, 100L);
    }

    @Test
    public void testWaitIntervalTimeUnitMinutes() {
        this.testWaitInterval(TimeUnit.MINUTES, 10L, 6000L);
    }

    @Test
    public void testWaitIntervalTimeUnitHours() {
        this.testWaitInterval(TimeUnit.HOURS, 10L, 360000L);
    }

    @Test
    public void testWaitIntervalTimeUnitDays() {
        this.testWaitInterval(TimeUnit.DAYS, 10L, 8640000L);
    }

    private void testWaitInterval(TimeUnit timeUnit, long limit, long expectedWaitInterval) {
        long waitInterval;
        RateLimiter limiter = new RateLimiter();
        limiter.set(limit, timeUnit);
        long nowTs = 0L;
        long lastTs = 0L;
        int i = 0;
        while ((long)i < limit - 1L) {
            Assert.assertTrue((boolean)limiter.canExecute(nowTs, lastTs));
            limiter.consume();
            waitInterval = limiter.waitInterval();
            Assert.assertEquals((long)0L, (long)waitInterval);
            ++i;
        }
        i = 0;
        while ((long)i < limit * 4L) {
            Assert.assertTrue((boolean)limiter.canExecute(nowTs, lastTs));
            Assert.assertEquals((long)0L, (long)limiter.waitInterval());
            limiter.consume();
            lastTs = nowTs;
            waitInterval = limiter.waitInterval();
            Assert.assertEquals((long)expectedWaitInterval, (long)waitInterval);
            Assert.assertFalse((boolean)limiter.canExecute((nowTs += waitInterval) - 500L, lastTs));
            ++i;
        }
    }

    @Test
    public void testOverconsumption() {
        RateLimiter limiter = new RateLimiter();
        limiter.set(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)limiter.canExecute(0L, 0L));
        limiter.consume(20L);
        Assert.assertEquals((long)1100L, (long)limiter.waitInterval());
        Assert.assertFalse((boolean)limiter.canExecute(1000L, 0L));
        Assert.assertEquals((long)100L, (long)limiter.waitInterval());
        Assert.assertTrue((boolean)limiter.canExecute(1100L, 0L));
        Assert.assertEquals((long)0L, (long)limiter.waitInterval());
    }
}

