/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.ZkOpenRegionCoordination;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mortbay.log.Log;

@Category(value={MediumTests.class})
public class TestRegionServerNoMaster {
    private static final int NB_SERVERS = 1;
    private static HTable table;
    private static final byte[] row;
    private static HRegionInfo hri;
    private static byte[] regionName;
    private static final HBaseTestingUtility HTU;

    @BeforeClass
    public static void before() throws Exception {
        HTU.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        HTU.startMiniCluster(1);
        TableName tableName = TableName.valueOf((String)TestRegionServerNoMaster.class.getSimpleName());
        table = HTU.createTable(tableName, HConstants.CATALOG_FAMILY);
        Put p = new Put(row);
        p.add(HConstants.CATALOG_FAMILY, row, row);
        table.put(p);
        hri = table.getRegionLocation(row, false).getRegionInfo();
        regionName = hri.getRegionName();
        TestRegionServerNoMaster.stopMasterAndAssignMeta(HTU);
    }

    public static void stopMasterAndAssignMeta(HBaseTestingUtility HTU) throws KeeperException.NodeExistsException, KeeperException, IOException, InterruptedException {
        HTU.getHBaseCluster().getMaster().stopMaster();
        Log.info((String)"Waiting until master thread exits");
        while (HTU.getHBaseCluster().getMasterThread() != null && HTU.getHBaseCluster().getMasterThread().isAlive()) {
            Threads.sleep((long)100L);
        }
    }

    public static void flushRegion(HBaseTestingUtility HTU, HRegionInfo regionInfo) throws IOException {
        for (JVMClusterUtil.RegionServerThread rst : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
            Region region = rst.getRegionServer().getRegionByEncodedName(regionInfo.getEncodedName());
            if (region == null) continue;
            region.flush(true);
            return;
        }
        throw new IOException("Region to flush cannot be found");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        table.close();
        HTU.shutdownMiniCluster();
    }

    @After
    public void after() throws Exception {
        ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri);
    }

    private static HRegionServer getRS() {
        return HTU.getHBaseCluster().getLiveRegionServerThreads().get(0).getRegionServer();
    }

    public static void openRegion(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        ZKAssign.createNodeOffline((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)rs.getServerName());
        AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)rs.getServerName(), (HRegionInfo)hri, (int)0, null, null);
        AdminProtos.OpenRegionResponse responseOpen = rs.rpcServices.openRegion(null, orr);
        Assert.assertTrue((responseOpen.getOpeningStateCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseOpen.getOpeningState(0).equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED));
        TestRegionServerNoMaster.checkRegionIsOpened(HTU, rs, hri);
    }

    public static void checkRegionIsOpened(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        while (!rs.getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((boolean)rs.getRegion(hri.getRegionName()).isAvailable());
        Assert.assertTrue((boolean)ZKAssign.deleteOpenedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), (ServerName)rs.getServerName()));
    }

    public static void closeRegion(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)rs.getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)rs.getServerName(), (String)hri.getEncodedName(), (boolean)true);
        AdminProtos.CloseRegionResponse responseClose = rs.rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, rs, hri);
        ZKAssign.deleteClosedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), null);
    }

    public static void checkRegionIsClosed(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        while (!rs.getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        boolean exception = false;
        try {
            while (rs.getRegion(hri.getRegionName()).isAvailable()) {
                Thread.sleep(10L);
            }
        }
        catch (NotServingRegionException expected) {
            exception = true;
        }
        assert (exception);
    }

    private void closeRegionNoZK() throws Exception {
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)false);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testCloseByRegionServer() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testCloseByMasterWithoutZNode() throws Exception {
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)true);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        while (!TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((String)"The close should have failed", (boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
    }

    @Test(timeout=60000L)
    public void testOpenCloseByMasterWithZNode() throws Exception {
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)true);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        ZKAssign.deleteClosedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testMultipleOpen() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        for (int i = 0; i < 10; ++i) {
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (HRegionInfo)hri, (int)0, null, null);
            AdminProtos.OpenRegionResponse responseOpen = TestRegionServerNoMaster.getRS().rpcServices.openRegion(null, orr);
            Assert.assertTrue((responseOpen.getOpeningStateCount() == 1 ? 1 : 0) != 0);
            AdminProtos.OpenRegionResponse.RegionOpeningState ors = responseOpen.getOpeningState(0);
            Assert.assertTrue((String)("request " + i + " failed"), (ors.equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED) || ors.equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.ALREADY_OPENED) ? 1 : 0) != 0);
        }
        TestRegionServerNoMaster.checkRegionIsOpened(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenClosingRegion() throws Exception {
        Assert.assertTrue((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        try {
            ServerName sn = TestRegionServerNoMaster.getRS().getServerName();
            MetaTableAccessor.updateRegionLocation((Connection)TestRegionServerNoMaster.getRS().getConnection(), (HRegionInfo)hri, (ServerName)sn, (long)TestRegionServerNoMaster.getRS().getRegion(regionName).getOpenSeqNum());
            TestRegionServerNoMaster.getRS().regionsInTransitionInRS.put(hri.getEncodedNameAsBytes(), Boolean.FALSE);
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)sn, (HRegionInfo)hri, (int)0, null, null);
            TestRegionServerNoMaster.getRS().rpcServices.openRegion(null, orr);
            Assert.fail((String)"The closing region should not be opened");
        }
        catch (ServiceException se) {
            Assert.assertTrue((String)"The region should be already in transition", (boolean)(se.getCause() instanceof RegionAlreadyInTransitionException));
        }
        finally {
            TestRegionServerNoMaster.getRS().regionsInTransitionInRS.remove(hri.getEncodedNameAsBytes());
        }
    }

    @Test(timeout=60000L)
    public void testMultipleCloseFromMaster() throws Exception {
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        for (int i = 0; i < 10; ++i) {
            AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (int)0, null, (boolean)true);
            try {
                AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
                Assert.assertEquals((String)"The first request should succeeds", (long)0L, (long)i);
                Assert.assertTrue((String)("request " + i + " failed"), (responseClose.getClosed() || responseClose.hasClosed() ? 1 : 0) != 0);
                continue;
            }
            catch (ServiceException se) {
                Assert.assertTrue((String)"The next queries should throw an exception.", (i > 0 ? 1 : 0) != 0);
            }
        }
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        Assert.assertTrue((boolean)ZKAssign.deleteClosedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), (ServerName)TestRegionServerNoMaster.getRS().getServerName()));
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testCancelOpeningWithoutZK() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)false);
        try {
            TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
            Assert.assertTrue((boolean)false);
        }
        catch (ServiceException expected) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.FALSE, TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        HTableDescriptor htd = TestRegionServerNoMaster.getRS().tableDescriptors.get(hri.getTable());
        ZkCoordinatedStateManager csm = new ZkCoordinatedStateManager();
        csm.initialize((Server)TestRegionServerNoMaster.getRS());
        csm.start();
        ZkOpenRegionCoordination.ZkOpenRegionDetails zkCrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
        zkCrd.setServerName(TestRegionServerNoMaster.getRS().getServerName());
        zkCrd.setVersionOfOfflineNode(0);
        TestRegionServerNoMaster.getRS().service.submit((EventHandler)new OpenRegionHandler((Server)TestRegionServerNoMaster.getRS(), (RegionServerServices)TestRegionServerNoMaster.getRS(), hri, htd, csm.getOpenRegionCoordination(), (OpenRegionCoordination.OpenRegionDetails)zkCrd));
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        Assert.assertTrue((boolean)ZKAssign.deleteNode((ZooKeeperWatcher)TestRegionServerNoMaster.getRS().getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REGION_FAILED_OPEN, (int)1));
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testCancelOpeningWithZK() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)false);
        try {
            TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
            Assert.assertTrue((boolean)false);
        }
        catch (ServiceException expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof RegionAlreadyInTransitionException));
        }
        Assert.assertTrue((boolean)ZKAssign.deleteNode((ZooKeeperWatcher)TestRegionServerNoMaster.getRS().getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.M_ZK_REGION_CLOSING, (int)0));
        Assert.assertEquals((Object)Boolean.FALSE, TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        HTableDescriptor htd = TestRegionServerNoMaster.getRS().tableDescriptors.get(hri.getTable());
        ZkCoordinatedStateManager csm = new ZkCoordinatedStateManager();
        csm.initialize((Server)TestRegionServerNoMaster.getRS());
        csm.start();
        ZkOpenRegionCoordination.ZkOpenRegionDetails zkCrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
        zkCrd.setServerName(TestRegionServerNoMaster.getRS().getServerName());
        zkCrd.setVersionOfOfflineNode(0);
        TestRegionServerNoMaster.getRS().service.submit((EventHandler)new OpenRegionHandler((Server)TestRegionServerNoMaster.getRS(), (RegionServerServices)TestRegionServerNoMaster.getRS(), hri, htd, csm.getOpenRegionCoordination(), (OpenRegionCoordination.OpenRegionDetails)zkCrd));
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        Assert.assertEquals((long)-1L, (long)ZKAssign.getVersion((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri));
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenCloseRegionRPCIntendedForPreviousServer() throws Exception {
        Assert.assertTrue((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        ServerName sn = TestRegionServerNoMaster.getRS().getServerName();
        ServerName earlierServerName = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)1L);
        try {
            AdminProtos.CloseRegionRequest request = RequestConverter.buildCloseRegionRequest((ServerName)earlierServerName, (byte[])regionName, (boolean)true);
            TestRegionServerNoMaster.getRS().getRSRpcServices().closeRegion(null, request);
            Assert.fail((String)"The closeRegion should have been rejected");
        }
        catch (ServiceException se) {
            Assert.assertTrue((boolean)(se.getCause() instanceof IOException));
            Assert.assertTrue((boolean)se.getCause().getMessage().contains("This RPC was intended for a different server"));
        }
        this.closeRegionNoZK();
        try {
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)earlierServerName, (HRegionInfo)hri, (int)0, null, null);
            TestRegionServerNoMaster.getRS().getRSRpcServices().openRegion(null, orr);
            Assert.fail((String)"The openRegion should have been rejected");
        }
        catch (ServiceException se) {
            Assert.assertTrue((boolean)(se.getCause() instanceof IOException));
            Assert.assertTrue((boolean)se.getCause().getMessage().contains("This RPC was intended for a different server"));
        }
        finally {
            TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
        }
    }

    static {
        row = "ee".getBytes();
        HTU = new HBaseTestingUtility();
    }
}

