/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RowTooBigException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRowTooBig {
    private static final HBaseTestingUtility HTU = HBaseTestingUtility.createLocalHTU();
    private static final HTableDescriptor TEST_HTD = new HTableDescriptor(TableName.valueOf((String)TestRowTooBig.class.getSimpleName()));

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster();
        HTU.getConfiguration().setLong("hbase.table.max.rowsize", 0xA00000L);
    }

    @AfterClass
    public static void after() throws Exception {
        HTU.shutdownMiniCluster();
    }

    @Test(expected=RowTooBigException.class)
    public void testScannersSeekOnFewLargeCells() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        HTableDescriptor htd = TEST_HTD;
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        HColumnDescriptor hcd = new HColumnDescriptor(fam1);
        if (htd.hasFamily(hcd.getName())) {
            htd.modifyFamily(hcd);
        } else {
            htd.addFamily(hcd);
        }
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_END_ROW, HConstants.EMPTY_END_ROW);
        HRegion region = HTU.createLocalHRegion(hri, htd);
        for (int i = 0; i < 5; ++i) {
            Put put = new Put(row1);
            put.add(fam1, Bytes.toBytes((String)("col_" + i)), new byte[0x500000]);
            region.put(put);
            region.flush(true);
        }
        Get get = new Get(row1);
        region.get(get);
    }

    @Test(expected=RowTooBigException.class)
    public void testScanAcrossManySmallColumns() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        HTableDescriptor htd = TEST_HTD;
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        HColumnDescriptor hcd = new HColumnDescriptor(fam1);
        if (htd.hasFamily(hcd.getName())) {
            htd.modifyFamily(hcd);
        } else {
            htd.addFamily(hcd);
        }
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_END_ROW, HConstants.EMPTY_END_ROW);
        HRegion region = HTU.createLocalHRegion(hri, htd);
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(row1);
            for (int j = 0; j < 100000; ++j) {
                put.add(fam1, Bytes.toBytes((String)("col_" + i + "_" + j)), new byte[10]);
            }
            region.put(put);
            region.flush(true);
        }
        region.compact(true);
        Get get = new Get(row1);
        region.get(get);
    }
}

