/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.security.Key;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hadoop.hbase.io.crypto.DefaultCipherProvider;
import org.apache.hadoop.hbase.io.crypto.KeyProvider;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestEncryptionTest {
    @Test
    public void testTestKeyProvider() {
        Configuration conf = HBaseConfiguration.create();
        try {
            conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
            EncryptionTest.testKeyProvider((Configuration)conf);
        }
        catch (Exception e) {
            Assert.fail((String)"Instantiation of test key provider should have passed");
        }
        try {
            conf.set("hbase.crypto.keyprovider", FailingKeyProvider.class.getName());
            EncryptionTest.testKeyProvider((Configuration)conf);
            Assert.fail((String)"Instantiation of bad test key provider should have failed check");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTestCipherProvider() {
        Configuration conf = HBaseConfiguration.create();
        try {
            conf.set("hbase.crypto.cipherprovider", DefaultCipherProvider.class.getName());
            EncryptionTest.testCipherProvider((Configuration)conf);
        }
        catch (Exception e) {
            Assert.fail((String)"Instantiation of test cipher provider should have passed");
        }
        try {
            conf.set("hbase.crypto.cipherprovider", FailingCipherProvider.class.getName());
            EncryptionTest.testCipherProvider((Configuration)conf);
            Assert.fail((String)"Instantiation of bad test cipher provider should have failed check");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTestCipher() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        try {
            EncryptionTest.testEncryption((Configuration)conf, (String)algorithm, null);
        }
        catch (Exception e) {
            Assert.fail((String)("Test for cipher " + algorithm + " should have succeeded"));
        }
        try {
            EncryptionTest.testEncryption((Configuration)conf, (String)"foobar", null);
            Assert.fail((String)"Test for bogus cipher should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class FailingCipherProvider
    implements CipherProvider {
        public FailingCipherProvider() {
            throw new RuntimeException("BAD!");
        }

        public Configuration getConf() {
            return null;
        }

        public void setConf(Configuration conf) {
        }

        public String getName() {
            return null;
        }

        public String[] getSupportedCiphers() {
            return null;
        }

        public Cipher getCipher(String name) {
            return null;
        }
    }

    public static class FailingKeyProvider
    implements KeyProvider {
        public void init(String params) {
            throw new RuntimeException("BAD!");
        }

        public Key getKey(String alias) {
            return null;
        }

        public Key[] getKeys(String[] aliases) {
            return null;
        }
    }
}

