/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZKMulti {
    private static final Log LOG = LogFactory.getLog(TestZKMulti.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher zkw = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.zookeeper.useMulti", true);
        Abortable abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }

            public boolean isAborted() {
                return false;
            }
        };
        zkw = new ZooKeeperWatcher(conf, "TestZKMulti", abortable, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test(timeout=60000L)
    public void testSimpleMulti() throws Exception {
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, null, (boolean)false);
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, new LinkedList(), (boolean)false);
        String path = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testSimpleMulti");
        LinkedList<ZKUtil.ZKUtilOp> singleCreate = new LinkedList<ZKUtil.ZKUtilOp>();
        singleCreate.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path, (byte[])new byte[0]));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, singleCreate, (boolean)false);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)path) != -1 ? 1 : 0) != 0);
        LinkedList<ZKUtil.ZKUtilOp> singleSetData = new LinkedList<ZKUtil.ZKUtilOp>();
        byte[] data = Bytes.toBytes((String)"foobar");
        singleSetData.add(ZKUtil.ZKUtilOp.setData((String)path, (byte[])data));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, singleSetData, (boolean)false);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path), (byte[])data));
        LinkedList<ZKUtil.ZKUtilOp> singleDelete = new LinkedList<ZKUtil.ZKUtilOp>();
        singleDelete.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, singleDelete, (boolean)false);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)path) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testComplexMulti() throws Exception {
        String path1 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testComplexMulti1");
        String path2 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testComplexMulti2");
        String path3 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testComplexMulti3");
        String path4 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testComplexMulti4");
        String path5 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testComplexMulti5");
        String path6 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testComplexMulti6");
        LinkedList<ZKUtil.ZKUtilOp> create4Nodes = new LinkedList<ZKUtil.ZKUtilOp>();
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path1, (byte[])Bytes.toBytes((String)path1)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path2, (byte[])Bytes.toBytes((String)path2)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path3, (byte[])Bytes.toBytes((String)path3)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path4, (byte[])Bytes.toBytes((String)path4)));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, create4Nodes, (boolean)false);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path1), (byte[])Bytes.toBytes((String)path1)));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path2), (byte[])Bytes.toBytes((String)path2)));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path3), (byte[])Bytes.toBytes((String)path3)));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path4), (byte[])Bytes.toBytes((String)path4)));
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.setData((String)path1, (byte[])Bytes.add((byte[])Bytes.toBytes((String)path1), (byte[])Bytes.toBytes((String)path1))));
        ops.add(ZKUtil.ZKUtilOp.setData((String)path2, (byte[])Bytes.add((byte[])Bytes.toBytes((String)path2), (byte[])Bytes.toBytes((String)path2))));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path3));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path4));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path5, (byte[])Bytes.toBytes((String)path5)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path6, (byte[])Bytes.toBytes((String)path6)));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path1), (byte[])Bytes.add((byte[])Bytes.toBytes((String)path1), (byte[])Bytes.toBytes((String)path1))));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path2), (byte[])Bytes.add((byte[])Bytes.toBytes((String)path2), (byte[])Bytes.toBytes((String)path2))));
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)path3) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)path4) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path5), (byte[])Bytes.toBytes((String)path5)));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path6), (byte[])Bytes.toBytes((String)path6)));
    }

    @Test(timeout=60000L)
    public void testSingleFailure() throws Exception {
        boolean caughtNoNode = false;
        String path = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testSingleFailureZ");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path));
        try {
            ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        caughtNoNode = false;
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData((String)path, (byte[])Bytes.toBytes((String)path)));
        try {
            ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        boolean caughtNodeExists = false;
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path, (byte[])Bytes.toBytes((String)path)));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        try {
            ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NodeExistsException nee) {
            caughtNodeExists = true;
        }
        Assert.assertTrue((boolean)caughtNodeExists);
    }

    @Test(timeout=60000L)
    public void testSingleFailureInMulti() throws Exception {
        String pathA = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testSingleFailureInMultiA");
        String pathB = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testSingleFailureInMultiB");
        String pathC = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testSingleFailureInMultiC");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathA, (byte[])Bytes.toBytes((String)pathA)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathB, (byte[])Bytes.toBytes((String)pathB)));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)pathC));
        boolean caughtNoNode = false;
        try {
            ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathA) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathB) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathC) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMultiFailure() throws Exception {
        String pathX = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testMultiFailureX");
        String pathY = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testMultiFailureY");
        String pathZ = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testMultiFailureZ");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathX)));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        String pathV = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testMultiFailureV");
        String pathW = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"testMultiFailureW");
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathX)));
        ops.add(ZKUtil.ZKUtilOp.setData((String)pathY, (byte[])Bytes.toBytes((String)pathY)));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)pathZ));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathV)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathW)));
        boolean caughtNodeExists = false;
        try {
            ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NodeExistsException nee) {
            caughtNodeExists = true;
        }
        Assert.assertTrue((boolean)caughtNodeExists);
        Assert.assertFalse((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathX) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathZ) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathW) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathV) == -1 ? 1 : 0) != 0);
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData((String)pathY, (byte[])Bytes.toBytes((String)pathY)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathX)));
        boolean caughtNoNode = false;
        try {
            ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        Assert.assertFalse((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathX) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathZ) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathW) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)pathV) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testRunSequentialOnMultiFailure() throws Exception {
        String path1 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"runSequential1");
        String path2 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"runSequential2");
        String path3 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"runSequential3");
        String path4 = ZKUtil.joinZNode((String)TestZKMulti.zkw.baseZNode, (String)"runSequential4");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path1, (byte[])Bytes.toBytes((String)path1)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path2, (byte[])Bytes.toBytes((String)path2)));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)false);
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData((String)path1, (byte[])Bytes.add((byte[])Bytes.toBytes((String)path1), (byte[])Bytes.toBytes((String)path1))));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path2));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path3));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path4, (byte[])Bytes.add((byte[])Bytes.toBytes((String)path4), (byte[])Bytes.toBytes((String)path4))));
        ZKUtil.multiOrSequential((ZooKeeperWatcher)zkw, ops, (boolean)true);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)path1), (byte[])Bytes.add((byte[])Bytes.toBytes((String)path1), (byte[])Bytes.toBytes((String)path1))));
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)path2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)path3) == -1 ? 1 : 0) != 0);
        Assert.assertFalse((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)path4) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testdeleteChildrenRecursivelyMulti() throws Exception {
        String parentZNode = "/testRootMulti";
        this.createZNodeTree(parentZNode);
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential((ZooKeeperWatcher)zkw, (boolean)true, (String[])new String[]{parentZNode});
        Assert.assertTrue((String)"Wrongly deleted parent znode!", (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)parentZNode) > -1 ? 1 : 0) != 0);
        List children = zkw.getRecoverableZooKeeper().getChildren(parentZNode, false);
        Assert.assertTrue((String)"Failed to delete child znodes!", (0 == children.size() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testdeleteChildrenRecursivelySequential() throws Exception {
        String parentZNode = "/testRootSeq";
        this.createZNodeTree(parentZNode);
        boolean useMulti = zkw.getConfiguration().getBoolean("hbase.zookeeper.useMulti", false);
        zkw.getConfiguration().setBoolean("hbase.zookeeper.useMulti", false);
        try {
            ZKUtil.deleteChildrenRecursivelyMultiOrSequential((ZooKeeperWatcher)zkw, (boolean)true, (String[])new String[]{parentZNode});
            Assert.assertTrue((String)"Wrongly deleted parent znode!", (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)parentZNode) > -1 ? 1 : 0) != 0);
            List children = zkw.getRecoverableZooKeeper().getChildren(parentZNode, false);
            Assert.assertTrue((String)"Failed to delete child znodes!", (0 == children.size() ? 1 : 0) != 0);
        }
        finally {
            zkw.getConfiguration().setBoolean("hbase.zookeeper.useMulti", useMulti);
        }
    }

    private void createZNodeTree(String rootZNode) throws KeeperException, InterruptedException {
        ArrayList<Op> opList = new ArrayList<Op>();
        opList.add(Op.create((String)rootZNode, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        String parentZNode = rootZNode;
        for (int level = 0; level < 10; ++level) {
            parentZNode = parentZNode + "/" + level;
            opList.add(Op.create((String)parentZNode, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            for (int elements = 0; elements < level; ++elements) {
                opList.add(Op.create((String)(parentZNode + "/" + elements), (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            }
        }
        zkw.getRecoverableZooKeeper().multi(opList);
    }
}

