/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureResult;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestModifyTableProcedure {
    private static final Log LOG = LogFactory.getLog(TestModifyTableProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestModifyTableProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L)
    public void testModifyTable() throws Exception {
        TableName tableName = TableName.valueOf((String)"testModifyTable");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf");
        UTIL.getHBaseAdmin().disableTable(tableName);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        long newMaxFileSize = htd.getMaxFileSize() * 2L;
        htd.setMaxFileSize(newMaxFileSize);
        htd.setRegionReplication(3);
        long procId1 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        ProcedureTestingUtility.assertProcNotFailed((ProcedureResult)procExec.getResult(procId1));
        HTableDescriptor currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)newMaxFileSize, (long)currentHtd.getMaxFileSize());
        boolean newReadOnlyOption = !htd.isReadOnly();
        long newMemStoreFlushSize = htd.getMemStoreFlushSize() * 2L;
        htd.setReadOnly(newReadOnlyOption);
        htd.setMemStoreFlushSize(newMemStoreFlushSize);
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        ProcedureTestingUtility.assertProcNotFailed((ProcedureResult)procExec.getResult(procId2));
        currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((Object)newReadOnlyOption, (Object)currentHtd.isReadOnly());
        Assert.assertEquals((long)newMemStoreFlushSize, (long)currentHtd.getMemStoreFlushSize());
    }

    @Test(timeout=60000L)
    public void testModifyTableAddCF() throws Exception {
        TableName tableName = TableName.valueOf((String)"testModifyTableAddCF");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1");
        HTableDescriptor currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)1L, (long)currentHtd.getFamiliesKeys().size());
        String cf2 = "cf2";
        HTableDescriptor htd = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        htd.addFamily(new HColumnDescriptor(cf2));
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        ProcedureTestingUtility.assertProcNotFailed((ProcedureResult)procExec.getResult(procId));
        currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertTrue((boolean)currentHtd.hasFamily(cf2.getBytes()));
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        String cf3 = "cf3";
        HTableDescriptor htd2 = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        htd2.addFamily(new HColumnDescriptor(cf3));
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd2));
        ProcedureTestingUtility.assertProcNotFailed((ProcedureResult)procExec.getResult(procId2));
        currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertTrue((boolean)currentHtd.hasFamily(cf3.getBytes()));
        Assert.assertEquals((long)3L, (long)currentHtd.getFamiliesKeys().size());
    }

    @Test(timeout=60000L)
    public void testModifyTableDeleteCF() throws Exception {
        TableName tableName = TableName.valueOf((String)"testModifyTableAddCF");
        String cf2 = "cf2";
        String cf3 = "cf3";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf2", "cf3");
        HTableDescriptor currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)3L, (long)currentHtd.getFamiliesKeys().size());
        HTableDescriptor htd = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        htd.removeFamily("cf2".getBytes());
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        ProcedureTestingUtility.assertProcNotFailed((ProcedureResult)procExec.getResult(procId));
        currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertFalse((boolean)currentHtd.hasFamily("cf2".getBytes()));
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        HTableDescriptor htd2 = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        htd2.removeFamily("cf3".getBytes());
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd2));
        ProcedureTestingUtility.assertProcNotFailed((ProcedureResult)procExec.getResult(procId2));
        currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)1L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertFalse((boolean)currentHtd.hasFamily("cf3".getBytes()));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionOffline");
        String cf2 = "cf2";
        String cf3 = "cf3";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf3");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor("cf2"));
        htd.removeFamily("cf3".getBytes());
        htd.setRegionReplication(3);
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        int numberOfSteps = MasterProcedureProtos.ModifyTableState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.ModifyTableState.values());
        HTableDescriptor currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((Object)newCompactionEnableOption, (Object)currentHtd.isCompactionEnabled());
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, false, "cf1", "cf2");
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionOnline");
        String cf2 = "cf2";
        String cf3 = "cf3";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf3");
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor("cf2"));
        htd.removeFamily("cf3".getBytes());
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        int numberOfSteps = MasterProcedureProtos.ModifyTableState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.ModifyTableState.values());
        HTableDescriptor currentHtd = UTIL.getHBaseAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((Object)newCompactionEnableOption, (Object)currentHtd.isCompactionEnabled());
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertTrue((boolean)currentHtd.hasFamily("cf2".getBytes()));
        Assert.assertFalse((boolean)currentHtd.hasFamily("cf3".getBytes()));
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "cf1", "cf2");
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRollbackAndDoubleExecution");
        String familyName = "cf2";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1");
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor("cf2"));
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        int numberOfSteps = MasterProcedureProtos.ModifyTableState.values().length - 4;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.ModifyTableState.values());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "cf1");
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRollbackAndDoubleExecution");
        String familyName = "cf2";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor("cf2"));
        htd.setRegionReplication(3);
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        int numberOfSteps = MasterProcedureProtos.ModifyTableState.values().length - 4;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.ModifyTableState.values());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "cf1");
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecutionAfterPONR() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRollbackAndDoubleExecutionAfterPONR");
        String familyToAddName = "cf2";
        String familyToRemove = "cf1";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getHBaseAdmin().getTableDescriptor(tableName));
        htd.setCompactionEnabled(!htd.isCompactionEnabled());
        htd.addFamily(new HColumnDescriptor("cf2"));
        htd.removeFamily("cf1".getBytes());
        htd.setRegionReplication(3);
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        int numberOfSteps = 5;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecutionAfterPONR(procExec, procId, numberOfSteps, MasterProcedureProtos.ModifyTableState.values());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, false, "cf2");
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

