/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Supplier;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class ThreadLocalObjectPool<E extends AutoCloseable> {
    private final Supplier<E> objectFactory;
    private final ThreadLocal<Queue<Reusable<E>>> bag = ThreadLocal.withInitial(LinkedList::new);
    private final int poolSize;

    public ThreadLocalObjectPool(Supplier<E> objectFactory, int poolSize) {
        this.objectFactory = objectFactory;
        this.poolSize = poolSize;
    }

    public Reusable<E> borrow() {
        Reusable pooled = this.bag.get().poll();
        return pooled != null ? pooled : new Reusable(this, (AutoCloseable)this.objectFactory.get(), null);
    }

    int bagSize() {
        return this.bag.get().size();
    }

    public static class Reusable<T extends AutoCloseable> {
        private final ThreadLocalObjectPool<T> pool;
        private final T object;

        private Reusable(ThreadLocalObjectPool<T> pool, T object) {
            this.pool = pool;
            this.object = object;
        }

        public T object() {
            return this.object;
        }

        public void recycle() {
            Queue bag = (Queue)((ThreadLocalObjectPool)this.pool).bag.get();
            if (bag.size() < ((ThreadLocalObjectPool)this.pool).poolSize) {
                bag.add(this);
            } else {
                U.closeQuiet(this.object);
            }
        }

        /* synthetic */ Reusable(ThreadLocalObjectPool x0, AutoCloseable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

