/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.javax.annotation.Nullable;

public class Metric {
    private final Set<Dimension> dimensions;
    private final String metricName;
    private final String namespace;

    public Metric(String metricName, String namespace, @Nullable Set<Dimension> dimensions) {
        this.dimensions = dimensions == null ? Sets.newLinkedHashSet() : dimensions;
        this.metricName = metricName;
        this.namespace = namespace;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public Set<Dimension> getDimensions() {
        return this.dimensions;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dimensions, this.metricName, this.namespace});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metric other = (Metric)obj;
        return Objects.equal(this.dimensions, other.dimensions) && Objects.equal((Object)this.metricName, (Object)other.metricName) && Objects.equal((Object)this.namespace, (Object)other.namespace);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("namespace", (Object)this.namespace).add("metricName", (Object)this.metricName).add("dimension", this.dimensions).toString();
    }
}

