/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.binders;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.auth.config.CredentialType;
import org.jclouds.openstack.keystone.auth.config.CredentialTypes;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindAuthToJsonPayload
extends BindToJsonPayload
implements MapBinder {
    @Inject
    public BindAuthToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    protected TenantOrDomainAndCredentials<?> findCredentialsInArgs(GeneratedHttpRequest gRequest) {
        Optional credentials = Iterables.tryFind((Iterable)gRequest.getInvocation().getArgs(), (Predicate)Predicates.instanceOf(TenantOrDomainAndCredentials.class));
        return credentials.isPresent() ? (TenantOrDomainAndCredentials)credentials.get() : null;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        TenantOrDomainAndCredentials<?> credentials = this.findCredentialsInArgs(gRequest);
        if (credentials != null) {
            CredentialType credentialType = CredentialTypes.findCredentialType(credentials.credentials().getClass());
            Preconditions.checkArgument((credentialType != null ? 1 : 0) != 0, (Object)"the given credentials must be annotated with @CredentialType");
            builder.put((Object)credentialType.value(), credentials.credentials());
            if (credentials != null) {
                if (!Strings.isNullOrEmpty((String)credentials.tenantOrDomainId())) {
                    builder.put((Object)"tenantId", (Object)credentials.tenantOrDomainId());
                } else if (!Strings.isNullOrEmpty((String)credentials.tenantOrDomainName())) {
                    builder.put((Object)"tenantName", (Object)credentials.tenantOrDomainName());
                }
            }
        }
        HttpRequest authRequest = super.bindToRequest(request, (Map)ImmutableMap.of((Object)"auth", (Object)builder.build()));
        authRequest.getPayload().setSensitive(true);
        return (R)authRequest;
    }
}

