/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import org.jclouds.azurecompute.arm.domain.AutoValue_LoadBalancingRuleProperties;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class LoadBalancingRuleProperties {
    @Nullable
    public abstract IdReference frontendIPConfiguration();

    @Nullable
    public abstract IdReference backendAddressPool();

    public abstract Protocol protocol();

    public abstract int frontendPort();

    public abstract int backendPort();

    @Nullable
    public abstract IdReference probe();

    @Nullable
    public abstract Boolean enableFloatingIP();

    @Nullable
    public abstract Integer idleTimeoutInMinutes();

    @Nullable
    public abstract LoadDistribution loadDistribution();

    @Nullable
    public abstract String provisioningState();

    @SerializedNames(value={"frontendIPConfiguration", "backendAddressPool", "protocol", "frontendPort", "backendPort", "probe", "enableFloatingIP", "idleTimeoutInMinutes", "loadDistribution", "provisioningState"})
    public static LoadBalancingRuleProperties create(IdReference frontendIPConfiguration, IdReference backendAddressPool, Protocol protocol, int frontendPort, int backendPort, IdReference probe, Boolean enableFloatingIP, Integer idleTimeoutInMinutes, LoadDistribution loadDistribution, String provisioningState) {
        return LoadBalancingRuleProperties.builder().frontendIPConfiguration(frontendIPConfiguration).backendAddressPool(backendAddressPool).protocol(protocol).frontendPort(frontendPort).backendPort(backendPort).probe(probe).enableFloatingIP(enableFloatingIP).idleTimeoutInMinutes(idleTimeoutInMinutes).loadDistribution(loadDistribution).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_LoadBalancingRuleProperties.Builder();
    }

    public static abstract class Builder {
        public abstract Builder frontendIPConfiguration(IdReference var1);

        public abstract Builder backendAddressPool(IdReference var1);

        public abstract Builder protocol(Protocol var1);

        public abstract Builder frontendPort(int var1);

        public abstract Builder backendPort(int var1);

        public abstract Builder probe(IdReference var1);

        public abstract Builder enableFloatingIP(Boolean var1);

        public abstract Builder idleTimeoutInMinutes(Integer var1);

        public abstract Builder loadDistribution(LoadDistribution var1);

        public abstract Builder provisioningState(String var1);

        public abstract LoadBalancingRuleProperties build();
    }

    public static enum LoadDistribution {
        Default("Default"),
        SourceIp("SourceIP"),
        SourceIPProtocol("SourceIPProtocol"),
        UNRECOGNIZED("Unrecognized");

        private final String label;

        private LoadDistribution(String label) {
            this.label = label;
        }

        public static LoadDistribution fromValue(String text) {
            return (LoadDistribution)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum Protocol {
        Tcp("Tcp"),
        Udp("Udp"),
        UNRECOGNIZED("Unrecognized");

        private final String label;

        private Protocol(String label) {
            this.label = label;
        }

        public static Protocol fromValue(String text) {
            return (Protocol)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }

        public String toString() {
            return this.label;
        }
    }
}

