/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.SoftwareDescription;

public class ProductItem {
    private final int id;
    private final String description;
    private final String softwareDescriptionId;
    private final SoftwareDescription softwareDescription;

    @ConstructorProperties(value={"id", "description", "softwareDescriptionId", "softwareDescription"})
    public ProductItem(int id, @Nullable String description, @Nullable String softwareDescriptionId, @Nullable SoftwareDescription softwareDescription) {
        this.id = id;
        this.description = description;
        this.softwareDescriptionId = softwareDescriptionId;
        this.softwareDescription = softwareDescription;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSoftwareDescriptionId() {
        return this.softwareDescriptionId;
    }

    public SoftwareDescription getSoftwareDescription() {
        return this.softwareDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductItem that = (ProductItem)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.softwareDescriptionId, (Object)that.softwareDescriptionId) && Objects.equal((Object)this.softwareDescription, (Object)that.softwareDescription);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.description, this.softwareDescriptionId, this.softwareDescription});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("description", (Object)this.description).add("softwareDescriptionId", (Object)this.softwareDescriptionId).add("softwareDescription", (Object)this.softwareDescription).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ProductItem.builder().fromProductItem(this);
    }

    public static class Builder {
        private int id;
        private String description;
        private String softwareDescriptionId;
        private SoftwareDescription softwareDescription;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder softwareDescriptionId(String softwareDescriptionId) {
            this.softwareDescriptionId = softwareDescriptionId;
            return this;
        }

        public Builder softwareDescription(SoftwareDescription softwareDescription) {
            this.softwareDescription = softwareDescription;
            return this;
        }

        public ProductItem build() {
            return new ProductItem(this.id, this.description, this.softwareDescriptionId, this.softwareDescription);
        }

        public Builder fromProductItem(ProductItem in) {
            return this.id(in.getId()).description(in.getDescription()).softwareDescriptionId(in.getSoftwareDescriptionId()).softwareDescription(in.getSoftwareDescription());
        }
    }
}

