/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.binders;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;

public class DirectionalRecordAndGeoGroupToXML
implements MapBinder {
    private static final String ADD_TEMPLATE = "<v01:addDirectionalPoolRecord><transactionID />%s%s%s</AddDirectionalRecordData></v01:addDirectionalPoolRecord>";
    private static final String UPDATE_TEMPLATE = "<v01:updateDirectionalPoolRecord><transactionID /><UpdateDirectionalRecordData directionalPoolRecordId=\"%s\">%s%s</UpdateDirectionalRecordData></v01:updateDirectionalPoolRecord>";
    private static final String NEWGROUP_TEMPLATE = "<GeolocationGroupData><GroupData groupingType=\"DEFINE_NEW_GROUP\" />%s</GeolocationGroupData>";
    private static final String EXISTINGGROUP_TEMPLATE = "<GeolocationGroupData><GroupData groupingType=\"ASSIGN_EXISTING_GROUP\" assignExistingGroupId=\"%s\" />%s</GeolocationGroupData>";

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        DirectionalPoolRecord record = (DirectionalPoolRecord)DirectionalPoolRecord.class.cast(postParams.get("record"));
        DirectionalGroup group = (DirectionalGroup)((Object)DirectionalGroup.class.cast(postParams.get("group")));
        String xml = DirectionalRecordAndGeoGroupToXML.toXML(postParams.get("poolId"), record, group, postParams.get("dirPoolRecordId"), postParams.get("groupId"));
        return (R)((HttpRequest.Builder)request.toBuilder().payload(xml)).build();
    }

    @VisibleForTesting
    static String toXML(Object poolId, DirectionalPoolRecord record, DirectionalGroup group, Object recordId, Object groupId) {
        if (poolId == null) {
            if (group != null) {
                return String.format(UPDATE_TEMPLATE, recordId, DirectionalRecordAndGeoGroupToXML.updateRecord(record), DirectionalRecordAndGeoGroupToXML.geo(group));
            }
            return String.format(UPDATE_TEMPLATE, recordId, DirectionalRecordAndGeoGroupToXML.updateRecord(record), "");
        }
        if (group == null && groupId == null) {
            return String.format(ADD_TEMPLATE, String.format("<AddDirectionalRecordData directionalPoolId=\"%s\" createAllNonConfiguredGrp=\"true\">", poolId), DirectionalRecordAndGeoGroupToXML.createRecord(record), "");
        }
        String addRecordToPool = String.format("<AddDirectionalRecordData directionalPoolId=\"%s\">", poolId);
        if (groupId != null) {
            return String.format(ADD_TEMPLATE, addRecordToPool, DirectionalRecordAndGeoGroupToXML.createRecord(record), String.format(EXISTINGGROUP_TEMPLATE, groupId, ""));
        }
        return String.format(ADD_TEMPLATE, addRecordToPool, DirectionalRecordAndGeoGroupToXML.createRecord(record), String.format(NEWGROUP_TEMPLATE, DirectionalRecordAndGeoGroupToXML.geo(group)));
    }

    private static String createRecord(DirectionalPoolRecord record) {
        StringBuilder recordConfig = new StringBuilder();
        recordConfig.append("<DirectionalRecordConfiguration recordType=\"").append(record.getType()).append('\"');
        recordConfig.append(" TTL=\"").append(record.getTTL()).append('\"');
        recordConfig.append(" noResponseRecord=\"").append(record.isNoResponseRecord()).append("\" >");
        recordConfig.append(DirectionalRecordAndGeoGroupToXML.values(record));
        recordConfig.append("</DirectionalRecordConfiguration>");
        return recordConfig.toString();
    }

    private static String updateRecord(DirectionalPoolRecord record) {
        return String.format("<DirectionalRecordConfiguration TTL=\"%s\" >%s</DirectionalRecordConfiguration>", record.getTTL(), DirectionalRecordAndGeoGroupToXML.values(record));
    }

    private static String values(DirectionalPoolRecord record) {
        StringBuilder values = new StringBuilder("<InfoValues");
        for (int i = 0; i < record.getRData().size(); ++i) {
            values.append(' ').append("Info").append(i + 1).append("Value=").append('\"').append(record.getRData().get(i)).append('\"');
        }
        values.append(" />");
        return values.toString();
    }

    private static String geo(DirectionalGroup group) {
        StringBuilder groupData = new StringBuilder();
        groupData.append("<GeolocationGroupDetails groupName=\"").append(group.getName()).append('\"');
        if (group.getDescription().isPresent()) {
            groupData.append(" description=\"").append((String)group.getDescription().get()).append('\"');
        }
        groupData.append(" >");
        for (Map.Entry region : group.asMap().entrySet()) {
            groupData.append("<GeolocationGroupDefinitionData regionName=\"").append((String)region.getKey()).append('\"');
            groupData.append(" territoryNames=\"").append(Joiner.on((char)';').join((Iterable)region.getValue())).append("\" />");
        }
        groupData.append("</GeolocationGroupDetails>");
        return groupData.toString();
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("use map form");
    }
}

