/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;

public class DirectionalPoolPredicates {
    public static Predicate<DirectionalPool> idEqualTo(String id) {
        return new IdEqualToPredicate(id);
    }

    public static Predicate<DirectionalPoolRecordDetail> recordIdEqualTo(String recordId) {
        return new RecordIdEqualToPredicate(recordId);
    }

    private static final class RecordIdEqualToPredicate
    implements Predicate<DirectionalPoolRecordDetail> {
        private final String recordId;

        public RecordIdEqualToPredicate(String recordId) {
            this.recordId = (String)Preconditions.checkNotNull((Object)recordId, (Object)"recordId");
        }

        public boolean apply(DirectionalPoolRecordDetail input) {
            return input != null && this.recordId.equals(input.getId());
        }

        public String toString() {
            return "RecordIdEqualTo(" + this.recordId + ")";
        }
    }

    private static final class IdEqualToPredicate
    implements Predicate<DirectionalPool> {
        private final String id;

        public IdEqualToPredicate(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        }

        public boolean apply(DirectionalPool input) {
            return input != null && this.id.equals(input.getId());
        }

        public String toString() {
            return "IdEqualTo(" + this.id + ")";
        }
    }
}

