/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public abstract class AttributeHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<String> {
    private final String attributeName;
    private String attribute = null;

    private AttributeHandler(String attributeName) {
        this.attributeName = (String)Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
    }

    public String getResult() {
        return (String)Preconditions.checkNotNull((Object)this.attribute, (String)"%s not present in the response", (Object[])new Object[]{this.attributeName});
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (this.attribute == null && attributes.containsKey(this.attributeName)) {
            this.attribute = (String)attributes.get(this.attributeName);
        }
    }

    public static class PoolName
    extends AttributeHandler {
        public PoolName() {
            super("PoolName");
        }
    }
}

