/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jorphan.math.NumberComparator;

public class DistributionGraph
extends JComponent
implements Scrollable,
Clearable {
    private static final long serialVersionUID = 240L;
    private SamplingStatCalculator model;
    private static final int xborder = 30;

    public DistributionGraph() {
        this.init();
    }

    public DistributionGraph(SamplingStatCalculator model) {
        this();
        this.setModel(model);
    }

    private void init() {
        this.repaint();
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    private void setModel(Object model) {
        this.model = (SamplingStatCalculator)model;
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)((double)visibleRect.width * 0.9);
    }

    public void clearData() {
        this.model.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        SamplingStatCalculator m;
        super.paintComponent(g);
        SamplingStatCalculator samplingStatCalculator = m = this.model;
        synchronized (samplingStatCalculator) {
            this.drawSample(m, g);
        }
    }

    private void drawSample(SamplingStatCalculator p_model, Graphics g) {
        int width = this.getWidth();
        double height = (double)this.getHeight() - 1.0;
        for (int y = 0; y < 4; ++y) {
            int q1 = (int)(height - height * 0.25 * (double)y);
            g.setColor(Color.lightGray);
            g.drawLine(30, q1, width, q1);
            g.setColor(Color.black);
            g.drawString(String.valueOf(25 * y + "%"), 0, q1);
        }
        g.setColor(Color.black);
        g.drawLine(30, (int)height, width, (int)height);
        g.drawLine(30, 0, 30, (int)height);
        if (p_model != null && p_model.getCount() > 50L) {
            Number ninety = p_model.getPercentPoint(0.9);
            Number fifty = p_model.getPercentPoint(0.5);
            long total = p_model.getCount();
            Collection values = p_model.getDistribution().values();
            Number[][] objval = (Number[][])values.toArray((T[])new Number[values.size()][]);
            Arrays.sort(objval, new NumberComparator());
            int len = objval.length;
            for (int count = 0; count < len; ++count) {
                Number[] num = objval[count];
                double iper = (double)num[1].intValue() / (double)total;
                double iheight = height * iper;
                if (iheight < 1.0) {
                    iheight = 1.0;
                }
                int ix = count * 4 + 30 + 5;
                int dheight = (int)(height - iheight);
                g.setColor(Color.blue);
                g.drawLine(ix - 1, (int)height, ix - 1, dheight);
                g.drawLine(ix, (int)height, ix, dheight);
                g.setColor(Color.black);
                if (num[0].longValue() == ninety.longValue()) {
                    g.setColor(Color.red);
                    g.drawLine(ix, (int)height, ix, 55);
                    g.drawLine(ix, 35, ix, 0);
                    g.drawString("90%", ix - 30, 20);
                    g.drawString(String.valueOf(num[0].longValue()), ix + 8, 20);
                }
                if (num[0].longValue() != fifty.longValue()) continue;
                g.setColor(Color.orange);
                g.drawLine(ix, (int)height, ix, 30);
                g.drawString("50%", ix - 30, 50);
                g.drawString(String.valueOf(num[0].longValue()), ix + 8, 50);
            }
        }
    }
}

