/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.kafka.common.record.KafkaLZ4BlockInputStream;
import org.apache.kafka.common.record.KafkaLZ4BlockOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KafkaLZ4Test {
    private final boolean useBrokenFlagDescriptorChecksum;
    private final boolean ignoreFlagDescriptorChecksum;
    private final byte[] payload;

    public KafkaLZ4Test(boolean useBrokenFlagDescriptorChecksum, boolean ignoreFlagDescriptorChecksum, byte[] payload) {
        this.useBrokenFlagDescriptorChecksum = useBrokenFlagDescriptorChecksum;
        this.ignoreFlagDescriptorChecksum = ignoreFlagDescriptorChecksum;
        this.payload = payload;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        byte[] payload = new byte[1000];
        Arrays.fill(payload, (byte)1);
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (boolean broken : Arrays.asList(false, true)) {
            for (boolean ignore : Arrays.asList(false, true)) {
                values.add(new Object[]{broken, ignore, payload});
            }
        }
        return values;
    }

    @Test
    public void testKafkaLZ4() throws IOException {
        boolean contentSize;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        KafkaLZ4BlockOutputStream lz4 = new KafkaLZ4BlockOutputStream((OutputStream)output, this.useBrokenFlagDescriptorChecksum);
        lz4.write(this.payload, 0, this.payload.length);
        lz4.flush();
        byte[] compressed = output.toByteArray();
        int offset = 0;
        Assert.assertEquals((long)compressed[offset++], (long)4L);
        Assert.assertEquals((long)compressed[offset++], (long)34L);
        Assert.assertEquals((long)compressed[offset++], (long)77L);
        Assert.assertEquals((long)compressed[offset++], (long)24L);
        byte flg = compressed[offset++];
        int version = flg >>> 6 & 3;
        Assert.assertEquals((long)version, (long)1L);
        int reserved = flg & 3;
        Assert.assertEquals((long)reserved, (long)0L);
        byte bd = compressed[offset++];
        int blockMaxSize = bd >>> 4 & 7;
        Assert.assertTrue((blockMaxSize >= 4 ? 1 : 0) != 0);
        Assert.assertTrue((blockMaxSize <= 7 ? 1 : 0) != 0);
        reserved = bd & 0xF;
        Assert.assertEquals((long)reserved, (long)0L);
        reserved = bd >>> 7 & 1;
        Assert.assertEquals((long)reserved, (long)0L);
        boolean bl = contentSize = (flg >>> 3 & 1) != 0;
        if (contentSize) {
            offset += 8;
        }
        int off = 4;
        int len = offset - 4;
        if (this.useBrokenFlagDescriptorChecksum) {
            off = 0;
            len = offset;
        }
        int hash = XXHashFactory.fastestInstance().hash32().hash(compressed, off, len, 0);
        byte hc = compressed[offset++];
        Assert.assertEquals((long)hc, (long)((byte)(hash >> 8 & 0xFF)));
        ByteArrayInputStream input = new ByteArrayInputStream(compressed);
        try {
            KafkaLZ4BlockInputStream decompressed = new KafkaLZ4BlockInputStream((InputStream)input, this.ignoreFlagDescriptorChecksum);
            byte[] testPayload = new byte[this.payload.length];
            int ret = decompressed.read(testPayload, 0, this.payload.length);
            Assert.assertEquals((long)ret, (long)this.payload.length);
            Assert.assertArrayEquals((byte[])this.payload, (byte[])testPayload);
        }
        catch (IOException e) {
            Assert.assertTrue((this.useBrokenFlagDescriptorChecksum && !this.ignoreFlagDescriptorChecksum ? 1 : 0) != 0);
        }
    }
}

